/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settings;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.settings.CreateNetworkConnectivityConfigRequest;
import com.databricks.sdk.service.settings.CreatePrivateEndpointRuleRequest;
import com.databricks.sdk.service.settings.DeleteNetworkConnectivityConfigurationRequest;
import com.databricks.sdk.service.settings.DeletePrivateEndpointRuleRequest;
import com.databricks.sdk.service.settings.GetNetworkConnectivityConfigurationRequest;
import com.databricks.sdk.service.settings.GetPrivateEndpointRuleRequest;
import com.databricks.sdk.service.settings.ListNccAzurePrivateEndpointRulesResponse;
import com.databricks.sdk.service.settings.ListNetworkConnectivityConfigurationsRequest;
import com.databricks.sdk.service.settings.ListNetworkConnectivityConfigurationsResponse;
import com.databricks.sdk.service.settings.ListPrivateEndpointRulesRequest;
import com.databricks.sdk.service.settings.NccAzurePrivateEndpointRule;
import com.databricks.sdk.service.settings.NetworkConnectivityConfiguration;
import com.databricks.sdk.service.settings.NetworkConnectivityService;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class NetworkConnectivityImpl
implements NetworkConnectivityService {
    private final ApiClient apiClient;

    public NetworkConnectivityImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public NetworkConnectivityConfiguration createNetworkConnectivityConfiguration(CreateNetworkConnectivityConfigRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, NetworkConnectivityConfiguration.class, headers);
    }

    @Override
    public NccAzurePrivateEndpointRule createPrivateEndpointRule(CreatePrivateEndpointRuleRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s/private-endpoint-rules", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, NccAzurePrivateEndpointRule.class, headers);
    }

    @Override
    public void deleteNetworkConnectivityConfiguration(DeleteNetworkConnectivityConfigurationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, Void.class, headers);
    }

    @Override
    public NccAzurePrivateEndpointRule deletePrivateEndpointRule(DeletePrivateEndpointRuleRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s/private-endpoint-rules/%s", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId(), request.getPrivateEndpointRuleId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.DELETE(path, request, NccAzurePrivateEndpointRule.class, headers);
    }

    @Override
    public NetworkConnectivityConfiguration getNetworkConnectivityConfiguration(GetNetworkConnectivityConfigurationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, NetworkConnectivityConfiguration.class, headers);
    }

    @Override
    public NccAzurePrivateEndpointRule getPrivateEndpointRule(GetPrivateEndpointRuleRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s/private-endpoint-rules/%s", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId(), request.getPrivateEndpointRuleId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, NccAzurePrivateEndpointRule.class, headers);
    }

    @Override
    public ListNetworkConnectivityConfigurationsResponse listNetworkConnectivityConfigurations(ListNetworkConnectivityConfigurationsRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListNetworkConnectivityConfigurationsResponse.class, headers);
    }

    @Override
    public ListNccAzurePrivateEndpointRulesResponse listPrivateEndpointRules(ListPrivateEndpointRulesRequest request) {
        String path = String.format("/api/2.0/accounts/%s/network-connectivity-configs/%s/private-endpoint-rules", this.apiClient.configuredAccountID(), request.getNetworkConnectivityConfigId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListNccAzurePrivateEndpointRulesResponse.class, headers);
    }
}

