/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.serving;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.serving.AppManifest;
import com.databricks.sdk.service.serving.AppsImpl;
import com.databricks.sdk.service.serving.AppsService;
import com.databricks.sdk.service.serving.DeleteAppRequest;
import com.databricks.sdk.service.serving.DeleteAppResponse;
import com.databricks.sdk.service.serving.DeployAppRequest;
import com.databricks.sdk.service.serving.DeploymentStatus;
import com.databricks.sdk.service.serving.GetAppDeploymentStatusRequest;
import com.databricks.sdk.service.serving.GetAppRequest;
import com.databricks.sdk.service.serving.GetAppResponse;
import com.databricks.sdk.service.serving.GetEventsRequest;
import com.databricks.sdk.service.serving.ListAppEventsResponse;
import com.databricks.sdk.service.serving.ListAppsResponse;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class AppsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(AppsAPI.class);
    private final AppsService impl;

    public AppsAPI(ApiClient apiClient) {
        this.impl = new AppsImpl(apiClient);
    }

    public AppsAPI(AppsService mock) {
        this.impl = mock;
    }

    public DeploymentStatus create(AppManifest manifest) {
        return this.create(new DeployAppRequest().setManifest(manifest));
    }

    public DeploymentStatus create(DeployAppRequest request) {
        return this.impl.create(request);
    }

    public DeleteAppResponse deleteApp(String name) {
        return this.deleteApp(new DeleteAppRequest().setName(name));
    }

    public DeleteAppResponse deleteApp(DeleteAppRequest request) {
        return this.impl.deleteApp(request);
    }

    public GetAppResponse getApp(String name) {
        return this.getApp(new GetAppRequest().setName(name));
    }

    public GetAppResponse getApp(GetAppRequest request) {
        return this.impl.getApp(request);
    }

    public DeploymentStatus getAppDeploymentStatus(String deploymentId) {
        return this.getAppDeploymentStatus(new GetAppDeploymentStatusRequest().setDeploymentId(deploymentId));
    }

    public DeploymentStatus getAppDeploymentStatus(GetAppDeploymentStatusRequest request) {
        return this.impl.getAppDeploymentStatus(request);
    }

    public ListAppsResponse getApps() {
        return this.impl.getApps();
    }

    public ListAppEventsResponse getEvents(String name) {
        return this.getEvents(new GetEventsRequest().setName(name));
    }

    public ListAppEventsResponse getEvents(GetEventsRequest request) {
        return this.impl.getEvents(request);
    }

    public AppsService impl() {
        return this.impl;
    }
}

