/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.ConfigAttribute;
import com.databricks.sdk.core.ConfigAttributeAccessor;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigLoader.class);
    private static final List<ConfigAttributeAccessor> accessors = ConfigLoader.attributeAccessors();

    static List<ConfigAttributeAccessor> attributeAccessors() {
        ArrayList<ConfigAttributeAccessor> attrs = new ArrayList<ConfigAttributeAccessor>();
        for (Field field : DatabricksConfig.class.getDeclaredFields()) {
            ConfigAttribute attribute = field.getAnnotation(ConfigAttribute.class);
            if (attribute == null) continue;
            attrs.add(new ConfigAttributeAccessor(attribute, field));
        }
        return attrs;
    }

    public static DatabricksConfig resolve(DatabricksConfig cfg) throws DatabricksException {
        try {
            ConfigLoader.loadFromEnvironmentVariables(cfg);
            ConfigLoader.loadFromConfig(cfg);
            return cfg;
        }
        catch (IllegalAccessException e) {
            throw new DatabricksException("Cannot create default config", e);
        }
    }

    static void loadFromEnvironmentVariables(DatabricksConfig cfg) throws IllegalAccessException {
        if (cfg.getEnv() == null) {
            return;
        }
        try {
            for (ConfigAttributeAccessor accessor : accessors) {
                Object value;
                String env = cfg.getEnv().get(accessor.getEnvVariable());
                if (ConfigLoader.isNullOrEmpty(env) || !ConfigLoader.isNullOrEmpty(value = accessor.getValueFromConfig(cfg))) continue;
                accessor.setValueOnConfig(cfg, env);
            }
        }
        catch (DatabricksException e) {
            String msg = String.format("%s auth: %s", cfg.getCredentialsProvider().authType(), e.getMessage());
            throw new DatabricksException(msg, e);
        }
    }

    static void loadFromConfig(DatabricksConfig cfg) throws IllegalAccessException {
        Profile.Section section;
        boolean hasExplicitProfile;
        if (ConfigLoader.isNullOrEmpty(cfg.getProfile()) && (ConfigLoader.isAnyAuthConfigured(cfg) || !ConfigLoader.isNullOrEmpty(cfg.getHost()) || !ConfigLoader.isNullOrEmpty(cfg.getAzureWorkspaceResourceId()))) {
            return;
        }
        String userHome = cfg.getEnv().get("HOME");
        if (ConfigLoader.isNullOrEmpty(userHome)) {
            userHome = System.getProperty("user.home");
        }
        String configFile = cfg.getConfigFile();
        boolean isDefaultConfig = false;
        if (ConfigLoader.isNullOrEmpty(configFile)) {
            configFile = Paths.get(userHome, ".databrickscfg").toString();
            isDefaultConfig = true;
        } else {
            configFile = configFile.replaceFirst("^~", userHome);
        }
        Ini ini = ConfigLoader.parseDatabricksCfg(configFile, isDefaultConfig);
        if (ini == null) {
            return;
        }
        String profile = cfg.getProfile();
        boolean bl = hasExplicitProfile = !ConfigLoader.isNullOrEmpty(profile);
        if (!hasExplicitProfile) {
            profile = "DEFAULT";
        }
        if ((section = (Profile.Section)ini.get((Object)profile)) == null && !hasExplicitProfile) {
            LOG.info("{} has no {} profile configured", (Object)configFile, (Object)profile);
            return;
        }
        if (section == null) {
            String msg = String.format("resolve: %s has no %s profile configured", configFile, profile);
            throw new DatabricksException(msg);
        }
        for (ConfigAttributeAccessor accessor : accessors) {
            String value = (String)section.get((Object)accessor.getName());
            if (!ConfigLoader.isNullOrEmpty(accessor.getValueFromConfig(cfg))) continue;
            accessor.setValueOnConfig(cfg, value);
        }
    }

    private static Ini parseDatabricksCfg(String configFile, boolean isDefaultConfig) {
        Ini ini = new Ini();
        try {
            ini.load(new File(configFile));
        }
        catch (FileNotFoundException e) {
            if (isDefaultConfig) {
                return null;
            }
        }
        catch (IOException e) {
            throw new DatabricksException("Cannot load " + configFile, e);
        }
        return ini;
    }

    public static void fixHostIfNeeded(DatabricksConfig cfg) {
        URL url;
        if (ConfigLoader.isNullOrEmpty(cfg.getHost())) {
            return;
        }
        String host = cfg.getHost();
        try {
            url = new URL(host);
        }
        catch (MalformedURLException e) {
            cfg.setHost("https://" + host);
            return;
        }
        cfg.setHost(url.getProtocol() + "://" + url.getAuthority());
    }

    static void validate(DatabricksConfig cfg) throws DatabricksException {
        try {
            if (!ConfigLoader.isNullOrEmpty(cfg.getAuthType())) {
                return;
            }
            TreeSet<String> authSet = new TreeSet<String>();
            for (ConfigAttributeAccessor accessor : accessors) {
                String authType;
                Object value = accessor.getValueFromConfig(cfg);
                if (ConfigLoader.isNullOrEmpty(value) || ConfigLoader.isNullOrEmpty(authType = accessor.getAuthType())) continue;
                authSet.add(authType);
            }
            if (authSet.size() <= 1) {
                return;
            }
            String names = String.join((CharSequence)" and ", authSet);
            throw new DatabricksException(String.format("validate: more than one authorization method configured: %s", names));
        }
        catch (IllegalAccessException e) {
            throw new DatabricksException("Cannot create default config", e);
        }
    }

    public static DatabricksException makeNicerError(String message, Exception e, DatabricksConfig cfg) {
        return ConfigLoader.makeNicerError(message, e, 200, cfg);
    }

    public static DatabricksException makeNicerError(String message, Exception e, Integer statusCode, DatabricksConfig cfg) {
        boolean isHttpUnauthorizedOrForbidden = true;
        if (statusCode == 401 || statusCode == 402) {
            isHttpUnauthorizedOrForbidden = true;
        }
        String debugString = "";
        if (cfg.getEnv() != null) {
            debugString = ConfigLoader.debugString(cfg);
        }
        if (!debugString.isEmpty() && isHttpUnauthorizedOrForbidden) {
            message = String.format("%s. %s", message, debugString);
        }
        return new DatabricksException(message, e);
    }

    public static String debugString(DatabricksConfig cfg) {
        try {
            ArrayList<String> envsUsed = new ArrayList<String>();
            ArrayList<String> attrsUsed = new ArrayList<String>();
            ArrayList<String> buf = new ArrayList<String>();
            Map<String, String> getEnvAllEnv = cfg.getEnv().getEnv();
            for (ConfigAttributeAccessor accessor : accessors) {
                Object value;
                String envVariable = accessor.getEnvVariable();
                String envValue = accessor.getEnv(getEnvAllEnv);
                if (!ConfigLoader.isNullOrEmpty(envValue) && !ConfigLoader.isNullOrEmpty(envVariable)) {
                    envsUsed.add(String.format("%s", envVariable));
                }
                if (ConfigLoader.isNullOrEmpty(value = accessor.getValueFromConfig(cfg))) continue;
                String valueAsString = accessor.getAsString(value);
                if (accessor.isSensitive().booleanValue()) {
                    valueAsString = "***";
                }
                String name = accessor.getName();
                attrsUsed.add(String.format("%s=%s", name, valueAsString));
            }
            if (!attrsUsed.isEmpty()) {
                buf.add(String.format("Config: %s", String.join((CharSequence)", ", attrsUsed)));
            }
            if (!envsUsed.isEmpty()) {
                buf.add(String.format("Env: %s", String.join((CharSequence)", ", envsUsed)));
            }
            return String.join((CharSequence)". ", buf);
        }
        catch (IllegalAccessException e) {
            throw new DatabricksException(e.getMessage());
        }
    }

    public static DatabricksConfig getDefault() {
        DatabricksConfig cfg = new DatabricksConfig();
        return cfg.resolve();
    }

    public static boolean isNullOrEmpty(Object target) {
        return target == null || target.toString().isEmpty();
    }

    public static boolean isAnyAuthConfigured(DatabricksConfig cfg) throws IllegalAccessException {
        for (ConfigAttributeAccessor accessor : accessors) {
            Object value;
            if (ConfigLoader.isNullOrEmpty(accessor.getAuthType()) || ConfigLoader.isNullOrEmpty(value = accessor.getValueFromConfig(cfg))) continue;
            return true;
        }
        return false;
    }
}

