/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.error;

import com.databricks.sdk.core.DatabricksError;
import com.databricks.sdk.core.error.ApiErrorBody;
import com.databricks.sdk.core.error.ErrorDetail;
import com.databricks.sdk.core.error.ErrorOverride;
import com.databricks.sdk.core.error.ErrorOverrides;
import com.databricks.sdk.core.http.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractErrorMapper {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractErrorMapper.class);
    private final Map<Integer, StatusCodeRule> statusCodeMapping = new HashMap<Integer, StatusCodeRule>();
    private final Map<String, ErrorCodeRule> errorCodeMapping = new HashMap<String, ErrorCodeRule>();

    AbstractErrorMapper() {
    }

    public DatabricksError apply(Response resp, ApiErrorBody errorBody) {
        for (ErrorOverride<?> override : ErrorOverrides.ALL_OVERRIDES) {
            if (!override.matches(errorBody, resp)) continue;
            LOG.debug("Overriding error with {} (original status code: {}, original error code: {})", new Object[]{override.getDebugName(), resp.getStatusCode(), errorBody.getErrorCode()});
            return override.makeError(errorBody);
        }
        int code = resp.getStatusCode();
        String message = errorBody.getMessage();
        String errorCode = errorBody.getErrorCode();
        List<ErrorDetail> details = errorBody.getErrorDetails();
        if (this.errorCodeMapping.containsKey(errorCode)) {
            return this.errorCodeMapping.get(errorCode).create(message, details);
        }
        if (this.statusCodeMapping.containsKey(code)) {
            return this.statusCodeMapping.get(code).create(errorCode, message, details);
        }
        return new DatabricksError(errorCode, message, code, details);
    }

    protected void statusCode(int code, StatusCodeRule rule) {
        this.statusCodeMapping.put(code, rule);
    }

    protected void errorCode(String errorCode, ErrorCodeRule rule) {
        this.errorCodeMapping.put(errorCode, rule);
    }

    @FunctionalInterface
    protected static interface StatusCodeRule {
        public DatabricksError create(String var1, String var2, List<ErrorDetail> var3);
    }

    @FunctionalInterface
    protected static interface ErrorCodeRule {
        public DatabricksError create(String var1, List<ErrorDetail> var2);
    }
}

