/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.marketplace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.marketplace.AddExchangeForListingRequest;
import com.databricks.sdk.service.marketplace.AddExchangeForListingResponse;
import com.databricks.sdk.service.marketplace.CreateExchangeRequest;
import com.databricks.sdk.service.marketplace.CreateExchangeResponse;
import com.databricks.sdk.service.marketplace.DeleteExchangeRequest;
import com.databricks.sdk.service.marketplace.Exchange;
import com.databricks.sdk.service.marketplace.ExchangeListing;
import com.databricks.sdk.service.marketplace.GetExchangeRequest;
import com.databricks.sdk.service.marketplace.GetExchangeResponse;
import com.databricks.sdk.service.marketplace.ListExchangesForListingRequest;
import com.databricks.sdk.service.marketplace.ListExchangesForListingResponse;
import com.databricks.sdk.service.marketplace.ListExchangesRequest;
import com.databricks.sdk.service.marketplace.ListExchangesResponse;
import com.databricks.sdk.service.marketplace.ListListingsForExchangeRequest;
import com.databricks.sdk.service.marketplace.ListListingsForExchangeResponse;
import com.databricks.sdk.service.marketplace.ProviderExchangesImpl;
import com.databricks.sdk.service.marketplace.ProviderExchangesService;
import com.databricks.sdk.service.marketplace.RemoveExchangeForListingRequest;
import com.databricks.sdk.service.marketplace.UpdateExchangeRequest;
import com.databricks.sdk.service.marketplace.UpdateExchangeResponse;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ProviderExchangesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderExchangesAPI.class);
    private final ProviderExchangesService impl;

    public ProviderExchangesAPI(ApiClient apiClient) {
        this.impl = new ProviderExchangesImpl(apiClient);
    }

    public ProviderExchangesAPI(ProviderExchangesService mock) {
        this.impl = mock;
    }

    public AddExchangeForListingResponse addListingToExchange(String listingId, String exchangeId) {
        return this.addListingToExchange(new AddExchangeForListingRequest().setListingId(listingId).setExchangeId(exchangeId));
    }

    public AddExchangeForListingResponse addListingToExchange(AddExchangeForListingRequest request) {
        return this.impl.addListingToExchange(request);
    }

    public CreateExchangeResponse create(Exchange exchange) {
        return this.create(new CreateExchangeRequest().setExchange(exchange));
    }

    public CreateExchangeResponse create(CreateExchangeRequest request) {
        return this.impl.create(request);
    }

    public void delete(String id) {
        this.delete(new DeleteExchangeRequest().setId(id));
    }

    public void delete(DeleteExchangeRequest request) {
        this.impl.delete(request);
    }

    public void deleteListingFromExchange(String id) {
        this.deleteListingFromExchange(new RemoveExchangeForListingRequest().setId(id));
    }

    public void deleteListingFromExchange(RemoveExchangeForListingRequest request) {
        this.impl.deleteListingFromExchange(request);
    }

    public GetExchangeResponse get(String id) {
        return this.get(new GetExchangeRequest().setId(id));
    }

    public GetExchangeResponse get(GetExchangeRequest request) {
        return this.impl.get(request);
    }

    public Iterable<Exchange> list(ListExchangesRequest request) {
        return new Paginator(request, this.impl::list, ListExchangesResponse::getExchanges, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<ExchangeListing> listExchangesForListing(String listingId) {
        return this.listExchangesForListing(new ListExchangesForListingRequest().setListingId(listingId));
    }

    public Iterable<ExchangeListing> listExchangesForListing(ListExchangesForListingRequest request) {
        return new Paginator(request, this.impl::listExchangesForListing, ListExchangesForListingResponse::getExchangeListing, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public Iterable<ExchangeListing> listListingsForExchange(String exchangeId) {
        return this.listListingsForExchange(new ListListingsForExchangeRequest().setExchangeId(exchangeId));
    }

    public Iterable<ExchangeListing> listListingsForExchange(ListListingsForExchangeRequest request) {
        return new Paginator(request, this.impl::listListingsForExchange, ListListingsForExchangeResponse::getExchangeListings, response -> {
            String token = response.getNextPageToken();
            if (token == null) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public UpdateExchangeResponse update(String id, Exchange exchange) {
        return this.update(new UpdateExchangeRequest().setId(id).setExchange(exchange));
    }

    public UpdateExchangeResponse update(UpdateExchangeRequest request) {
        return this.impl.update(request);
    }

    public ProviderExchangesService impl() {
        return this.impl;
    }
}

