/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.AzureEnvironment;
import com.databricks.sdk.core.ConfigAttribute;
import com.databricks.sdk.core.ConfigLoader;
import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksEnvironment;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.DefaultCredentialsProvider;
import com.databricks.sdk.core.HeaderFactory;
import com.databricks.sdk.core.ProxyConfig;
import com.databricks.sdk.core.commons.CommonsHttpClient;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.core.http.Response;
import com.databricks.sdk.core.oauth.OpenIDConnectEndpoints;
import com.databricks.sdk.core.utils.Cloud;
import com.databricks.sdk.core.utils.Environment;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpMessage;

public class DatabricksConfig {
    private CredentialsProvider credentialsProvider = new DefaultCredentialsProvider();
    @ConfigAttribute(env="DATABRICKS_HOST")
    private String host;
    @ConfigAttribute(env="DATABRICKS_ACCOUNT_ID")
    private String accountId;
    @ConfigAttribute(env="DATABRICKS_TOKEN", auth="pat", sensitive=true)
    private String token;
    @ConfigAttribute(env="DATABRICKS_CLIENT_ID", auth="oauth")
    private String clientId;
    @ConfigAttribute(env="DATABRICKS_CLIENT_SECRET", auth="oauth", sensitive=true)
    private String clientSecret;
    @ConfigAttribute(env="DATABRICKS_SCOPES", auth="oauth")
    private List<String> scopes;
    @ConfigAttribute(env="DATABRICKS_REDIRECT_URL", auth="oauth")
    private String redirectUrl;
    @ConfigAttribute(env="DATABRICKS_USERNAME", auth="basic")
    private String username;
    @ConfigAttribute(env="DATABRICKS_PASSWORD", auth="basic", sensitive=true)
    private String password;
    @ConfigAttribute(env="DATABRICKS_CONFIG_PROFILE")
    private String profile;
    @ConfigAttribute(env="DATABRICKS_CONFIG_FILE")
    private String configFile;
    @ConfigAttribute(env="DATABRICKS_CLUSTER_ID")
    private String clusterId;
    @ConfigAttribute(env="DATABRICKS_SERVERLESS_COMPUTE_ID")
    private String serverlessComputeId;
    @ConfigAttribute(env="DATABRICKS_GOOGLE_SERVICE_ACCOUNT", auth="google")
    private String googleServiceAccount;
    @ConfigAttribute(env="GOOGLE_CREDENTIALS", auth="google", sensitive=true)
    private String googleCredentials;
    @ConfigAttribute(env="DATABRICKS_AZURE_RESOURCE_ID", auth="azure")
    private String azureWorkspaceResourceId;
    @ConfigAttribute(env="ARM_USE_MSI", auth="azure")
    private Boolean azureUseMsi;
    @ConfigAttribute(env="ARM_CLIENT_SECRET", auth="azure", sensitive=true)
    private String azureClientSecret;
    @ConfigAttribute(env="ARM_CLIENT_ID", auth="azure")
    private String azureClientId;
    @ConfigAttribute(env="ARM_TENANT_ID", auth="azure")
    private String azureTenantId;
    @ConfigAttribute(env="ARM_ENVIRONMENT")
    private String azureEnvironment;
    @ConfigAttribute(env="DATABRICKS_CLI_PATH")
    private String databricksCliPath;
    @ConfigAttribute(env="DATABRICKS_AUTH_TYPE")
    private String authType;
    @ConfigAttribute
    private Boolean skipVerify;
    @ConfigAttribute
    private Integer httpTimeoutSeconds;
    @ConfigAttribute(env="DATABRICKS_DEBUG_TRUNCATE_BYTES")
    private Integer debugTruncateBytes;
    @ConfigAttribute(env="DATABRICKS_DEBUG_HEADERS")
    private Boolean debugHeaders;
    @ConfigAttribute(env="DATABRICKS_RATE_LIMIT")
    private Integer rateLimit;
    @ConfigAttribute(env="PROXY_HOST")
    private String proxyHost;
    @ConfigAttribute(env="PROXY_PORT")
    private Integer proxyPort;
    @ConfigAttribute(env="PROXY_USERNAME")
    private String proxyUsername;
    @ConfigAttribute(env="PROXY_PASSWORD")
    private String proxyPassword;
    @ConfigAttribute(env="PROXY_AUTH_TYPE")
    private ProxyConfig.ProxyAuthType proxyAuthType;
    @ConfigAttribute(env="USE_SYSTEM_PROPERTIES_HTTP")
    private Boolean useSystemPropertiesHttp;
    private volatile boolean resolved;
    private HeaderFactory headerFactory;
    private HttpClient httpClient;
    private Environment env;
    private DatabricksEnvironment databricksEnvironment;

    public Environment getEnv() {
        return this.env;
    }

    public synchronized DatabricksConfig resolve() {
        String[] path = System.getenv("PATH").split(File.pathSeparator);
        Environment env = new Environment(System.getenv(), path, System.getProperty("os.name"));
        return this.resolve(env);
    }

    synchronized DatabricksConfig resolve(Environment env) {
        this.env = env;
        this.innerResolve();
        return this;
    }

    private synchronized DatabricksConfig innerResolve() {
        Objects.requireNonNull(this.env);
        try {
            ConfigLoader.resolve(this);
            ConfigLoader.validate(this);
            ConfigLoader.fixHostIfNeeded(this);
            this.initHttp();
            return this;
        }
        catch (DatabricksException e) {
            throw ConfigLoader.makeNicerError(e.getMessage(), e, this);
        }
    }

    private void initHttp() {
        if (this.httpClient != null) {
            return;
        }
        this.httpClient = new CommonsHttpClient(this);
    }

    public synchronized Map<String, String> authenticate() throws DatabricksException {
        try {
            if (this.headerFactory == null) {
                ConfigLoader.fixHostIfNeeded(this);
                this.headerFactory = this.credentialsProvider.configure(this);
                this.setAuthType(this.credentialsProvider.authType());
            }
            return this.headerFactory.headers();
        }
        catch (DatabricksException e) {
            String msg = String.format("%s auth: %s", this.credentialsProvider.authType(), e.getMessage());
            DatabricksException wrapperException = new DatabricksException(msg, e);
            throw ConfigLoader.makeNicerError(wrapperException.getMessage(), wrapperException, this);
        }
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public DatabricksConfig setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public DatabricksConfig setHost(String host) {
        this.host = host;
        return this;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public DatabricksConfig setAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public String getDatabricksCliPath() {
        return this.databricksCliPath;
    }

    public DatabricksConfig setDatabricksCliPath(String databricksCliPath) {
        this.databricksCliPath = databricksCliPath;
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public DatabricksConfig setToken(String token) {
        this.token = token;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public DatabricksConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public DatabricksConfig setClusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public String getServerlessComputeId() {
        return this.serverlessComputeId;
    }

    public DatabricksConfig setServerlessComputeId(String serverlessComputeId) {
        this.serverlessComputeId = serverlessComputeId;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public DatabricksConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public DatabricksConfig setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public DatabricksConfig setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String getOAuthRedirectUrl() {
        return this.redirectUrl;
    }

    public DatabricksConfig setOAuthRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public DatabricksConfig setScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public String getProfile() {
        return this.profile;
    }

    public DatabricksConfig setProfile(String profile) {
        this.profile = profile;
        return this;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public DatabricksConfig setConfigFile(String configFile) {
        this.configFile = configFile;
        return this;
    }

    public String getGoogleServiceAccount() {
        return this.googleServiceAccount;
    }

    public DatabricksConfig setGoogleServiceAccount(String googleServiceAccount) {
        this.googleServiceAccount = googleServiceAccount;
        return this;
    }

    public String getGoogleCredentials() {
        return this.googleCredentials;
    }

    public DatabricksConfig setGoogleCredentials(String googleCredentials) {
        this.googleCredentials = googleCredentials;
        return this;
    }

    public String getAzureWorkspaceResourceId() {
        return this.azureWorkspaceResourceId;
    }

    public DatabricksConfig setAzureWorkspaceResourceId(String azureWorkspaceResourceId) {
        this.azureWorkspaceResourceId = azureWorkspaceResourceId;
        return this;
    }

    public boolean getAzureUseMsi() {
        return this.azureUseMsi;
    }

    public DatabricksConfig setAzureUseMsi(boolean azureUseMsi) {
        this.azureUseMsi = azureUseMsi;
        return this;
    }

    @Deprecated
    public boolean getAzureUseMSI() {
        return this.azureUseMsi;
    }

    @Deprecated
    public DatabricksConfig setAzureUseMSI(boolean azureUseMsi) {
        this.azureUseMsi = azureUseMsi;
        return this;
    }

    public String getAzureClientSecret() {
        return this.azureClientSecret;
    }

    public DatabricksConfig setAzureClientSecret(String azureClientSecret) {
        this.azureClientSecret = azureClientSecret;
        return this;
    }

    public String getAzureClientId() {
        return this.azureClientId;
    }

    public DatabricksConfig setAzureClientId(String azureClientId) {
        this.azureClientId = azureClientId;
        return this;
    }

    public String getAzureTenantId() {
        return this.azureTenantId;
    }

    public DatabricksConfig setAzureTenantId(String azureTenantId) {
        this.azureTenantId = azureTenantId;
        return this;
    }

    public AzureEnvironment getAzureEnvironment() {
        String env = "PUBLIC";
        if (this.azureEnvironment != null) {
            env = this.azureEnvironment;
        }
        return AzureEnvironment.getEnvironment(env);
    }

    public DatabricksConfig setAzureEnvironment(String azureEnvironment) {
        this.azureEnvironment = azureEnvironment;
        return this;
    }

    public String getEffectiveAzureLoginAppId() {
        return this.getDatabricksEnvironment().getAzureApplicationId();
    }

    public String getAuthType() {
        return this.authType;
    }

    public DatabricksConfig setAuthType(String authType) {
        this.authType = authType;
        return this;
    }

    public boolean isSkipVerify() {
        return this.skipVerify;
    }

    public DatabricksConfig setSkipVerify(boolean skipVerify) {
        this.skipVerify = skipVerify;
        return this;
    }

    public Integer getHttpTimeoutSeconds() {
        return this.httpTimeoutSeconds;
    }

    public DatabricksConfig setHttpTimeoutSeconds(int httpTimeoutSeconds) {
        this.httpTimeoutSeconds = httpTimeoutSeconds;
        return this;
    }

    public Integer getDebugTruncateBytes() {
        return this.debugTruncateBytes;
    }

    public DatabricksConfig setDebugTruncateBytes(int debugTruncateBytes) {
        this.debugTruncateBytes = debugTruncateBytes;
        return this;
    }

    public boolean isDebugHeaders() {
        return this.debugHeaders != null && this.debugHeaders != false;
    }

    public DatabricksConfig setDebugHeaders(boolean debugHeaders) {
        this.debugHeaders = debugHeaders;
        return this;
    }

    public Integer getRateLimit() {
        return this.rateLimit;
    }

    public DatabricksConfig setRateLimit(int rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public DatabricksConfig setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public DatabricksConfig setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public DatabricksConfig setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public DatabricksConfig setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
        return this;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public DatabricksConfig setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
        return this;
    }

    public ProxyConfig.ProxyAuthType getProxyAuthType() {
        return this.proxyAuthType;
    }

    public DatabricksConfig setProxyAuthType(ProxyConfig.ProxyAuthType proxyAuthType) {
        this.proxyAuthType = proxyAuthType;
        return this;
    }

    public Boolean getUseSystemPropertiesHttp() {
        return this.useSystemPropertiesHttp;
    }

    public DatabricksConfig setUseSystemPropertiesHttp(Boolean useSystemPropertiesHttp) {
        this.useSystemPropertiesHttp = useSystemPropertiesHttp;
        return this;
    }

    public boolean isAzure() {
        if (this.azureWorkspaceResourceId != null) {
            return true;
        }
        return this.getDatabricksEnvironment().getCloud() == Cloud.AZURE;
    }

    public synchronized void authenticate(HttpMessage request) {
        Map<String, String> headers = this.authenticate();
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.setHeader(e.getKey(), e.getValue());
        }
    }

    public boolean isGcp() {
        return this.getDatabricksEnvironment().getCloud() == Cloud.GCP;
    }

    public boolean isAws() {
        return this.getDatabricksEnvironment().getCloud() == Cloud.AWS;
    }

    public boolean isAccountClient() {
        if (this.host == null) {
            return false;
        }
        return this.host.startsWith("https://accounts.") || this.host.startsWith("https://accounts-dod.");
    }

    public OpenIDConnectEndpoints getOidcEndpoints() throws IOException {
        if (this.getHost() == null) {
            return null;
        }
        if (this.isAzure() && this.getAzureClientId() != null) {
            Request request = new Request("GET", this.getHost() + "/oidc/oauth2/v2.0/authorize");
            request.setRedirectionBehavior(false);
            Response resp = this.getHttpClient().execute(request);
            String realAuthUrl = resp.getFirstHeader("location");
            if (realAuthUrl == null) {
                return null;
            }
            return new OpenIDConnectEndpoints(realAuthUrl.replaceAll("/authorize", "/token"), realAuthUrl);
        }
        if (this.isAccountClient() && this.getAccountId() != null) {
            String prefix = this.getHost() + "/oidc/accounts/" + this.getAccountId();
            return new OpenIDConnectEndpoints(prefix + "/v1/token", prefix + "/v1/authorize");
        }
        String oidcEndpoint = this.getHost() + "/oidc/.well-known/oauth-authorization-server";
        Response resp = this.getHttpClient().execute(new Request("GET", oidcEndpoint));
        if (resp.getStatusCode() != 200) {
            return null;
        }
        return (OpenIDConnectEndpoints)new ObjectMapper().readValue(resp.getBody(), OpenIDConnectEndpoints.class);
    }

    public String toString() {
        return ConfigLoader.debugString(this);
    }

    public DatabricksConfig setDatabricksEnvironment(DatabricksEnvironment databricksEnvironment) {
        this.databricksEnvironment = databricksEnvironment;
        return this;
    }

    public DatabricksEnvironment getDatabricksEnvironment() {
        ConfigLoader.fixHostIfNeeded(this);
        if (this.databricksEnvironment != null) {
            return this.databricksEnvironment;
        }
        if (this.host == null && this.azureWorkspaceResourceId != null) {
            String azureEnv = "PUBLIC";
            if (this.azureEnvironment != null) {
                azureEnv = this.azureEnvironment;
            }
            for (DatabricksEnvironment env : DatabricksEnvironment.ALL_ENVIRONMENTS) {
                if (env.getCloud() != Cloud.AZURE || !env.getAzureEnvironment().getName().equals(azureEnv) || env.getDnsZone().startsWith(".dev") || env.getDnsZone().startsWith(".staging")) continue;
                return env;
            }
        }
        return DatabricksEnvironment.getEnvironmentFromHostname(this.host);
    }

    public DatabricksConfig newWithWorkspaceHost(String host) {
        HashSet<String> fieldsToSkip = new HashSet<String>(Arrays.asList("host", "accountId", "azureWorkspaceResourceId", "authType", "headerFactory"));
        DatabricksConfig newConfig = new DatabricksConfig();
        for (Field f : DatabricksConfig.class.getDeclaredFields()) {
            if (fieldsToSkip.contains(f.getName())) continue;
            try {
                f.set(newConfig, f.get(this));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        newConfig.setHost(host);
        return newConfig;
    }
}

