/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.apps;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.apps.App;
import com.databricks.sdk.service.apps.AppDeployment;
import com.databricks.sdk.service.apps.AppPermissions;
import com.databricks.sdk.service.apps.AppPermissionsRequest;
import com.databricks.sdk.service.apps.AppsService;
import com.databricks.sdk.service.apps.CreateAppDeploymentRequest;
import com.databricks.sdk.service.apps.CreateAppRequest;
import com.databricks.sdk.service.apps.DeleteAppRequest;
import com.databricks.sdk.service.apps.DeleteResponse;
import com.databricks.sdk.service.apps.GetAppDeploymentRequest;
import com.databricks.sdk.service.apps.GetAppPermissionLevelsRequest;
import com.databricks.sdk.service.apps.GetAppPermissionLevelsResponse;
import com.databricks.sdk.service.apps.GetAppPermissionsRequest;
import com.databricks.sdk.service.apps.GetAppRequest;
import com.databricks.sdk.service.apps.ListAppDeploymentsRequest;
import com.databricks.sdk.service.apps.ListAppDeploymentsResponse;
import com.databricks.sdk.service.apps.ListAppsRequest;
import com.databricks.sdk.service.apps.ListAppsResponse;
import com.databricks.sdk.service.apps.StartAppRequest;
import com.databricks.sdk.service.apps.StopAppRequest;
import com.databricks.sdk.service.apps.StopAppResponse;
import com.databricks.sdk.service.apps.UpdateAppRequest;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class AppsImpl
implements AppsService {
    private final ApiClient apiClient;

    public AppsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public App create(CreateAppRequest request) {
        String path = "/api/2.0/preview/apps";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, App.class, headers);
    }

    @Override
    public void delete(DeleteAppRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, DeleteResponse.class, headers);
    }

    @Override
    public AppDeployment deploy(CreateAppDeploymentRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s/deployments", request.getAppName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, AppDeployment.class, headers);
    }

    @Override
    public App get(GetAppRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, App.class, headers);
    }

    @Override
    public AppDeployment getDeployment(GetAppDeploymentRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s/deployments/%s", request.getAppName(), request.getDeploymentId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, AppDeployment.class, headers);
    }

    @Override
    public GetAppPermissionLevelsResponse getPermissionLevels(GetAppPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/apps/%s/permissionLevels", request.getAppName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, GetAppPermissionLevelsResponse.class, headers);
    }

    @Override
    public AppPermissions getPermissions(GetAppPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/apps/%s", request.getAppName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, AppPermissions.class, headers);
    }

    @Override
    public ListAppsResponse list(ListAppsRequest request) {
        String path = "/api/2.0/preview/apps";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListAppsResponse.class, headers);
    }

    @Override
    public ListAppDeploymentsResponse listDeployments(ListAppDeploymentsRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s/deployments", request.getAppName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListAppDeploymentsResponse.class, headers);
    }

    @Override
    public AppPermissions setPermissions(AppPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/apps/%s", request.getAppName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PUT(path, request, AppPermissions.class, headers);
    }

    @Override
    public AppDeployment start(StartAppRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s/start", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, AppDeployment.class, headers);
    }

    @Override
    public void stop(StopAppRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s/stop", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.POST(path, request, StopAppResponse.class, headers);
    }

    @Override
    public App update(UpdateAppRequest request) {
        String path = String.format("/api/2.0/preview/apps/%s", request.getName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, App.class, headers);
    }

    @Override
    public AppPermissions updatePermissions(AppPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/apps/%s", request.getAppName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, AppPermissions.class, headers);
    }
}

