/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.workspace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.workspace.CreateRepoRequest;
import com.databricks.sdk.service.workspace.CreateRepoResponse;
import com.databricks.sdk.service.workspace.DeleteRepoRequest;
import com.databricks.sdk.service.workspace.DeleteRepoResponse;
import com.databricks.sdk.service.workspace.GetRepoPermissionLevelsRequest;
import com.databricks.sdk.service.workspace.GetRepoPermissionLevelsResponse;
import com.databricks.sdk.service.workspace.GetRepoPermissionsRequest;
import com.databricks.sdk.service.workspace.GetRepoRequest;
import com.databricks.sdk.service.workspace.GetRepoResponse;
import com.databricks.sdk.service.workspace.ListReposRequest;
import com.databricks.sdk.service.workspace.ListReposResponse;
import com.databricks.sdk.service.workspace.RepoPermissions;
import com.databricks.sdk.service.workspace.RepoPermissionsRequest;
import com.databricks.sdk.service.workspace.ReposService;
import com.databricks.sdk.service.workspace.UpdateRepoRequest;
import com.databricks.sdk.service.workspace.UpdateRepoResponse;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class ReposImpl
implements ReposService {
    private final ApiClient apiClient;

    public ReposImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateRepoResponse create(CreateRepoRequest request) {
        String path = "/api/2.0/repos";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, CreateRepoResponse.class, headers);
    }

    @Override
    public void delete(DeleteRepoRequest request) {
        String path = String.format("/api/2.0/repos/%s", request.getRepoId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, DeleteRepoResponse.class, headers);
    }

    @Override
    public GetRepoResponse get(GetRepoRequest request) {
        String path = String.format("/api/2.0/repos/%s", request.getRepoId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, GetRepoResponse.class, headers);
    }

    @Override
    public GetRepoPermissionLevelsResponse getPermissionLevels(GetRepoPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/repos/%s/permissionLevels", request.getRepoId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, GetRepoPermissionLevelsResponse.class, headers);
    }

    @Override
    public RepoPermissions getPermissions(GetRepoPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/repos/%s", request.getRepoId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, RepoPermissions.class, headers);
    }

    @Override
    public ListReposResponse list(ListReposRequest request) {
        String path = "/api/2.0/repos";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListReposResponse.class, headers);
    }

    @Override
    public RepoPermissions setPermissions(RepoPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/repos/%s", request.getRepoId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PUT(path, request, RepoPermissions.class, headers);
    }

    @Override
    public void update(UpdateRepoRequest request) {
        String path = String.format("/api/2.0/repos/%s", request.getRepoId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PATCH(path, request, UpdateRepoResponse.class, headers);
    }

    @Override
    public RepoPermissions updatePermissions(RepoPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/repos/%s", request.getRepoId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, RepoPermissions.class, headers);
    }
}

