/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settings;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.settings.CreateTokenRequest;
import com.databricks.sdk.service.settings.CreateTokenResponse;
import com.databricks.sdk.service.settings.ListPublicTokensResponse;
import com.databricks.sdk.service.settings.PublicTokenInfo;
import com.databricks.sdk.service.settings.RevokeTokenRequest;
import com.databricks.sdk.service.settings.TokensImpl;
import com.databricks.sdk.service.settings.TokensService;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class TokensAPI {
    private static final Logger LOG = LoggerFactory.getLogger(TokensAPI.class);
    private final TokensService impl;

    public TokensAPI(ApiClient apiClient) {
        this.impl = new TokensImpl(apiClient);
    }

    public TokensAPI(TokensService mock) {
        this.impl = mock;
    }

    public CreateTokenResponse create(CreateTokenRequest request) {
        return this.impl.create(request);
    }

    public void delete(String tokenId) {
        this.delete(new RevokeTokenRequest().setTokenId(tokenId));
    }

    public void delete(RevokeTokenRequest request) {
        this.impl.delete(request);
    }

    public Iterable<PublicTokenInfo> list() {
        return new Paginator(null, v -> this.impl.list(), ListPublicTokensResponse::getTokenInfos, response -> null);
    }

    public TokensService impl() {
        return this.impl;
    }
}

