/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.utils;

import java.util.Arrays;
import java.util.List;

public interface OSUtils {
    default public String getOS() {
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            return "win";
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("mac")) {
            return "mac";
        }
        return "linux";
    }

    default public List<String> getCliExecutableCommand(List<String> cmd) {
        String cmdToString = String.join((CharSequence)" ", cmd);
        if (this.getOS().equals("win")) {
            return Arrays.asList("cmd.exe", "/c", cmdToString);
        }
        return Arrays.asList("/bin/bash", "-c", cmdToString);
    }
}

