/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.compute;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.compute.ClusterPoliciesImpl;
import com.databricks.sdk.service.compute.ClusterPoliciesService;
import com.databricks.sdk.service.compute.ClusterPolicyPermissions;
import com.databricks.sdk.service.compute.ClusterPolicyPermissionsRequest;
import com.databricks.sdk.service.compute.CreatePolicy;
import com.databricks.sdk.service.compute.CreatePolicyResponse;
import com.databricks.sdk.service.compute.DeletePolicy;
import com.databricks.sdk.service.compute.EditPolicy;
import com.databricks.sdk.service.compute.GetClusterPolicyPermissionLevelsRequest;
import com.databricks.sdk.service.compute.GetClusterPolicyPermissionLevelsResponse;
import com.databricks.sdk.service.compute.GetClusterPolicyPermissionsRequest;
import com.databricks.sdk.service.compute.GetClusterPolicyRequest;
import com.databricks.sdk.service.compute.ListClusterPoliciesRequest;
import com.databricks.sdk.service.compute.Policy;
import com.databricks.sdk.support.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class ClusterPoliciesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterPoliciesAPI.class);
    private final ClusterPoliciesService impl;

    public ClusterPoliciesAPI(ApiClient apiClient) {
        this.impl = new ClusterPoliciesImpl(apiClient);
    }

    public ClusterPoliciesAPI(ClusterPoliciesService mock) {
        this.impl = mock;
    }

    public CreatePolicyResponse create(String name) {
        return this.create(new CreatePolicy().setName(name));
    }

    public CreatePolicyResponse create(CreatePolicy request) {
        return this.impl.create(request);
    }

    public void delete(String policyId) {
        this.delete(new DeletePolicy().setPolicyId(policyId));
    }

    public void delete(DeletePolicy request) {
        this.impl.delete(request);
    }

    public void edit(String policyId, String name) {
        this.edit(new EditPolicy().setPolicyId(policyId).setName(name));
    }

    public void edit(EditPolicy request) {
        this.impl.edit(request);
    }

    public Policy get(String policyId) {
        return this.get(new GetClusterPolicyRequest().setPolicyId(policyId));
    }

    public Policy get(GetClusterPolicyRequest request) {
        return this.impl.get(request);
    }

    public GetClusterPolicyPermissionLevelsResponse getClusterPolicyPermissionLevels(String clusterPolicyId) {
        return this.getClusterPolicyPermissionLevels(new GetClusterPolicyPermissionLevelsRequest().setClusterPolicyId(clusterPolicyId));
    }

    public GetClusterPolicyPermissionLevelsResponse getClusterPolicyPermissionLevels(GetClusterPolicyPermissionLevelsRequest request) {
        return this.impl.getClusterPolicyPermissionLevels(request);
    }

    public ClusterPolicyPermissions getClusterPolicyPermissions(String clusterPolicyId) {
        return this.getClusterPolicyPermissions(new GetClusterPolicyPermissionsRequest().setClusterPolicyId(clusterPolicyId));
    }

    public ClusterPolicyPermissions getClusterPolicyPermissions(GetClusterPolicyPermissionsRequest request) {
        return this.impl.getClusterPolicyPermissions(request);
    }

    public Iterable<Policy> list(ListClusterPoliciesRequest request) {
        return this.impl.list(request).getPolicies();
    }

    public ClusterPolicyPermissions setClusterPolicyPermissions(String clusterPolicyId) {
        return this.setClusterPolicyPermissions(new ClusterPolicyPermissionsRequest().setClusterPolicyId(clusterPolicyId));
    }

    public ClusterPolicyPermissions setClusterPolicyPermissions(ClusterPolicyPermissionsRequest request) {
        return this.impl.setClusterPolicyPermissions(request);
    }

    public ClusterPolicyPermissions updateClusterPolicyPermissions(String clusterPolicyId) {
        return this.updateClusterPolicyPermissions(new ClusterPolicyPermissionsRequest().setClusterPolicyId(clusterPolicyId));
    }

    public ClusterPolicyPermissions updateClusterPolicyPermissions(ClusterPolicyPermissionsRequest request) {
        return this.impl.updateClusterPolicyPermissions(request);
    }

    public ClusterPoliciesService impl() {
        return this.impl;
    }
}

