/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.iam;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.iam.DeleteUserRequest;
import com.databricks.sdk.service.iam.GetPasswordPermissionLevelsResponse;
import com.databricks.sdk.service.iam.GetUserRequest;
import com.databricks.sdk.service.iam.ListUsersRequest;
import com.databricks.sdk.service.iam.ListUsersResponse;
import com.databricks.sdk.service.iam.PartialUpdate;
import com.databricks.sdk.service.iam.PasswordPermissions;
import com.databricks.sdk.service.iam.PasswordPermissionsRequest;
import com.databricks.sdk.service.iam.User;
import com.databricks.sdk.service.iam.UsersService;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class UsersImpl
implements UsersService {
    private final ApiClient apiClient;

    public UsersImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public User create(User request) {
        String path = "/api/2.0/preview/scim/v2/Users";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, User.class, headers);
    }

    @Override
    public void delete(DeleteUserRequest request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        this.apiClient.DELETE(path, request, Void.class, headers);
    }

    @Override
    public User get(GetUserRequest request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, User.class, headers);
    }

    @Override
    public GetPasswordPermissionLevelsResponse getPasswordPermissionLevels() {
        String path = "/api/2.0/permissions/authorization/passwords/permissionLevels";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, GetPasswordPermissionLevelsResponse.class, headers);
    }

    @Override
    public PasswordPermissions getPasswordPermissions() {
        String path = "/api/2.0/permissions/authorization/passwords";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, PasswordPermissions.class, headers);
    }

    @Override
    public ListUsersResponse list(ListUsersRequest request) {
        String path = "/api/2.0/preview/scim/v2/Users";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, ListUsersResponse.class, headers);
    }

    @Override
    public void patch(PartialUpdate request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PATCH(path, request, Void.class, headers);
    }

    @Override
    public PasswordPermissions setPasswordPermissions(PasswordPermissionsRequest request) {
        String path = "/api/2.0/permissions/authorization/passwords";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PUT(path, request, PasswordPermissions.class, headers);
    }

    @Override
    public void update(User request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PUT(path, request, Void.class, headers);
    }

    @Override
    public PasswordPermissions updatePasswordPermissions(PasswordPermissionsRequest request) {
        String path = "/api/2.0/permissions/authorization/passwords";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.PATCH(path, request, PasswordPermissions.class, headers);
    }
}

