/*
 * Decompiled with CFR 0.152.
 */
package com.day.image.internal.font;

import com.day.image.Layer;
import com.day.image.font.AbstractFont;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BandCombineOp;
import java.awt.image.WritableRaster;
import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class PlatformFont
extends AbstractFont {
    private static final Graphics DUMMY_GRAPHICS = new Layer(1, 1, null).getG2();
    private static int oversamplingFactor = 16;
    private final String family;
    private final int size;
    private final int style;
    private final Font font;
    private final FontMetrics metrics;
    private final double ascent;
    private final double descent;
    private final double height;

    public PlatformFont(String faceName, int size, int style, Font awtFont) {
        size = PlatformFont.scaleFontSize(size, style);
        if (awtFont == null) {
            Float posture = (style & 2) != 0 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR;
            Float weight = (style & 1) != 0 ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR;
            HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
            map.put(TextAttribute.FAMILY, faceName);
            map.put(TextAttribute.SIZE, new Float(size));
            map.put(TextAttribute.POSTURE, posture);
            map.put(TextAttribute.WEIGHT, weight);
            awtFont = new Font(map);
        }
        this.family = faceName;
        this.size = size;
        this.style = style;
        this.font = awtFont;
        this.metrics = DUMMY_GRAPHICS.getFontMetrics(this.font);
        if ((style & 0x200) != 0) {
            this.ascent = this.metrics.getMaxAscent();
            this.descent = this.metrics.getMaxDescent();
            this.height = this.ascent + this.descent + (double)this.metrics.getLeading();
        } else {
            this.ascent = this.metrics.getAscent();
            this.descent = this.metrics.getDescent();
            this.height = this.metrics.getHeight();
        }
    }

    public PlatformFont(String faceName, int size, int style) {
        this(faceName, size, style, null);
    }

    public PlatformFont(String faceName, int size) {
        this(faceName, size, 0);
    }

    public Font getAwtFont() {
        return this.font;
    }

    public Rectangle2D getTextExtent(int x, int y, int width, int height, String text, int align, double cs, int ls) {
        if (text == null || text.length() == 0) {
            return new Rectangle(x, y, 0, 0);
        }
        TextBlock tb = new TextBlock(this, text, width, height, align, cs, ls);
        return tb.getAlignedBoundingBox(x, y);
    }

    public int drawText(Layer layer, int x, int y, int width, int height, String text, Paint paint, Stroke stroke, int align, double cs, int ls) {
        if (text == null || text.length() == 0) {
            throw new IllegalArgumentException("text must not be empty");
        }
        TextBlock tb = new TextBlock(this, text, width, height, align, cs, ls);
        return tb.draw(layer, x, y, paint, stroke);
    }

    public double getHeight() {
        return this.height;
    }

    public double getAscent() {
        return this.ascent;
    }

    public double getDescent() {
        return this.descent;
    }

    public boolean canDisplay(char c) {
        return this.getAwtFont().canDisplay(c);
    }

    public int canDisplayUpTo(String str) {
        return this.getAwtFont().canDisplayUpTo(str);
    }

    public int canDisplayUpTo(char[] text, int start, int limit) {
        return this.getAwtFont().canDisplayUpTo(text, start, limit);
    }

    public int canDisplayUpTo(CharacterIterator iter, int start, int limit) {
        return this.getAwtFont().canDisplayUpTo(iter, start, limit);
    }

    public String toString() {
        return "Font[family=" + this.family + ", size=" + this.size + ", style=" + this.style + "]";
    }

    public static int scaleFontSize(int size, int style) {
        if ((style & 0x100) == 0) {
            return size * 4 / 3;
        }
        return size;
    }

    public static int getOversamplingFactor() {
        return oversamplingFactor;
    }

    public static void setOversamplingFactor(int oversamplingFactor) {
        if (oversamplingFactor > 0) {
            PlatformFont.oversamplingFactor = oversamplingFactor;
        }
    }

    private static double scaleUp(double value) {
        return (double)oversamplingFactor * value;
    }

    private static double scaleDown(double value) {
        return value / (double)oversamplingFactor;
    }

    private static int scaleUp(int value) {
        return oversamplingFactor * value;
    }

    private static int scaleDown(int value) {
        return (value + oversamplingFactor / 2) / oversamplingFactor;
    }

    private static class TextLine {
        private final String line;
        private GlyphVector glyphVector;
        private double width;
        private double cs;

        TextLine(String line, GlyphVector glyphVector) {
            this.line = line;
            this.glyphVector = glyphVector;
            this.width = Double.NaN;
            this.cs = Double.NaN;
        }

        public String getLine() {
            return this.line;
        }

        GlyphVector getGlyphVector() {
            return this.glyphVector;
        }

        double getWidth(double cs) {
            if (Double.isNaN(this.width) || this.cs != cs) {
                this.cs = cs;
                this.width = TextLine.getWidth(this.glyphVector, 0, this.glyphVector.getNumGlyphs(), cs);
            }
            return this.width;
        }

        static double getWidth(GlyphVector gv, int first, int end, double cs) {
            if (end <= first) {
                return 0.0;
            }
            double w = gv.getGlyphPosition(end).getX() - gv.getGlyphPosition(first).getX();
            int numGlyphs = end - first - 1;
            double sumcs = (double)numGlyphs * cs;
            return (double)(-gv.getGlyphMetrics(first).getLSB()) + w + sumcs - (double)gv.getGlyphMetrics(end - 1).getRSB();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TextBlock {
        private final String text;
        private final double width;
        private final double height;
        private final int flags;
        private final double cs;
        private final double ls;
        private final Font awtFont;
        private final FontRenderContext frc;
        private final float strikeOffset;
        private final Stroke strikeStroke;
        private final TextLine[] lines;
        private Rectangle2D boundingBox;

        TextBlock(PlatformFont font, String text, double width, double height, int flags, double cs, double ls) {
            double d = ls = ls > 0.0 ? ls / 16.0 : font.height;
            if ((flags & 0x40000) != 0) {
                float size = PlatformFont.scaleUp(font.getAwtFont().getSize());
                this.awtFont = font.getAwtFont().deriveFont(size);
                height = PlatformFont.scaleUp(height);
                width = PlatformFont.scaleUp(width);
                cs = PlatformFont.scaleUp(cs);
                ls = PlatformFont.scaleUp(ls);
            } else {
                this.awtFont = font.getAwtFont();
            }
            this.text = text;
            this.flags = flags;
            this.width = width;
            this.height = height;
            this.cs = cs;
            this.ls = ls;
            boolean aalias = (flags & 0x10000) != 0;
            this.frc = new FontRenderContext(null, aalias, false);
            this.lines = this.breakText();
            this.boundingBox = null;
            LineMetrics lm = this.awtFont.getLineMetrics(" ", this.frc);
            if ((flags & 0x2000) != 0 || (font.style & 8) != 0) {
                this.strikeOffset = lm.getStrikethroughOffset();
                this.strikeStroke = (flags & 0x4000) == 0 ? new BasicStroke(lm.getStrikethroughThickness()) : null;
            } else if ((flags & 0x1000) != 0 || (font.style & 4) != 0) {
                this.strikeOffset = lm.getUnderlineOffset();
                this.strikeStroke = (flags & 0x4000) == 0 ? new BasicStroke(lm.getUnderlineThickness()) : null;
            } else {
                this.strikeOffset = Float.NaN;
                this.strikeStroke = null;
            }
        }

        Rectangle2D getRawBoundingBox() {
            this.assertBoundingBox();
            return new Rectangle2D.Double(this.boundingBox.getX(), this.boundingBox.getY(), this.boundingBox.getWidth(), this.boundingBox.getHeight());
        }

        private Rectangle2D getAlignedBoundingBoxInternal(int x, int y) {
            this.assertBoundingBox();
            double vertDisp = 0.0;
            switch (this.flags & 0xF) {
                case 0: {
                    vertDisp = this.boundingBox.getMinY();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    vertDisp = this.boundingBox.getMaxY();
                    break;
                }
            }
            return new Rectangle2D.Double(this.boundingBox.getX() + (double)x, this.boundingBox.getY() + (double)y - vertDisp, this.boundingBox.getWidth(), this.boundingBox.getHeight());
        }

        Rectangle2D getAlignedBoundingBox(int x, int y) {
            Rectangle2D abox = this.getAlignedBoundingBoxInternal(0, 0);
            double l = abox.getX();
            double t = abox.getY();
            double w = abox.getWidth();
            double h = abox.getHeight();
            if ((this.flags & 0x40000) != 0) {
                l = PlatformFont.scaleDown(l);
                t = PlatformFont.scaleDown(t);
                w = PlatformFont.scaleDown(w);
                h = PlatformFont.scaleDown(h);
            }
            abox.setRect(l + (double)x, t + (double)y, w, h);
            return abox;
        }

        int draw(Layer layer, int x, int y, Paint paint, Stroke stroke) {
            this.assertBoundingBox();
            if (this.boundingBox.getWidth() <= 0.0 || this.boundingBox.getHeight() <= 0.0) {
                return 0;
            }
            int linesDrawn = 0;
            Rectangle2D bbox = this.boundingBox;
            Rectangle2D abox = this.getAlignedBoundingBoxInternal(0, 0);
            int textWidth = (int)Math.ceil(Math.max(this.width, bbox.getWidth()));
            int textHeight = (int)Math.ceil(Math.max(this.height, bbox.getHeight()));
            Layer drawer = new Layer(textWidth, textHeight, null);
            drawer.setX((int)abox.getX());
            drawer.setY((int)abox.getY());
            Object aaSetting = null;
            if ((this.flags & 0x10000) != 0) {
                aaSetting = drawer.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                drawer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (paint == null || paint instanceof Color && ((Color)paint).getAlpha() == 255) {
                drawer.setPaint(Color.black);
            } else {
                drawer.setPaint(paint);
                paint = null;
            }
            if (stroke != null) {
                drawer.setStroke(stroke);
            }
            Graphics2D drawerG2 = drawer.getG2();
            double penY = -bbox.getY();
            for (int i = 0; i < this.lines.length; ++i) {
                TextLine textLine = this.lines[i];
                String line = textLine.getLine();
                GlyphVector gv = textLine.getGlyphVector();
                double penX = -bbox.getX();
                double lw = textLine.getWidth(this.cs);
                double border = (double)textWidth - lw;
                if ((this.flags & 0x20) != 0) {
                    penX = border - (double)gv.getGlyphMetrics(0).getLSB();
                    this.fixCharSpacing(gv, this.cs);
                } else if ((this.flags & 0x10) != 0) {
                    penX = border / 2.0 - (double)gv.getGlyphMetrics(0).getLSB();
                    this.fixCharSpacing(gv, this.cs);
                } else if ((this.flags & 0x40) != 0) {
                    BreakIterator bi = BreakIterator.getLineInstance();
                    bi.setText(line);
                    ArrayList<String> words = new ArrayList<String>();
                    int start = bi.first();
                    int end = bi.next();
                    while (end != -1) {
                        if (!Character.isWhitespace(line.charAt(start))) {
                            int wordEnd = this.fixLineEnd(line, end);
                            words.add(line.substring(start, wordEnd));
                        }
                        start = end;
                        end = bi.next();
                    }
                    if (words.size() != 0) {
                        if (words.size() == 1) {
                            this.alignCharacters(gv, border);
                        } else {
                            this.alignWords(drawerG2, words, penX, penY, textWidth);
                            gv = null;
                        }
                    }
                    lw = textWidth;
                } else {
                    this.fixCharSpacing(gv, this.cs);
                }
                if (gv != null) {
                    this.drawGlyphVector(drawerG2, gv, (float)penX, (float)penY);
                }
                if (!Float.isNaN(this.strikeOffset)) {
                    Stroke old = null;
                    if (this.strikeStroke != null) {
                        old = drawer.getStroke();
                        drawer.setStroke(this.strikeStroke);
                    }
                    double sy = penY + (double)this.strikeOffset;
                    drawer.draw(new Line2D.Double(penX, sy, penX + lw, sy));
                    if (old != null) {
                        drawer.setStroke(old);
                    }
                }
                ++linesDrawn;
                penY += this.ls;
            }
            int deg = 0;
            if ((this.flags & 0x100) != 0) {
                deg = 90;
            } else if ((this.flags & 0x400) != 0) {
                deg = 180;
            } else if ((this.flags & 0x200) != 0) {
                deg = 270;
            }
            if (deg != 0) {
                drawer.rotate(deg);
                if ((this.flags & 0x10) != 0 && (this.flags & 0x300) != 0) {
                    drawer.setX(drawer.getX() + drawer.getHeight() / 2 - drawer.getWidth() / 2);
                }
            }
            if ((this.flags & 0x40000) != 0) {
                if (aaSetting == null) {
                    aaSetting = drawer.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                }
                drawer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                drawer.resize(PlatformFont.scaleDown(drawer.getWidth()), PlatformFont.scaleDown(drawer.getHeight()));
                drawer.setX(PlatformFont.scaleDown(drawer.getX()));
                drawer.setY(PlatformFont.scaleDown(drawer.getY()));
            }
            if (aaSetting != null) {
                drawer.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaSetting);
            }
            if (paint != null) {
                Color col = (Color)paint;
                float[][] elems = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, col.getRed()}, {0.0f, 0.0f, 0.0f, 0.0f, col.getGreen()}, {0.0f, 0.0f, 0.0f, 0.0f, col.getBlue()}, {0.0f, 0.0f, 0.0f, 1.0f, 0.0f}};
                WritableRaster imageRaster = drawer.getImage().getRaster();
                new BandCombineOp(elems, null).filter(imageRaster, imageRaster);
            }
            drawer.setX(drawer.getX() + x);
            drawer.setY(drawer.getY() + y);
            layer.merge(drawer);
            return linesDrawn;
        }

        private void drawGlyphVector(Graphics2D g2, GlyphVector gv, float xPos, float yPos) {
            if ((this.flags & 0x4000) != 0) {
                g2.draw(gv.getOutline(xPos, yPos));
            } else {
                g2.drawGlyphVector(gv, xPos, yPos);
            }
        }

        private void fixCharSpacing(GlyphVector gv, double cs) {
            double xOf = 0.0;
            int i = 0;
            int ng = gv.getNumGlyphs();
            while (i < ng) {
                Point2D pos = gv.getGlyphPosition(i);
                pos.setLocation(pos.getX() + xOf, pos.getY());
                gv.setGlyphPosition(i, pos);
                ++i;
                xOf += cs;
            }
        }

        private void alignCharacters(GlyphVector gv, double space) {
            this.fixCharSpacing(gv, this.cs + space / (double)(gv.getNumGlyphs() - 1));
        }

        private void alignWords(Graphics2D drawerG2, List<String> words, double penX, double penY, int textWidth) {
            int nw = words.size();
            int[] lsbs = new int[nw];
            int[] widths = new int[nw];
            int sumWidth = 0;
            GlyphVector[] gvs = new GlyphVector[nw];
            for (int i = 0; i < nw; ++i) {
                String word = words.get(i);
                GlyphVector gv = this.awtFont.createGlyphVector(this.frc, word);
                this.fixCharSpacing(gv, this.cs);
                lsbs[i] = (int)Math.ceil(gv.getGlyphMetrics(0).getLSB());
                widths[i] = (int)Math.ceil(gv.getVisualBounds().getWidth());
                sumWidth += widths[i];
                gvs[i] = gv;
            }
            int blanking = (int)Math.ceil(penX) + lsbs[0];
            int space = (textWidth - blanking - sumWidth) / (nw - 1);
            int xOfs = blanking;
            for (int i = 0; i < nw; ++i) {
                if (i == nw - 1) {
                    xOfs = textWidth - widths[i];
                }
                this.drawGlyphVector(drawerG2, gvs[i], xOfs - lsbs[i], (float)penY);
                xOfs += widths[i] + space;
            }
        }

        private TextLine[] breakText() {
            int lastNonBlank;
            LinkedList<String> list = new LinkedList<String>();
            GlyphVector gv = this.awtFont.createGlyphVector(this.frc, this.text);
            gv.performDefaultLayout();
            BreakIterator bi = BreakIterator.getLineInstance();
            bi.setText(this.text);
            double maxWidth = this.width > 0.0 ? this.width : Double.MAX_VALUE;
            int lineStartPos = 0;
            int lastBreakOp = 0;
            int nextLineStart = bi.next();
            while (nextLineStart != -1) {
                int lineEnd = this.fixLineEnd(this.text, nextLineStart);
                double pw = TextLine.getWidth(gv, lineStartPos, lineEnd, this.cs);
                if (pw > maxWidth) {
                    if (lastBreakOp > lineStartPos) {
                        list.add(this.text.substring(lineStartPos, this.fixLineEnd(this.text, lastBreakOp)));
                        lineStartPos = lastBreakOp;
                        continue;
                    }
                    int i = lineStartPos;
                    while ((pw = TextLine.getWidth(gv, lineStartPos, ++i, this.cs)) <= maxWidth) {
                    }
                    lineEnd = i - 1;
                    if (lineEnd == lineStartPos) {
                        lineStartPos = Integer.MAX_VALUE;
                        break;
                    }
                    list.add(this.text.substring(lineStartPos, this.fixLineEnd(this.text, lineEnd)));
                    lineStartPos = lineEnd;
                    continue;
                }
                char lastOnLine = this.text.charAt(nextLineStart - 1);
                if (lastOnLine == '\r' || lastOnLine == '\n') {
                    if (lineEnd > lineStartPos) {
                        list.add(this.text.substring(lineStartPos, lineEnd));
                    } else {
                        list.add("");
                    }
                    lineStartPos = nextLineStart;
                }
                lastBreakOp = nextLineStart;
                nextLineStart = bi.next();
            }
            if (lineStartPos <= (lastNonBlank = this.fixLineEnd(this.text, this.text.length()))) {
                list.add(this.text.substring(lineStartPos, lastNonBlank));
            }
            if (list.isEmpty()) {
                list.add("");
            }
            TextLine[] lines = new TextLine[list.size()];
            int i = 0;
            for (String s : list) {
                gv = this.awtFont.createGlyphVector(this.frc, s);
                lines[i++] = new TextLine(s, gv);
            }
            return lines;
        }

        private void assertBoundingBox() {
            if (this.boundingBox == null) {
                double yOffset = 0.0;
                for (int i = 0; i < this.lines.length; ++i) {
                    Rectangle2D vb = this.lines[i].getGlyphVector().getVisualBounds();
                    vb.setRect(vb.getX(), vb.getY() + yOffset, this.lines[i].getWidth(this.cs), vb.getHeight());
                    this.boundingBox = this.boundingBox == null ? vb : this.boundingBox.createUnion(vb);
                    yOffset += this.ls;
                }
            }
        }

        int fixLineEnd(String text, int lineEnd) {
            while (--lineEnd >= 0 && Character.isWhitespace(text.charAt(lineEnd))) {
            }
            return lineEnd + 1;
        }
    }
}

