/*
 * Decompiled with CFR 0.152.
 */
package com.day.image.internal.font.fonter;

import com.day.any.AnyObject;
import com.day.any.AnyValue;
import com.day.any.BaseHandler;
import com.day.any.ParseException;
import com.day.image.internal.font.fonter.FonterFont;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

final class FontDescriptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int RGBA_CHARS_MAX = 128;
    private final String fontName;
    final int ascent;
    final int descent;
    final int height;
    final BufferedImage fontImage;
    private final CharInfo[] chrs = new CharInfo[128];
    private final HashMap<Integer, CharInfo> extra = new HashMap();
    private CharInfo defCharInfo;
    private static int[] cp_map = new int[256];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FontDescriptor(ResourceResolver resolver, String[] path, String fontName) throws NoSuchElementException {
        this.fontName = fontName;
        int defaultChar = 32;
        int ascent = 0;
        int descent = 0;
        int height = 0;
        BufferedImage fontImage = null;
        try {
            String gifPath;
            String pathEntry;
            String handle;
            Resource anyResource = null;
            Resource gifResource = null;
            String[] arr$ = path;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && ((anyResource = resolver.getResource(handle = (pathEntry = arr$[i$]) + "/" + fontName + ".any")) == null || (gifResource = resolver.getResource(gifPath = anyResource.getPath().substring(0, anyResource.getPath().length() - 3) + "gif")) == null); ++i$) {
            }
            if (anyResource == null || gifResource == null) {
                throw new NoSuchElementException(fontName);
            }
            this.log.debug("FontDescriptor: Reading font information from: {}", (Object)anyResource.getPath());
            AnyObject data = FontDescriptor.parseFontAny(anyResource);
            ascent = (int)((AnyValue)data.getDirect("ascent")).getNumberValue();
            descent = (int)((AnyValue)data.getDirect("descent")).getNumberValue();
            height = (int)((AnyValue)data.getDirect("height")).getNumberValue();
            AnyObject charmap = (AnyObject)data.getDirect("charmap");
            for (AnyValue val : charmap) {
                CharInfo ci;
                if ("default".equals(val.getLabel())) {
                    defaultChar = this.getCharCode(val.getStringValue());
                    this.log.trace("FontDescriptor: Default Character has code " + val.getStringValue());
                    continue;
                }
                if ("inf".equals(val.getLabel())) continue;
                int code = this.getCharCode(val.getLabel());
                this.log.trace("FontDescriptor: Defining character code " + code);
                if (code < 128) {
                    ci = this.chrs[code] = new CharInfo();
                } else {
                    ci = new CharInfo();
                    this.extra.put(code, ci);
                }
                StringTokenizer dat = new StringTokenizer(val.getStringValue());
                ci.code = code;
                if (dat.hasMoreTokens()) {
                    ci.tx = Integer.parseInt(dat.nextToken());
                }
                if (dat.hasMoreTokens()) {
                    ci.ty = Integer.parseInt(dat.nextToken());
                }
                if (dat.hasMoreTokens()) {
                    ci.tw = Integer.parseInt(dat.nextToken());
                }
                if (dat.hasMoreTokens()) {
                    ci.th = Integer.parseInt(dat.nextToken());
                }
                if (dat.hasMoreTokens()) {
                    ci.ix = Integer.parseInt(dat.nextToken());
                }
                if (dat.hasMoreTokens()) {
                    ci.iy = Integer.parseInt(dat.nextToken());
                }
                for (int i = 0; i < 16 && dat.hasMoreTokens(); ++i) {
                    ci.cells[i] = new CharCell();
                    if (dat.hasMoreTokens()) {
                        ci.cells[i].x = Integer.parseInt(dat.nextToken());
                    }
                    if (dat.hasMoreTokens()) {
                        ci.cells[i].y = Integer.parseInt(dat.nextToken());
                    }
                    if (dat.hasMoreTokens()) {
                        ci.cells[i].w = Integer.parseInt(dat.nextToken());
                    }
                    if (!dat.hasMoreTokens()) continue;
                    ci.cells[i].h = Integer.parseInt(dat.nextToken());
                }
            }
            this.defCharInfo = defaultChar < 128 ? this.chrs[defaultChar] : this.extra.get(defaultChar);
            if (this.defCharInfo == null || this.defCharInfo.code != defaultChar) {
                this.defCharInfo = this.chrs[32];
            }
            this.log.debug("FontDescriptor: Reading font image from {}", (Object)gifResource.getPath());
            InputStream inStream = null;
            ImageInputStream iin = null;
            try {
                inStream = (InputStream)gifResource.adaptTo(InputStream.class);
                iin = ImageIO.createImageInputStream(inStream);
                fontImage = ImageIO.read(iin);
                if (fontImage.getColorModel() instanceof IndexColorModel) {
                    IndexColorModel icm = (IndexColorModel)fontImage.getColorModel();
                    fontImage = icm.convertToIntDiscrete(fontImage.getRaster(), true);
                }
                FonterFont.convertToTransparent.filter(fontImage.getRaster(), fontImage.getRaster());
            }
            finally {
                if (iin != null) {
                    try {
                        iin.close();
                    }
                    catch (IOException ignore) {}
                }
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        catch (ParseException pe) {
            this.log.info("FontDescriptor: {}", (Object)pe.toString());
            throw new NoSuchElementException("Error reading the font information file");
        }
        catch (IIOException iioe) {
            Throwable cause = iioe.getCause();
            this.log.info("FontDescriptor: {}", (Object)(cause == null ? iioe.toString() : cause.toString()));
        }
        catch (IOException ioe) {
            this.log.info("FontDescriptor: {}", (Object)ioe.toString());
            throw new NoSuchElementException("Cannot load the font image data");
        }
        finally {
            this.ascent = ascent;
            this.descent = descent;
            this.height = height;
            this.fontImage = fontImage;
        }
    }

    private int getCharCode(String hex) {
        int cpCode = Integer.parseInt(hex, 16);
        if (cpCode > 255) {
            this.log.warn("character code > 255 in FonterFont. could cause undesired results.");
            return cpCode;
        }
        return cp_map[cpCode];
    }

    final CharInfo getCharInfo(int c) {
        CharInfo ci = this.getCharInfoInternal(c);
        if (ci == null || ci.code != c) {
            ci = this.defCharInfo;
        }
        return ci;
    }

    final boolean hasCharInfo(int c) {
        CharInfo ci = this.getCharInfoInternal(c);
        return ci != null && ci.code == c;
    }

    private CharInfo getCharInfoInternal(int c) {
        if (c < 128) {
            return this.chrs[c];
        }
        return this.extra.get(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AnyObject parseFontAny(Resource anyResource) throws ParseException, IOException {
        InputStream inStream = null;
        try {
            inStream = (InputStream)anyResource.adaptTo(InputStream.class);
            InputSource inputSource = new InputSource(inStream);
            AnyObject anyObject = BaseHandler.parse((InputSource)inputSource);
            return anyObject;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    static {
        byte[] bytes = new byte[256];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)i;
        }
        try {
            String s = new String(bytes, "Cp1252");
            for (int i = 0; i < bytes.length; ++i) {
                FontDescriptor.cp_map[i] = s.charAt(i);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
    }

    static final class CharInfo {
        int code;
        int tx;
        int ty;
        int tw;
        int th;
        int ix;
        int iy;
        CharCell[] cells = new CharCell[16];

        CharInfo() {
        }
    }

    static final class CharCell {
        int x;
        int y;
        int w;
        int h;

        CharCell() {
        }
    }
}

