/*
 * Decompiled with CFR 0.152.
 */
package com.day.image.internal.font.fonter;

import com.day.image.font.AbstractFont;
import com.day.image.internal.font.FontFileProvider;
import com.day.image.internal.font.FontProvider;
import com.day.image.internal.font.fonter.FonterFont;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.observation.EventIterator;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FonterFontProvider
implements FontProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void init(ResourceResolver resolver, String[] fontPath, FontFileProvider ffp) {
        FonterFont.init(resolver, fontPath);
    }

    public List getFontList() {
        return FonterFont.getFontList();
    }

    public AbstractFont getFont(String faceName, int size, int style) {
        try {
            return new FonterFont(faceName, size, style);
        }
        catch (NoSuchElementException nsee) {
            this.log.debug("getFont: FonterFont does not provide the font {}/{}{}", new Object[]{faceName, size, AbstractFont.styleToDescription(style)});
            return null;
        }
    }

    public void onEvent(EventIterator events) {
        FonterFont.fontCache.onEvent(events);
    }

    public void destroy() {
        FonterFont.destroy();
    }
}

