/*
 * Decompiled with CFR 0.152.
 */
package com.day.image.internal.font.resource;

import com.day.image.font.AbstractFont;
import com.day.image.font.FontListEntry;
import com.day.image.internal.FontPath;
import com.day.image.internal.font.FontFileProvider;
import com.day.image.internal.font.FontProvider;
import com.day.image.internal.font.PlatformFont;
import com.day.image.internal.font.resource.ResourceFontCache;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jcr.observation.EventIterator;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFontProvider
implements FontProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ResourceFontCache fontCache;
    private ResourceResolver ticket;
    private FontFileProvider fontFileProvider;

    @Override
    public List<FontListEntry> getFontList() {
        return this.fontCache.getFontList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractFont getFont(String faceName, int requestedSize, int style) {
        ResourceFontCache resourceFontCache = this.fontCache;
        synchronized (resourceFontCache) {
            int fontSize = PlatformFont.scaleFontSize(requestedSize, style);
            String fontName = AbstractFont.createFontFileName(faceName, fontSize, style);
            this.log.debug("findFont: Try {} from cache", (Object)fontName);
            Font awtFont = (Font)this.fontCache.get(fontName);
            if (awtFont == null) {
                this.log.debug("findFont: Derive size from {}/{}", (Object)faceName, (Object)AbstractFont.styleToDescription(style));
                awtFont = this.loadBaseFont(faceName, style);
            }
            if (awtFont != null) {
                awtFont = awtFont.deriveFont((float)fontSize);
                this.log.debug("findFont: Caching new instance for {}", (Object)fontName);
                this.fontCache.put(fontName, awtFont);
                return new PlatformFont(faceName, requestedSize, style, awtFont);
            }
        }
        return null;
    }

    @Override
    public void init(ResourceResolver resolver, String[] fontPath, FontFileProvider ffp) {
        this.ticket = resolver;
        this.fontFileProvider = ffp;
        FontPath fp = new FontPath(this.ticket, fontPath);
        this.fontCache = new ResourceFontCache(this.ticket, fontPath, ffp);
    }

    @Override
    public void onEvent(EventIterator events) {
    }

    @Override
    public void destroy() {
        if (this.fontCache != null) {
            this.fontCache.destroy();
            this.fontCache = null;
        }
    }

    private Font loadBaseFont(String family, int style) {
        String baseFont = null;
        String fontName = AbstractFont.createFontFileName(family, 0, style);
        this.log.debug("loadBaseFont: Try {} from cache", (Object)fontName);
        Font awtFont = (Font)this.fontCache.get(fontName);
        if (awtFont != null) {
            this.log.debug("loadBaseFont: Got it");
            return awtFont;
        }
        String handle = this.fontCache.getFontHandle(fontName);
        if (handle == null) {
            this.log.debug("loadBaseFont: Derive style for {}/{} from plain {}", (Object)family, (Object)AbstractFont.styleToDescription(style));
            baseFont = AbstractFont.createFontFileName(family, 0, 0);
            awtFont = (Font)this.fontCache.get(baseFont);
            if (awtFont != null) {
                this.log.debug("loadBaseFont: Caching and returning derived font style");
                awtFont = awtFont.deriveFont(style);
                this.fontCache.put(fontName, awtFont);
                return awtFont;
            }
            this.log.debug("loadBaseFont: Check mapping for plain {}", (Object)family);
            handle = this.fontCache.getFontHandle(baseFont);
            if (handle == null) {
                this.log.debug("loadBaseFont: Not even found mapping for plain {}", (Object)family);
                return null;
            }
        }
        try {
            this.log.debug("loadBaseFont: Load font from {}", (Object)handle);
            Resource res = this.ticket.getResource(handle);
            InputStream fi = (InputStream)res.adaptTo(InputStream.class);
            if (fi == null) {
                throw new IOException("Resource does not adapt to InputStream:" + res.getPath());
            }
            Font af = Font.createFont(0, this.fontFileProvider.getFileForStream(fi));
            if (baseFont != null) {
                this.log.debug("loadBaseFont: Cache plain style base and derive");
                this.fontCache.put(baseFont, af);
                af = af.deriveFont(style);
            }
            this.log.debug("loadBaseFont: Cache desired font with style");
            this.fontCache.put(fontName, af);
            return af;
        }
        catch (IOException ioe) {
            this.log.warn("IO problem loading the font from " + handle, (Throwable)ioe);
        }
        catch (FontFormatException ffe) {
            this.log.warn("The font page " + handle + " does not seem to contain a valid TrueType font", (Throwable)ffe);
        }
        return null;
    }
}

