/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.contentsync.impl;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.contentsync.ContentSyncManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.contentsync.PageExporter;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageExporterImpl
implements PageExporter {
    private static final Logger log = LoggerFactory.getLogger(PageExporterImpl.class);
    private static final String TEMPLATE_PROPERTY = "cq:exportTemplate";
    private static final String DEFAULT_TEMPLATE_PATH = "/etc/contentsync/templates/default";
    private ContentSyncManager contentSyncManager;
    private ResourceResolverFactory resolverFactory;

    public void export(Page page, ResourceResolver resolver, HttpServletResponse response) throws WCMException {
        try {
            ResourceResolver adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            String configPath = "/var/contentsync/tmp" + page.getPath() + "_" + System.currentTimeMillis();
            this.createConfig(page, configPath, resolver, adminResolver);
            Resource config = adminResolver.getResource(configPath);
            String zipPath = this.contentSyncManager.getZip(config, null, (Session)resolver.adaptTo(Session.class));
            this.contentSyncManager.sendZip(response, zipPath);
            this.cleanup(configPath, zipPath, adminResolver);
        }
        catch (Exception e) {
            throw new WCMException((Throwable)e);
        }
    }

    public void export(Page page, SlingHttpServletRequest request, HttpServletResponse response) throws WCMException {
        try {
            ResourceResolver adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            String configPath = "/var/contentsync/tmp" + page.getPath() + "_" + System.currentTimeMillis();
            this.createConfig(page, configPath, request.getResourceResolver(), adminResolver);
            Session admin = (Session)adminResolver.adaptTo(Session.class);
            if (admin.nodeExists(configPath + "/page")) {
                Node paramNode = JcrUtil.createPath((String)(configPath + "/page/parameters"), (String)"nt:unstructured", (Session)admin);
                for (Object param : request.getParameterMap().keySet()) {
                    String[] values = request.getParameterValues((String)param);
                    if (values.length == 1) {
                        paramNode.setProperty((String)param, values);
                        continue;
                    }
                    if (values.length <= 1) continue;
                    paramNode.setProperty((String)param, values);
                }
                admin.save();
            }
            Resource config = adminResolver.getResource(configPath);
            String zipPath = this.contentSyncManager.getZip(config, null, (Session)request.getResourceResolver().adaptTo(Session.class));
            this.contentSyncManager.sendZip(response, zipPath);
            this.cleanup(configPath, zipPath, adminResolver);
        }
        catch (Exception e) {
            throw new WCMException((Throwable)e);
        }
    }

    public void export(Page page, ResourceResolver resolver, String targetPath) throws WCMException {
        try {
            ResourceResolver adminResolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            Session admin = (Session)adminResolver.adaptTo(Session.class);
            String configPath = "/var/contentsync/tmp" + page.getPath() + System.currentTimeMillis();
            this.createConfig(page, configPath, resolver, adminResolver);
            Resource config = adminResolver.getResource(configPath);
            String zipPath = this.contentSyncManager.getZip(config, null, (Session)resolver.adaptTo(Session.class));
            admin.move(zipPath, targetPath);
            admin.save();
            this.cleanup(configPath, zipPath, adminResolver);
        }
        catch (Exception e) {
            throw new WCMException((Throwable)e);
        }
    }

    protected void createConfig(Page page, String configPath, ResourceResolver resolver, ResourceResolver adminResolver) throws RepositoryException, IOException {
        Session admin = (Session)adminResolver.adaptTo(Session.class);
        Designer designer = (Designer)resolver.adaptTo(Designer.class);
        String designPath = designer.getDesignPath(page);
        Node configNode = JcrUtil.createPath((String)configPath, (String)"sling:Folder", (String)"cq:ContentSyncConfig", (Session)admin, (boolean)false);
        configNode.setProperty("cache", false);
        String templatePath = this.findConfigTemplate(page, (Session)resolver.adaptTo(Session.class));
        log.debug("Content sync configuration template selected: {}", (Object)templatePath);
        Node templateNode = admin.getNode(templatePath);
        NodeIterator nodes = templateNode.getNodes();
        while (nodes.hasNext()) {
            Node n = nodes.nextNode();
            JcrUtil.copy((Node)n, (Node)configNode, (String)n.getName(), (boolean)true);
        }
        if (configNode.hasNode("design") && designPath != null && designPath.length() > 0) {
            Node designNode = configNode.getNode("design");
            designNode.setProperty("path", designPath);
        }
        if (configNode.hasNode("page")) {
            Node pageNode = configNode.getNode("page");
            pageNode.setProperty("path", page.getPath());
        }
        admin.save();
    }

    protected void cleanup(String configPath, String zipPath, ResourceResolver adminResolver) throws RepositoryException {
        Session admin = (Session)adminResolver.adaptTo(Session.class);
        Node configNode = admin.getNode(configPath);
        configNode.remove();
        admin.getNode("/var/contentsync" + configPath).remove();
        admin.getNode("/var/contentsync" + zipPath).remove();
        admin.save();
    }

    protected String findConfigTemplate(Page page, Session session) throws RepositoryException {
        String templatePath = null;
        do {
            ValueMap props;
            String path;
            if ((path = (String)(props = ResourceUtil.getValueMap((Resource)page.getContentResource())).get(TEMPLATE_PROPERTY, String.class)) == null || !session.nodeExists(path)) continue;
            templatePath = path;
            break;
        } while ((page = page.getParent()) != null);
        return templatePath != null ? templatePath : DEFAULT_TEMPLATE_PATH;
    }

    protected void bindContentSyncManager(ContentSyncManager contentSyncManager) {
        this.contentSyncManager = contentSyncManager;
    }

    protected void unbindContentSyncManager(ContentSyncManager contentSyncManager) {
        if (this.contentSyncManager == contentSyncManager) {
            this.contentSyncManager = null;
        }
    }

    protected void bindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    protected void unbindResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resolverFactory == resourceResolverFactory) {
            this.resolverFactory = null;
        }
    }
}

