/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.contentsync.impl.rewriter;

import com.day.cq.commons.Externalizer;
import com.day.cq.rewriter.linkchecker.LinkChecker;
import com.day.cq.wcm.contentsync.PathRewriterOptions;
import com.day.cq.wcm.contentsync.impl.rewriter.PathRewriterTransformerConfig;
import com.day.text.Text;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cocoon.xml.sax.AbstractSAXPipe;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.apache.sling.rewriter.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathRewriterTransformer
extends AbstractSAXPipe
implements Transformer {
    private static final Logger log = LoggerFactory.getLogger(PathRewriterTransformer.class);
    private static final String SCRIPT_TAG = "script";
    private final LinkChecker checker;
    private final Externalizer externalizer;
    private boolean enabled = false;
    private SlingHttpServletRequest request;
    private PathRewriterOptions options;
    private String relativePrefix;
    private PathRewriterTransformerConfig config;
    private boolean insideScript;
    private StringBuffer scriptBuffer;

    public PathRewriterTransformer(LinkChecker checker, Externalizer externalizer, PathRewriterTransformerConfig config) {
        this.checker = checker;
        this.externalizer = externalizer;
        this.config = config;
        this.insideScript = false;
    }

    public void init(ProcessingContext context, ProcessingComponentConfiguration config) throws IOException {
        this.request = context.getRequest();
        this.options = (PathRewriterOptions)this.request.getAttribute("pathRewritingOptions");
        this.enabled = this.options != null;
        this.relativePrefix = this.getRelativePathPrefix(this.request);
        if (this.enabled) {
            log.debug("Rewriting paths for links ({}), clientlibs ({}) and images ({})", new Object[]{this.options.getRewriteMode("links").name(), this.options.getRewriteMode("clientlibs").name(), this.options.getRewriteMode("images").name()});
        }
    }

    public void dispose() {
    }

    public void startElement(String uri, String name, String raw, Attributes a) throws SAXException {
        if (this.enabled) {
            AttributesImpl attrs = new AttributesImpl(a);
            boolean result = false;
            result |= this.internalRewrite(this.config.linksMapping, "links", name, attrs);
            result |= this.internalRewrite(this.config.clientlibsMapping, "clientlibs", name, attrs);
            if (result |= this.internalRewrite(this.config.imagesMapping, "images", name, attrs)) {
                super.startElement(uri, name, raw, (Attributes)attrs);
                return;
            }
            if (name.equals(SCRIPT_TAG) && attrs.getValue("type") != null && attrs.getValue("type").equals("text/javascript")) {
                this.insideScript = true;
                this.scriptBuffer = new StringBuffer();
            }
        }
        super.startElement(uri, name, raw, a);
    }

    private boolean internalRewrite(Map<String, String> mapping, String rewriteOption, String name, AttributesImpl attrs) throws SAXException {
        if (mapping.containsKey(name) && this.isTargetOfInterest(attrs.getValue(mapping.get(name)))) {
            if (this.options.isExternal(rewriteOption)) {
                this.makeExternal(mapping.get(name), attrs);
            } else if (this.options.isRelative(rewriteOption)) {
                this.makeRelative(mapping.get(name), attrs);
            }
            return true;
        }
        return false;
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        if (this.insideScript) {
            this.scriptBuffer.append(chars, start, length);
        } else {
            super.characters(chars, start, length);
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        if (loc.equals(SCRIPT_TAG) && this.insideScript) {
            StringBuffer result = new StringBuffer();
            if (Pattern.compile(".*CQClientLibraryManager.*", 32).matcher(this.scriptBuffer).matches()) {
                Pattern pattern = Pattern.compile(this.config.clientLibraryPattern);
                Matcher matcher = pattern.matcher(this.scriptBuffer);
                while (matcher.find()) {
                    String group = matcher.group(1);
                    if (this.options.isExternal("clientlibs")) {
                        matcher.appendReplacement(result, this.config.clientLibraryReplace.replace("$1", this.externalizer.absoluteLink("http", group)));
                        continue;
                    }
                    matcher.appendReplacement(result, this.config.clientLibraryReplace.replace("$1", this.relativePrefix + group));
                }
                matcher.appendTail(result);
            }
            super.characters(result.toString().toCharArray(), 0, result.length());
            this.insideScript = false;
        }
        super.endElement(uri, loc, raw);
    }

    private boolean isTargetOfInterest(String target) {
        return target != null && !this.checker.isSpecial(target) && target.startsWith("/");
    }

    private String getRelativePathPrefix(SlingHttpServletRequest request) {
        String uri = request.getRequestURI();
        String prefix = "";
        int depth = Text.explode((String)uri, (int)47).length;
        prefix = StringUtils.repeat((String)"../", (int)(depth - 1));
        prefix = StringUtils.removeEnd((String)prefix, (String)"/");
        return prefix;
    }

    private void makeExternal(String name, AttributesImpl attributes) {
        int index = attributes.getIndex(name);
        String value = this.externalizer.absoluteLink("http", attributes.getValue(name));
        attributes.setAttribute(index, "", name, name, "String", value);
        log.debug("Attribute \"{}\" rewritten to: {}", (Object)name, (Object)value);
    }

    private void makeRelative(String name, AttributesImpl attributes) {
        int index = attributes.getIndex(name);
        String value = this.relativePrefix + attributes.getValue(name);
        attributes.setAttribute(index, "", name, name, "String", value);
        log.debug("Attribute \"{}\" rewritten to: {}", (Object)name, (Object)value);
    }
}

