/*
 * Decompiled with CFR 0.152.
 */
package com.deepl.api;

import com.deepl.api.DeepLException;
import com.deepl.api.LanguageCode;
import com.deepl.api.TextRephraseOptions;
import com.deepl.api.Translator;
import com.deepl.api.TranslatorOptions;
import com.deepl.api.WriteResult;
import com.deepl.api.http.HttpResponse;
import com.deepl.api.utils.KeyValuePair;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DeepLClient
extends Translator {
    public DeepLClient(String authKey, TranslatorOptions options) throws IllegalArgumentException {
        super(authKey, options);
    }

    public WriteResult rephraseText(String text, @Nullable String targetLang, @Nullable TextRephraseOptions options) throws InterruptedException, DeepLException {
        ArrayList<String> texts = new ArrayList<String>();
        texts.add(text);
        return this.rephraseText(texts, targetLang, options).get(0);
    }

    public List<WriteResult> rephraseText(List<String> texts, @Nullable String targetLang, @Nullable TextRephraseOptions options) throws InterruptedException, DeepLException {
        ArrayList<KeyValuePair<String, String>> params = DeepLClient.createWriteHttpParams(texts, targetLang, options);
        HttpResponse response = this.httpClientWrapper.sendRequestWithBackoff("/v2/write/rephrase", params);
        this.checkResponse(response, false, false);
        return this.jsonParser.parseWriteResult(response.getBody());
    }

    protected static ArrayList<KeyValuePair<String, String>> createWriteHttpParams(List<String> texts, @Nullable String targetLang, @Nullable TextRephraseOptions options) {
        targetLang = LanguageCode.standardize(targetLang);
        DeepLClient.checkValidLanguages(null, targetLang);
        ArrayList<KeyValuePair<String, String>> params = new ArrayList<KeyValuePair<String, String>>();
        if (targetLang != null) {
            params.add(new KeyValuePair<String, String>("target_lang", targetLang));
        }
        if (options != null && options.getWritingStyle() != null) {
            params.add(new KeyValuePair<String, String>("writing_style", options.getWritingStyle()));
        }
        if (options != null && options.getTone() != null) {
            params.add(new KeyValuePair<String, String>("tone", options.getTone()));
        }
        texts.forEach(text -> {
            if (text.isEmpty()) {
                throw new IllegalArgumentException("text must not be empty");
            }
            params.add(new KeyValuePair<String, String>("text", (String)text));
        });
        return params;
    }
}

