/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.LazyForwardingEquality;
import com.diffplug.spotless.Lint;
import com.diffplug.spotless.ThrowingEx;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
abstract class FormatterStepEqualityOnStateSerialization<State extends Serializable>
implements FormatterStep,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient FormatterFunc formatter;
    private transient State stateInternal;
    private transient byte[] serializedStateInternal;

    FormatterStepEqualityOnStateSerialization() {
    }

    protected abstract State stateSupplier() throws Exception;

    protected abstract FormatterFunc stateToFormatter(State var1) throws Exception;

    @Override
    public String format(String rawUnix, File file) throws Exception {
        if (this.formatter == null) {
            this.formatter = this.stateToFormatter(this.state());
        }
        return this.formatter.apply(rawUnix, file);
    }

    @Override
    public List<Lint> lint(String content, File file) throws Exception {
        if (this.formatter == null) {
            this.formatter = this.stateToFormatter(this.state());
        }
        return this.formatter.lint(content, file);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.serializedState(), ((FormatterStepEqualityOnStateSerialization)o).serializedState());
    }

    public int hashCode() {
        return Arrays.hashCode(this.serializedState());
    }

    @Override
    public void close() {
        if (this.formatter instanceof FormatterFunc.Closeable) {
            ((FormatterFunc.Closeable)this.formatter).close();
            this.formatter = null;
        }
    }

    private State state() throws Exception {
        if (this.stateInternal == null) {
            this.stateInternal = this.stateSupplier();
        }
        return this.stateInternal;
    }

    private byte[] serializedState() {
        if (this.serializedStateInternal == null) {
            this.serializedStateInternal = ThrowingEx.get(() -> LazyForwardingEquality.toBytes(this.state()));
        }
        return this.serializedStateInternal;
    }
}

