/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.master;

import com.digitalpetri.modbus.master.ModbusTcpMaster;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChannelManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<State> state = new AtomicReference<Idle>(new Idle());
    private final ModbusTcpMaster master;

    ChannelManager(ModbusTcpMaster master) {
        this.master = master;
    }

    CompletableFuture<Channel> getChannel() {
        State currentState = this.state.get();
        if (currentState instanceof Idle) {
            Connecting nextState = new Connecting();
            if (this.state.compareAndSet(currentState, nextState)) {
                CompletableFuture future = nextState.future;
                future.whenComplete((ch, ex) -> {
                    if (ch != null) {
                        this.state.set(new Connected(future));
                    } else {
                        this.state.set(new Idle());
                    }
                });
                return this.connect(future);
            }
            return this.getChannel();
        }
        if (currentState instanceof Connecting) {
            return ((Connecting)currentState).future;
        }
        if (currentState instanceof Connected) {
            return ((Connected)currentState).future;
        }
        throw new IllegalStateException(currentState.getClass().getSimpleName());
    }

    private CompletableFuture<Channel> connect(CompletableFuture<Channel> future) {
        CompletableFuture<Channel> bootstrap = ModbusTcpMaster.bootstrap(this.master, this.master.getConfig());
        bootstrap.whenComplete((ch, ex) -> {
            if (ch != null) {
                this.logger.debug("Channel bootstrap succeeded: localAddress={}, remoteAddress={}", (Object)ch.localAddress(), (Object)ch.remoteAddress());
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        State currentState = (State)ChannelManager.this.state.get();
                        if (currentState instanceof Connected && ChannelManager.this.state.compareAndSet(currentState, new Idle())) {
                            ChannelManager.this.logger.debug("channelInactive(), transitioned to Idle");
                        }
                        super.channelInactive(ctx);
                    }
                }});
                future.complete((Channel)ch);
            } else {
                this.logger.debug("Channel bootstrap failed: {}", (Object)ex.getMessage(), ex);
                future.completeExceptionally((Throwable)ex);
            }
        });
        return future;
    }

    CompletableFuture<Void> disconnect() {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        State currentState = this.state.get();
        BiConsumer<Channel, Throwable> disconnect = (ch, ex) -> {
            this.state.compareAndSet(currentState, new Idle());
            if (ch != null) {
                ch.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        ChannelManager.this.logger.debug("channelInactive(), disconnect complete");
                        future.complete(null);
                    }
                }});
                ch.close();
            } else {
                future.complete(null);
            }
        };
        if (currentState instanceof Idle) {
            future.complete(null);
        } else if (currentState instanceof Connecting) {
            ((Connecting)currentState).future.whenComplete(disconnect);
        } else if (currentState instanceof Connected) {
            ((Connected)currentState).future.whenComplete(disconnect);
        }
        return future;
    }

    private static class Connected
    extends State {
        private final CompletableFuture<Channel> future;

        private Connected(CompletableFuture<Channel> future) {
            this.future = future;
        }
    }

    private static class Connecting
    extends State {
        private final CompletableFuture<Channel> future = new CompletableFuture();

        private Connecting() {
        }
    }

    private static class Idle
    extends State {
        private Idle() {
        }
    }

    private static abstract class State {
        private State() {
        }
    }
}

