/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.spec.history;

import com.dimajix.common.ExceptionUtils;
import com.dimajix.flowman.documentation.Documenter;
import com.dimajix.flowman.documentation.EntityDoc;
import com.dimajix.flowman.documentation.ProjectDoc;
import com.dimajix.flowman.execution.Execution;
import com.dimajix.flowman.execution.Phase;
import com.dimajix.flowman.execution.Status;
import com.dimajix.flowman.graph.GraphBuilder;
import com.dimajix.flowman.history.AbstractStateStore;
import com.dimajix.flowman.history.DocumentationQuery;
import com.dimajix.flowman.history.DocumenterToken;
import com.dimajix.flowman.history.Graph;
import com.dimajix.flowman.history.Graph$;
import com.dimajix.flowman.history.JobColumn;
import com.dimajix.flowman.history.JobOrder;
import com.dimajix.flowman.history.JobQuery;
import com.dimajix.flowman.history.JobState;
import com.dimajix.flowman.history.JobState$;
import com.dimajix.flowman.history.JobToken;
import com.dimajix.flowman.history.Measurement;
import com.dimajix.flowman.history.MetricSeries;
import com.dimajix.flowman.history.TargetColumn;
import com.dimajix.flowman.history.TargetOrder;
import com.dimajix.flowman.history.TargetQuery;
import com.dimajix.flowman.history.TargetState;
import com.dimajix.flowman.history.TargetToken;
import com.dimajix.flowman.model.DocumenterResult;
import com.dimajix.flowman.model.Job;
import com.dimajix.flowman.model.JobDigest;
import com.dimajix.flowman.model.JobResult;
import com.dimajix.flowman.model.Logging;
import com.dimajix.flowman.model.Target;
import com.dimajix.flowman.model.TargetDigest;
import com.dimajix.flowman.model.TargetResult;
import com.dimajix.flowman.spec.history.StateRepository;
import com.dimajix.flowman.spi.LogFilter;
import com.dimajix.flowman.spi.LogFilter$;
import java.io.Serializable;
import java.time.Clock;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015u!B7o\u0011\u0003Ih!B>o\u0011\u0003a\bbBA\u0004\u0003\u0011\u0005\u0011\u0011\u0002\u0004\u0007\u0003\u0017\t\u0001)!\u0004\t\u0015\u0005\u00152A!f\u0001\n\u0003\t9\u0003\u0003\u0006\u0002\\\u000e\u0011\t\u0012)A\u0005\u0003SAq!a\u0002\u0004\t\u0003\ti\u000eC\u0005\u0002`\r\t\t\u0011\"\u0001\u0002d\"I\u0011qM\u0002\u0012\u0002\u0013\u0005\u0011q\u001d\u0005\n\u0003\u000b\u001b\u0011\u0011!C!\u0003\u000fC\u0011\"!'\u0004\u0003\u0003%\t!a'\t\u0013\u0005\r6!!A\u0005\u0002\u0005-\b\"CAY\u0007\u0005\u0005I\u0011IAZ\u0011%\t\tmAA\u0001\n\u0003\ty\u000fC\u0005\u0002N\u000e\t\t\u0011\"\u0011\u0002P\"I\u0011\u0011[\u0002\u0002\u0002\u0013\u0005\u00131\u001b\u0005\n\u0003+\u001c\u0011\u0011!C!\u0003g<\u0011\"a>\u0002\u0003\u0003E\t!!?\u0007\u0013\u0005-\u0011!!A\t\u0002\u0005m\bbBA\u0004%\u0011\u0005!\u0011\u0002\u0005\n\u0003#\u0014\u0012\u0011!C#\u0003'D\u0011Ba\u0003\u0013\u0003\u0003%\tI!\u0004\t\u0013\tE!#!A\u0005\u0002\nM\u0001\"\u0003B\u000e%\u0005\u0005I\u0011\u0002B\u000f\r\u0019\u0011)#\u0001!\u0003(!Q\u0011Q\b\r\u0003\u0016\u0004%\tAa\f\t\u0015\u0005\u001d\u0003D!E!\u0002\u0013\u0011\t\u0004\u0003\u0006\u0002&a\u0011)\u001a!C\u0001\u0003OA!\"a7\u0019\u0005#\u0005\u000b\u0011BA\u0015\u0011\u001d\t9\u0001\u0007C\u0001\u0005oA\u0011\"a\u0018\u0019\u0003\u0003%\tAa\u0010\t\u0013\u0005\u001d\u0004$%A\u0005\u0002\t\u0015\u0003\"CA@1E\u0005I\u0011AAt\u0011%\t)\tGA\u0001\n\u0003\n9\tC\u0005\u0002\u001ab\t\t\u0011\"\u0001\u0002\u001c\"I\u00111\u0015\r\u0002\u0002\u0013\u0005!\u0011\n\u0005\n\u0003cC\u0012\u0011!C!\u0003gC\u0011\"!1\u0019\u0003\u0003%\tA!\u0014\t\u0013\u00055\u0007$!A\u0005B\u0005=\u0007\"CAi1\u0005\u0005I\u0011IAj\u0011%\t)\u000eGA\u0001\n\u0003\u0012\tfB\u0005\u0003V\u0005\t\t\u0011#\u0001\u0003X\u0019I!QE\u0001\u0002\u0002#\u0005!\u0011\f\u0005\b\u0003\u000fQC\u0011\u0001B1\u0011%\t\tNKA\u0001\n\u000b\n\u0019\u000eC\u0005\u0003\f)\n\t\u0011\"!\u0003d!I!\u0011\u0003\u0016\u0002\u0002\u0013\u0005%\u0011\u000e\u0005\n\u00057Q\u0013\u0011!C\u0005\u0005;1a!a\r\u0002\u0001\u0006U\u0002BCA\u001fa\tU\r\u0011\"\u0001\u0002@!Q\u0011q\t\u0019\u0003\u0012\u0003\u0006I!!\u0011\t\u0015\u0005%\u0003G!f\u0001\n\u0003\tY\u0005\u0003\u0006\u0002XA\u0012\t\u0012)A\u0005\u0003\u001bBq!a\u00021\t\u0003\tI\u0006C\u0005\u0002`A\n\t\u0011\"\u0001\u0002b!I\u0011q\r\u0019\u0012\u0002\u0013\u0005\u0011\u0011\u000e\u0005\n\u0003\u007f\u0002\u0014\u0013!C\u0001\u0003\u0003C\u0011\"!\"1\u0003\u0003%\t%a\"\t\u0013\u0005e\u0005'!A\u0005\u0002\u0005m\u0005\"CARa\u0005\u0005I\u0011AAS\u0011%\t\t\fMA\u0001\n\u0003\n\u0019\fC\u0005\u0002BB\n\t\u0011\"\u0001\u0002D\"I\u0011Q\u001a\u0019\u0002\u0002\u0013\u0005\u0013q\u001a\u0005\n\u0003#\u0004\u0014\u0011!C!\u0003'D\u0011\"!61\u0003\u0003%\t%a6\b\u0013\tU\u0014!!A\t\u0002\t]d!CA\u001a\u0003\u0005\u0005\t\u0012\u0001B=\u0011\u001d\t9A\u0011C\u0001\u0005{B\u0011\"!5C\u0003\u0003%)%a5\t\u0013\t-!)!A\u0005\u0002\n}\u0004\"\u0003B\t\u0005\u0006\u0005I\u0011\u0011BC\u0011%\u0011YBQA\u0001\n\u0013\u0011iB\u0002\u0004|]\u0006\u0005!Q\u0012\u0005\b\u0003\u000fAE\u0011\u0001BQ\u0011%\u0011)\u000b\u0013b\u0001\n\u0013\u00119\u000b\u0003\u0005\u0003N\"\u0003\u000b\u0011\u0002BU\u0011\u001d\u0011y\r\u0013C!\u0005#DqAa8I\t\u0003\u0012\t\u000fC\u0004\u0003~\"#\tEa@\t\u000f\r-\u0001\n\"\u0011\u0004\u000e!91q\u0003%\u0005B\re\u0001bBB\u0014\u0011\u0012\u00053\u0011\u0006\u0005\n\u0007\u0007B\u0015\u0013!C\u0001\u0007\u000bBqa!\u0013I\t\u0003\u001aY\u0005C\u0004\u0004J!#\ta!\u0017\t\u000f\r}\u0003\n\"\u0011\u0004b!91\u0011\u000f%\u0005B\rM\u0004bBB@\u0011\u0012\u00053\u0011\u0011\u0005\b\u0007+CE\u0011IBL\u0011\u001d\u0019\u0019\u000b\u0013C!\u0007KC\u0011ba2I#\u0003%\ta!3\t\u0013\r5\u0007*%A\u0005\u0002\r=\u0007\"CBj\u0011F\u0005I\u0011ABh\u0011\u001d\u0019)\u000e\u0013C!\u0007/Dqa!6I\t\u0003\u001aY\u000eC\u0004\u0004l\"#\te!<\t\u000f\u0011\u0005\u0001\n\"\u0011\u0005\u0004!IAQ\u0004%\u0012\u0002\u0013\u0005Aq\u0004\u0005\n\tGA\u0015\u0013!C\u0001\u0007\u001fD\u0011\u0002\"\nI#\u0003%\taa4\t\u000f\u0011\u001d\u0002\n\"\u0011\u0005*!9Aq\u0005%\u0005B\u00115\u0002b\u0002C\u001d\u0011\u0012\u0005C1\b\u0005\b\t\u001bBe\u0011\u0001C(\u0011\u001d!9\u0006\u0013C\t\t3B\u0011\u0002\"\u001eI\u0001\u0004%I\u0001b\u001e\t\u0013\u0011e\u0004\n1A\u0005\n\u0011m\u0004\u0002\u0003C@\u0011\u0002\u0006K!!2\t\u000f\u0011\u0005\u0005\n\"\u0003\u0005\u0004\u0006!\"+\u001a9pg&$xN]=Ti\u0006$Xm\u0015;pe\u0016T!a\u001c9\u0002\u000f!L7\u000f^8ss*\u0011\u0011O]\u0001\u0005gB,7M\u0003\u0002ti\u00069a\r\\8x[\u0006t'BA;w\u0003\u001d!\u0017.\\1kSbT\u0011a^\u0001\u0004G>l7\u0001\u0001\t\u0003u\u0006i\u0011A\u001c\u0002\u0015%\u0016\u0004xn]5u_JL8\u000b^1uKN#xN]3\u0014\u0005\u0005i\bc\u0001@\u0002\u00045\tqP\u0003\u0002\u0002\u0002\u0005)1oY1mC&\u0019\u0011QA@\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011PA\rSKB|7/\u001b;pef$unY;nK:$XM\u001d+pW\u0016t7cB\u0002\u0002\u0010\u0005e\u0011q\u0004\t\u0005\u0003#\t)\"\u0004\u0002\u0002\u0014)\u0011qN]\u0005\u0005\u0003/\t\u0019BA\bE_\u000e,X.\u001a8uKJ$vn[3o!\rq\u00181D\u0005\u0004\u0003;y(a\u0002)s_\u0012,8\r\u001e\t\u0004}\u0006\u0005\u0012bAA\u0012\u007f\na1+\u001a:jC2L'0\u00192mK\u00061\u0001/\u0019:f]R,\"!!\u000b\u0011\u000by\fY#a\f\n\u0007\u00055rP\u0001\u0004PaRLwN\u001c\t\u0004\u0003c\u0001T\"A\u0001\u0003%I+\u0007o\\:ji>\u0014\u0018PS8c)>\\WM\\\n\ba\u0005]\u0012\u0011DA\u0010!\u0011\t\t\"!\u000f\n\t\u0005m\u00121\u0003\u0002\t\u0015>\u0014Gk\\6f]\u0006\u0019!/\u001e8\u0016\u0005\u0005\u0005\u0003\u0003BA\t\u0003\u0007JA!!\u0012\u0002\u0014\tA!j\u001c2Ti\u0006$X-\u0001\u0003sk:\u0004\u0013!B4sCBDWCAA'!\u0011\ty%a\u0015\u000e\u0005\u0005E#bAA%e&!\u0011QKA)\u000519%/\u00199i\u0005VLG\u000eZ3s\u0003\u00199'/\u00199iAQ1\u0011qFA.\u0003;Bq!!\u00106\u0001\u0004\t\t\u0005C\u0004\u0002JU\u0002\r!!\u0014\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003_\t\u0019'!\u001a\t\u0013\u0005ub\u0007%AA\u0002\u0005\u0005\u0003\"CA%mA\u0005\t\u0019AA'\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u001b+\t\u0005\u0005\u0013QN\u0016\u0003\u0003_\u0002B!!\u001d\u0002|5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011P@\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002~\u0005M$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAABU\u0011\ti%!\u001c\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\t\u0005\u0003\u0002\f\u0006UUBAAG\u0015\u0011\ty)!%\u0002\t1\fgn\u001a\u0006\u0003\u0003'\u000bAA[1wC&!\u0011qSAG\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0014\t\u0004}\u0006}\u0015bAAQ\u007f\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qUAW!\rq\u0018\u0011V\u0005\u0004\u0003W{(aA!os\"I\u0011qV\u001e\u0002\u0002\u0003\u0007\u0011QT\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\u0006CBA\\\u0003{\u000b9+\u0004\u0002\u0002:*\u0019\u00111X@\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002@\u0006e&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!2\u0002LB\u0019a0a2\n\u0007\u0005%wPA\u0004C_>dW-\u00198\t\u0013\u0005=V(!AA\u0002\u0005\u001d\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005u\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005%\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002F\u0006e\u0007\"CAX\u0001\u0006\u0005\t\u0019AAT\u0003\u001d\u0001\u0018M]3oi\u0002\"B!a8\u0002bB\u0019\u0011\u0011G\u0002\t\u000f\u0005\u0015b\u00011\u0001\u0002*Q!\u0011q\\As\u0011%\t)c\u0002I\u0001\u0002\u0004\tI#\u0006\u0002\u0002j*\"\u0011\u0011FA7)\u0011\t9+!<\t\u0013\u0005=6\"!AA\u0002\u0005uE\u0003BAc\u0003cD\u0011\"a,\u000e\u0003\u0003\u0005\r!a*\u0015\t\u0005\u0015\u0017Q\u001f\u0005\n\u0003_\u0003\u0012\u0011!a\u0001\u0003O\u000b\u0011DU3q_NLGo\u001c:z\t>\u001cW/\\3oi\u0016\u0014Hk\\6f]B\u0019\u0011\u0011\u0007\n\u0014\u000bI\ti0a\b\u0011\u0011\u0005}(QAA\u0015\u0003?l!A!\u0001\u000b\u0007\t\rq0A\u0004sk:$\u0018.\\3\n\t\t\u001d!\u0011\u0001\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\fDCAA}\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\tyNa\u0004\t\u000f\u0005\u0015R\u00031\u0001\u0002*\u00059QO\\1qa2LH\u0003\u0002B\u000b\u0005/\u0001RA`A\u0016\u0003SA\u0011B!\u0007\u0017\u0003\u0003\u0005\r!a8\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0010!\u0011\tYI!\t\n\t\t\r\u0012Q\u0012\u0002\u0007\u001f\nTWm\u0019;\u0003+I+\u0007o\\:ji>\u0014\u0018\u0010V1sO\u0016$Hk\\6f]N9\u0001D!\u000b\u0002\u001a\u0005}\u0001\u0003BA\t\u0005WIAA!\f\u0002\u0014\tYA+\u0019:hKR$vn[3o+\t\u0011\t\u0004\u0005\u0003\u0002\u0012\tM\u0012\u0002\u0002B\u001b\u0003'\u00111\u0002V1sO\u0016$8\u000b^1uKR1!\u0011\bB\u001e\u0005{\u00012!!\r\u0019\u0011\u001d\ti$\ba\u0001\u0005cAq!!\n\u001e\u0001\u0004\tI\u0003\u0006\u0004\u0003:\t\u0005#1\t\u0005\n\u0003{q\u0002\u0013!a\u0001\u0005cA\u0011\"!\n\u001f!\u0003\u0005\r!!\u000b\u0016\u0005\t\u001d#\u0006\u0002B\u0019\u0003[\"B!a*\u0003L!I\u0011qV\u0012\u0002\u0002\u0003\u0007\u0011Q\u0014\u000b\u0005\u0003\u000b\u0014y\u0005C\u0005\u00020\u0016\n\t\u00111\u0001\u0002(R!\u0011Q\u0019B*\u0011%\ty\u000bKA\u0001\u0002\u0004\t9+A\u000bSKB|7/\u001b;pef$\u0016M]4fiR{7.\u001a8\u0011\u0007\u0005E\"fE\u0003+\u00057\ny\u0002\u0005\u0006\u0002\u0000\nu#\u0011GA\u0015\u0005sIAAa\u0018\u0003\u0002\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\t]CC\u0002B\u001d\u0005K\u00129\u0007C\u0004\u0002>5\u0002\rA!\r\t\u000f\u0005\u0015R\u00061\u0001\u0002*Q!!1\u000eB:!\u0015q\u00181\u0006B7!\u001dq(q\u000eB\u0019\u0003SI1A!\u001d\u0000\u0005\u0019!V\u000f\u001d7fe!I!\u0011\u0004\u0018\u0002\u0002\u0003\u0007!\u0011H\u0001\u0013%\u0016\u0004xn]5u_JL(j\u001c2U_.,g\u000eE\u0002\u00022\t\u001bRA\u0011B>\u0003?\u0001\"\"a@\u0003^\u0005\u0005\u0013QJA\u0018)\t\u00119\b\u0006\u0004\u00020\t\u0005%1\u0011\u0005\b\u0003{)\u0005\u0019AA!\u0011\u001d\tI%\u0012a\u0001\u0003\u001b\"BAa\"\u0003\fB)a0a\u000b\u0003\nB9aPa\u001c\u0002B\u00055\u0003\"\u0003B\r\r\u0006\u0005\t\u0019AA\u0018'\u0015A%q\u0012BK!\u0011\t\tB!%\n\t\tM\u00151\u0003\u0002\u0013\u0003\n\u001cHO]1diN#\u0018\r^3Ti>\u0014X\r\u0005\u0003\u0003\u0018\nuUB\u0001BM\u0015\r\u0011YJ]\u0001\u0006[>$W\r\\\u0005\u0005\u0005?\u0013IJA\u0004M_\u001e<\u0017N\\4\u0015\u0005\t\r\u0006C\u0001>I\u0003)awn\u001a$jYR,'o]\u000b\u0003\u0005S\u0003bAa+\u0003<\n\u0005g\u0002\u0002BW\u0005osAAa,\u000366\u0011!\u0011\u0017\u0006\u0004\u0005gC\u0018A\u0002\u001fs_>$h(\u0003\u0002\u0002\u0002%\u0019!\u0011X@\u0002\u000fA\f7m[1hK&!!Q\u0018B`\u0005\r\u0019V-\u001d\u0006\u0004\u0005s{\b\u0003\u0002Bb\u0005\u0013l!A!2\u000b\u0007\t\u001d'/A\u0002ta&LAAa3\u0003F\nIAj\\4GS2$XM]\u0001\fY><g)\u001b7uKJ\u001c\b%A\u0006hKRTuNY*uCR,G\u0003\u0002Bj\u0005+\u0004RA`A\u0016\u0003\u0003BqAa6M\u0001\u0004\u0011I.A\u0002k_\n\u0004BAa&\u0003\\&!!Q\u001cBM\u0005%QuN\u0019#jO\u0016\u001cH/A\u0007hKRTuNY'fiJL7m\u001d\u000b\u0005\u0005G\u0014Y\u000f\u0005\u0004\u0003,\nm&Q\u001d\t\u0005\u0003#\u00119/\u0003\u0003\u0003j\u0006M!aC'fCN,(/Z7f]RDqA!<N\u0001\u0004\u0011y/A\u0003k_\nLE\r\u0005\u0003\u0003r\neh\u0002\u0002Bz\u0005k\u00042Aa,\u0000\u0013\r\u00119p`\u0001\u0007!J,G-\u001a4\n\t\u0005]%1 \u0006\u0004\u0005o|\u0018aC4fi*{'m\u0012:ba\"$Ba!\u0001\u0004\nA)a0a\u000b\u0004\u0004A!\u0011\u0011CB\u0003\u0013\u0011\u00199!a\u0005\u0003\u000b\u001d\u0013\u0018\r\u001d5\t\u000f\t5h\n1\u0001\u0003p\u0006\tr-\u001a;K_\n,eN^5s_:lWM\u001c;\u0015\t\r=1Q\u0003\t\t\u0005c\u001c\tBa<\u0003p&!11\u0003B~\u0005\ri\u0015\r\u001d\u0005\b\u0005[|\u0005\u0019\u0001Bx\u0003!\u0019H/\u0019:u\u0015>\u0014GCBA\u001c\u00077\u0019\u0019\u0003C\u0004\u0003XB\u0003\ra!\b\u0011\t\t]5qD\u0005\u0005\u0007C\u0011IJA\u0002K_\nDqa!\nQ\u0001\u0004\u0011I.\u0001\u0004eS\u001e,7\u000f^\u0001\nM&t\u0017n\u001d5K_\n$\u0002ba\u000b\u00042\rU2q\b\t\u0004}\u000e5\u0012bAB\u0018\u007f\n!QK\\5u\u0011\u001d\u0019\u0019$\u0015a\u0001\u0003o\tQ\u0001^8lK:Dqaa\u000eR\u0001\u0004\u0019I$\u0001\u0004sKN,H\u000e\u001e\t\u0005\u0005/\u001bY$\u0003\u0003\u0004>\te%!\u0003&pEJ+7/\u001e7u\u0011%\u0019\t%\u0015I\u0001\u0002\u0004\u0011\u0019/A\u0004nKR\u0014\u0018nY:\u0002'\u0019Lg.[:i\u0015>\u0014G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r\u001d#\u0006\u0002Br\u0003[\nabZ3u)\u0006\u0014x-\u001a;Ti\u0006$X\r\u0006\u0003\u0004N\r=\u0003#\u0002@\u0002,\tE\u0002bBB)'\u0002\u000711K\u0001\u0007i\u0006\u0014x-\u001a;\u0011\t\t]5QK\u0005\u0005\u0007/\u0012IJ\u0001\u0007UCJ<W\r\u001e#jO\u0016\u001cH\u000f\u0006\u0003\u00032\rm\u0003bBB/)\u0002\u0007!q^\u0001\ti\u0006\u0014x-\u001a;JI\u0006Y1\u000f^1siR\u000b'oZ3u)!\u0011Ica\u0019\u0004l\r5\u0004bBB)+\u0002\u00071Q\r\t\u0005\u0005/\u001b9'\u0003\u0003\u0004j\te%A\u0002+be\u001e,G\u000fC\u0004\u0004&U\u0003\raa\u0015\t\u000f\u0005\u0015R\u000b1\u0001\u0004pA)a0a\u000b\u00028\u0005aa-\u001b8jg\"$\u0016M]4fiR111FB;\u0007oBqaa\rW\u0001\u0004\u0011I\u0003C\u0004\u00048Y\u0003\ra!\u001f\u0011\t\t]51P\u0005\u0005\u0007{\u0012IJ\u0001\u0007UCJ<W\r\u001e*fgVdG/A\bti\u0006\u0014H\u000fR8dk6,g\u000e^3s)\u0019\tyaa!\u0004\u0014\"91QQ,A\u0002\r\u001d\u0015A\u00033pGVlWM\u001c;feB!1\u0011RBH\u001b\t\u0019YIC\u0002\u0004\u000eJ\fQ\u0002Z8dk6,g\u000e^1uS>t\u0017\u0002BBI\u0007\u0017\u0013!\u0002R8dk6,g\u000e^3s\u0011\u001d\t)c\u0016a\u0001\u0007_\n\u0001CZ5oSNDGi\\2v[\u0016tG/\u001a:\u0015\r\r-2\u0011TBN\u0011\u001d\u0019\u0019\u0004\u0017a\u0001\u0003\u001fAqaa\u000eY\u0001\u0004\u0019i\n\u0005\u0003\u0003\u0018\u000e}\u0015\u0002BBQ\u00053\u0013\u0001\u0003R8dk6,g\u000e^3s%\u0016\u001cX\u000f\u001c;\u0002\u0011\u0019Lg\u000e\u001a&pEN$\"ba*\u0004*\u000eM6qXBb!\u0019\u0011YKa/\u0002B!911V-A\u0002\r5\u0016!B9vKJL\b\u0003BA\t\u0007_KAa!-\u0002\u0014\tA!j\u001c2Rk\u0016\u0014\u0018\u0010C\u0005\u00046f\u0003\n\u00111\u0001\u00048\u0006)qN\u001d3feB1!1\u0016B^\u0007s\u0003B!!\u0005\u0004<&!1QXA\n\u0005!QuNY(sI\u0016\u0014\b\"CBa3B\u0005\t\u0019AAO\u0003\u0015a\u0017.\\5u\u0011%\u0019)-\u0017I\u0001\u0002\u0004\ti*\u0001\u0004pM\u001a\u001cX\r^\u0001\u0013M&tGMS8cg\u0012\"WMZ1vYR$#'\u0006\u0002\u0004L*\"1qWA7\u0003I1\u0017N\u001c3K_\n\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\rE'\u0006BAO\u0003[\n!CZ5oI*{'m\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005I1m\\;oi*{'m\u001d\u000b\u0005\u0003;\u001bI\u000eC\u0004\u0004,v\u0003\ra!,\u0015\r\ru7q\\Bq!!\u0011\tp!\u0005\u0003p\u0006u\u0005bBBV=\u0002\u00071Q\u0016\u0005\b\u0007Gt\u0006\u0019ABs\u0003!9'o\\;qS:<\u0007\u0003BA\t\u0007OLAa!;\u0002\u0014\tI!j\u001c2D_2,XN\\\u0001\u000fM&tGMS8c\u001b\u0016$(/[2t)\u0019\u0019yoa>\u0004|B1!1\u0016B^\u0007c\u0004B!!\u0005\u0004t&!1Q_A\n\u00051iU\r\u001e:jGN+'/[3t\u0011\u001d\u0019Ip\u0018a\u0001\u0007[\u000b\u0001B[8c#V,'/\u001f\u0005\b\u0007{|\u0006\u0019AB\u0000\u0003%9'o\\;qS:<7\u000f\u0005\u0004\u0003,\nm&q^\u0001\fM&tG\rV1sO\u0016$8\u000f\u0006\u0006\u0005\u0006\u0011\u001dAq\u0002C\r\t7\u0001bAa+\u0003<\nE\u0002bBBVA\u0002\u0007A\u0011\u0002\t\u0005\u0003#!Y!\u0003\u0003\u0005\u000e\u0005M!a\u0003+be\u001e,G/U;fefD\u0011b!.a!\u0003\u0005\r\u0001\"\u0005\u0011\r\t-&1\u0018C\n!\u0011\t\t\u0002\"\u0006\n\t\u0011]\u00111\u0003\u0002\f)\u0006\u0014x-\u001a;Pe\u0012,'\u000fC\u0005\u0004B\u0002\u0004\n\u00111\u0001\u0002\u001e\"I1Q\u00191\u0011\u0002\u0003\u0007\u0011QT\u0001\u0016M&tG\rV1sO\u0016$8\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t!\tC\u000b\u0003\u0005\u0012\u00055\u0014!\u00064j]\u0012$\u0016M]4fiN$C-\u001a4bk2$HeM\u0001\u0016M&tG\rV1sO\u0016$8\u000f\n3fM\u0006,H\u000e\u001e\u00135\u00031\u0019w.\u001e8u)\u0006\u0014x-\u001a;t)\u0011\ti\nb\u000b\t\u000f\r-F\r1\u0001\u0005\nQ11Q\u001cC\u0018\tcAqaa+f\u0001\u0004!I\u0001C\u0004\u0004d\u0016\u0004\r\u0001b\r\u0011\t\u0005EAQG\u0005\u0005\to\t\u0019B\u0001\u0007UCJ<W\r^\"pYVlg.A\tgS:$Gi\\2v[\u0016tG/\u0019;j_:$B\u0001\"\u0010\u0005FA1!1\u0016B^\t\u007f\u0001Ba!#\u0005B%!A1IBF\u0005%)e\u000e^5us\u0012{7\rC\u0004\u0004,\u001a\u0004\r\u0001b\u0012\u0011\t\u0005EA\u0011J\u0005\u0005\t\u0017\n\u0019B\u0001\nE_\u000e,X.\u001a8uCRLwN\\)vKJL\u0018A\u0003:fa>\u001c\u0018\u000e^8ssV\u0011A\u0011\u000b\t\u0004u\u0012M\u0013b\u0001C+]\ny1\u000b^1uKJ+\u0007o\\:ji>\u0014\u00180\u0001\bxSRD'+\u001a9pg&$xN]=\u0016\t\u0011mC\u0011\r\u000b\u0005\t;\"i\u0007\u0005\u0003\u0005`\u0011\u0005D\u0002\u0001\u0003\b\tGB'\u0019\u0001C3\u0005\u0005!\u0016\u0003\u0002C4\u0003O\u00032A C5\u0013\r!Yg \u0002\b\u001d>$\b.\u001b8h\u0011\u001d\u0019Y\u000b\u001ba\u0001\t_\u0002rA C9\t#\"i&C\u0002\u0005t}\u0014\u0011BR;oGRLwN\\\u0019\u0002\u001bQ\f'\r\\3t\u0007J,\u0017\r^3e+\t\t)-A\tuC\ndWm]\"sK\u0006$X\rZ0%KF$Baa\u000b\u0005~!I\u0011q\u00166\u0002\u0002\u0003\u0007\u0011QY\u0001\u000fi\u0006\u0014G.Z:De\u0016\fG/\u001a3!\u00031)gn];sKR\u000b'\r\\3t)\t\u0019Y\u0003")
public abstract class RepositoryStateStore
extends AbstractStateStore
implements Logging {
    private final Seq<LogFilter> logFilters;
    private boolean tablesCreated;
    private Logger logger;
    private volatile boolean bitmap$0;

    public final Logger getLogger(Execution execution) {
        return Logging.getLogger$((Logging)this, (Execution)execution);
    }

    public final <T> Logger getLogger(Execution execution, Class<T> clazz) {
        return Logging.getLogger$((Logging)this, (Execution)execution, clazz);
    }

    private Logger logger$lzycompute() {
        RepositoryStateStore repositoryStateStore = this;
        synchronized (repositoryStateStore) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Seq<LogFilter> logFilters() {
        return this.logFilters;
    }

    public Option<JobState> getJobState(JobDigest job) {
        this.logger().debug(new StringBuilder(52).append("Checking last state of '").append(job.phase()).append("' job '").append(job.job()).append("' in history database").toString());
        return (Option)this.withRepository((Function1 & Serializable & scala.Serializable)repository -> repository.getJobState(job));
    }

    public Seq<Measurement> getJobMetrics(String jobId) {
        return (Seq)this.withRepository((Function1 & Serializable & scala.Serializable)repository -> repository.getJobMetrics(jobId));
    }

    public Option<Graph> getJobGraph(String jobId) {
        return (Option)this.withRepository((Function1 & Serializable & scala.Serializable)repository -> repository.getJobGraph(jobId));
    }

    public Map<String, String> getJobEnvironment(String jobId) {
        return (Map)this.withRepository((Function1 & Serializable & scala.Serializable)repository -> repository.getJobEnvironment(jobId));
    }

    public JobToken startJob(Job job, JobDigest digest) {
        ZonedDateTime now = Clock.systemDefaultZone().instant().atZone(ZoneId.systemDefault());
        JobState state = new JobState("", (String)job.namespace().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (String)job.project().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (String)job.project().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.version()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), job.name(), digest.phase(), digest.args(), (Status)Status.RUNNING$.MODULE$, (Option)new Some((Object)now), (Option)None$.MODULE$, JobState$.MODULE$.apply$default$11());
        Map env = (Map)job.context().environment().toMap().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Object value = tuple2._2();
                return Option$.MODULE$.option2Iterable(LogFilter$.MODULE$.filter(this.logFilters(), key, value.toString()));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
        this.logger().debug(new StringBuilder(35).append("Start '").append(digest.phase()).append("' job '").append(state.job()).append("' in history database").toString());
        JobState run = (JobState)this.withRepository((Function1 & Serializable & scala.Serializable)repository -> repository.insertJobState(state, (Map<String, String>)env));
        return new RepositoryJobToken(run, new GraphBuilder(job.context(), digest.phase()));
    }

    public void finishJob(JobToken token, JobResult result, Seq<Measurement> metrics) {
        Status status = result.status();
        RepositoryJobToken jdbcToken = (RepositoryJobToken)token;
        JobState run = jdbcToken.run();
        ZonedDateTime now = Clock.systemDefaultZone().instant().atZone(ZoneId.systemDefault());
        Graph graph = Graph$.MODULE$.ofGraph(jdbcToken.graph().build());
        this.withRepository((Function1 & Serializable & scala.Serializable)repository -> {
            RepositoryStateStore.$anonfun$finishJob$1(this, run, status, now, result, metrics, graph, repository);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Measurement> finishJob$default$3() {
        return (Seq)Nil$.MODULE$;
    }

    public Option<TargetState> getTargetState(TargetDigest target) {
        this.logger().debug(new StringBuilder(47).append("Checking state of target '").append(target.target()).append("' in history database").toString());
        return (Option)this.withRepository((Function1 & Serializable & scala.Serializable)repository -> repository.getTargetState(target));
    }

    public TargetState getTargetState(String targetId) {
        return (TargetState)this.withRepository((Function1 & Serializable & scala.Serializable)repository -> repository.getTargetState(targetId));
    }

    public TargetToken startTarget(Target target, TargetDigest digest, Option<JobToken> parent) {
        ZonedDateTime now = Clock.systemDefaultZone().instant().atZone(ZoneId.systemDefault());
        Option parentRun = parent.map((Function1 & Serializable & scala.Serializable)x$4 -> (RepositoryJobToken)((Object)x$4));
        TargetState run = new TargetState("", parentRun.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.run().id()), (String)target.namespace().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (String)target.project().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), (String)target.project().flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.version()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), target.name(), digest.partitions(), digest.phase(), (Status)Status.RUNNING$.MODULE$, (Option)new Some((Object)now), (Option)None$.MODULE$, (Option)None$.MODULE$);
        this.logger().debug(new StringBuilder(38).append("Start '").append(digest.phase()).append("' target '").append(run.target()).append("' in history database").toString());
        TargetState run2 = (TargetState)this.withRepository((Function1 & Serializable & scala.Serializable)repository -> repository.insertTargetState(run));
        return new RepositoryTargetToken(run2, (Option<RepositoryJobToken>)parentRun);
    }

    public void finishTarget(TargetToken token, TargetResult result) {
        Status status = result.status();
        RepositoryTargetToken jdbcToken = (RepositoryTargetToken)token;
        TargetState run = jdbcToken.run();
        this.logger().info(new StringBuilder(41).append("Mark '").append(run.phase()).append("' target '").append(run.target()).append("' as ").append(status).append(" in history database").toString());
        ZonedDateTime now = Clock.systemDefaultZone().instant().atZone(ZoneId.systemDefault());
        this.withRepository((Function1 & Serializable & scala.Serializable)repository -> {
            RepositoryStateStore.$anonfun$finishTarget$1(now, status, result, run, repository);
            return BoxedUnit.UNIT;
        });
        Status status2 = status;
        Status.SKIPPED$ sKIPPED$ = Status.SKIPPED$.MODULE$;
        if (status2 == null ? sKIPPED$ != null : !status2.equals(sKIPPED$)) {
            jdbcToken.parent().foreach((Function1 & Serializable & scala.Serializable)x$9 -> x$9.graph().addTarget(result.target()));
            return;
        }
    }

    public DocumenterToken startDocumenter(Documenter documenter, Option<JobToken> parent) {
        Option parentRun = parent.map((Function1 & Serializable & scala.Serializable)x$10 -> (RepositoryJobToken)((Object)x$10));
        return new RepositoryDocumenterToken((Option<RepositoryJobToken>)parentRun);
    }

    public void finishDocumenter(DocumenterToken token, DocumenterResult result) {
        result.documentation().foreach((Function1 & Serializable & scala.Serializable)doc -> {
            RepositoryStateStore.$anonfun$finishDocumenter$1(this, token, doc);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<JobState> findJobs(JobQuery query, Seq<JobOrder> order, int limit, int offset) {
        return (Seq)this.withRepository((Function1 & Serializable & scala.Serializable)repository -> repository.findJobs(query, order, limit, offset));
    }

    public Seq<JobOrder> findJobs$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    public int findJobs$default$3() {
        return 10000;
    }

    public int findJobs$default$4() {
        return 0;
    }

    public int countJobs(JobQuery query) {
        return BoxesRunTime.unboxToInt(this.withRepository((Function1 & Serializable & scala.Serializable)repository -> BoxesRunTime.boxToInteger((int)repository.countJobs(query))));
    }

    public Map<String, Object> countJobs(JobQuery query, JobColumn grouping) {
        return (Map)this.withRepository((Function1 & Serializable & scala.Serializable)repository -> repository.countJobs(query, grouping).toMap(Predef$.MODULE$.$conforms()));
    }

    public Seq<MetricSeries> findJobMetrics(JobQuery jobQuery, Seq<String> groupings) {
        return (Seq)this.withRepository((Function1 & Serializable & scala.Serializable)repository -> repository.findMetrics(jobQuery, groupings));
    }

    public Seq<TargetState> findTargets(TargetQuery query, Seq<TargetOrder> order, int limit, int offset) {
        return (Seq)this.withRepository((Function1 & Serializable & scala.Serializable)repository -> repository.findTargets(query, order, limit, offset));
    }

    public Seq<TargetOrder> findTargets$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    public int findTargets$default$3() {
        return 10000;
    }

    public int findTargets$default$4() {
        return 0;
    }

    public int countTargets(TargetQuery query) {
        return BoxesRunTime.unboxToInt(this.withRepository((Function1 & Serializable & scala.Serializable)repository -> BoxesRunTime.boxToInteger((int)repository.countTargets(query))));
    }

    public Map<String, Object> countTargets(TargetQuery query, TargetColumn grouping) {
        return (Map)this.withRepository((Function1 & Serializable & scala.Serializable)repository -> repository.countTargets(query, grouping).toMap(Predef$.MODULE$.$conforms()));
    }

    public Seq<EntityDoc> findDocumentation(DocumentationQuery query) {
        return (Seq)this.withRepository((Function1 & Serializable & scala.Serializable)repository -> repository.findDocumentation(query, repository.findDocumentation$default$2(), repository.findDocumentation$default$3()));
    }

    public abstract StateRepository repository();

    public <T> T withRepository(Function1<StateRepository, T> query) {
        this.ensureTables();
        return (T)query.apply((Object)this.repository());
    }

    private boolean tablesCreated() {
        return this.tablesCreated;
    }

    private void tablesCreated_$eq(boolean x$1) {
        this.tablesCreated = x$1;
    }

    private void ensureTables() {
        if (!this.tablesCreated()) {
            this.repository().create();
            this.tablesCreated_$eq(true);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$finishJob$1(RepositoryStateStore $this, JobState run$1, Status status$1, ZonedDateTime now$1, JobResult result$1, Seq metrics$1, Graph graph$1, StateRepository repository) {
        $this.logger().info(new StringBuilder(38).append("Mark '").append(run$1.phase()).append("' job '").append(run$1.job()).append("' as ").append(status$1).append(" in history database").toString());
        Some x$12 = new Some((Object)now$1);
        Status x$2 = status$1;
        Option x$3 = result$1.exception().map((Function1 & Serializable & scala.Serializable)x$1 -> ExceptionUtils.reasons((Throwable)x$1));
        String x$4 = run$1.copy$default$1();
        String x$5 = run$1.copy$default$2();
        String x$6 = run$1.copy$default$3();
        String x$7 = run$1.copy$default$4();
        String x$8 = run$1.copy$default$5();
        Phase x$9 = run$1.copy$default$6();
        Map x$10 = run$1.copy$default$7();
        Option x$11 = run$1.copy$default$9();
        repository.updateJobState(run$1.copy(x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$2, x$11, (Option)x$12, x$3));
        $this.logger().info(new StringBuilder(58).append("Storing execution metrics of '").append(run$1.phase()).append("' job '").append(run$1.job()).append("' in history database").toString());
        repository.insertJobMetrics(run$1.id(), (Seq<Measurement>)metrics$1);
        $this.logger().info(new StringBuilder(56).append("Storing execution graph of '").append(run$1.phase()).append("' job '").append(run$1.job()).append("' in history database").toString());
        repository.insertJobGraph(run$1.id(), graph$1);
    }

    public static final /* synthetic */ void $anonfun$finishTarget$1(ZonedDateTime now$2, Status status$2, TargetResult result$2, TargetState run$3, StateRepository repository) {
        Some x$12 = new Some((Object)now$2);
        Status x$2 = status$2;
        Option x$3 = result$2.exception().map((Function1 & Serializable & scala.Serializable)x$1 -> ExceptionUtils.reasons((Throwable)x$1));
        String x$4 = run$3.copy$default$1();
        Option x$5 = run$3.copy$default$2();
        String x$6 = run$3.copy$default$3();
        String x$7 = run$3.copy$default$4();
        String x$8 = run$3.copy$default$5();
        String x$9 = run$3.copy$default$6();
        Map x$10 = run$3.copy$default$7();
        Phase x$11 = run$3.copy$default$8();
        Option x$122 = run$3.copy$default$10();
        repository.updateTargetState(run$3.copy(x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$2, x$122, (Option)x$12, x$3));
    }

    public static final /* synthetic */ void $anonfun$finishDocumenter$3(RepositoryStateStore $this, RepositoryJobToken parent$1, ProjectDoc doc$1, StateRepository repository) {
        $this.logger().info(new StringBuilder(54).append("Storing documentation of '").append(parent$1.run().phase()).append("' job '").append(parent$1.run().job()).append("' in history database").toString());
        repository.insertJobDocumentation(parent$1.run().id(), doc$1);
    }

    public static final /* synthetic */ void $anonfun$finishDocumenter$1(RepositoryStateStore $this, DocumenterToken token$1, ProjectDoc doc) {
        ((RepositoryDocumenterToken)token$1).parent().foreach((Function1 & Serializable & scala.Serializable)parent -> {
            $this.withRepository((Function1 & Serializable & scala.Serializable)repository -> {
                RepositoryStateStore.$anonfun$finishDocumenter$3($this, parent, doc$1, repository);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public RepositoryStateStore() {
        Logging.$init$((Logging)this);
        this.logFilters = LogFilter$.MODULE$.filters();
        this.tablesCreated = false;
    }

    public static class RepositoryDocumenterToken
    extends DocumenterToken
    implements Product,
    scala.Serializable {
        private final Option<RepositoryJobToken> parent;

        public Option<RepositoryJobToken> parent() {
            return this.parent;
        }

        public RepositoryDocumenterToken copy(Option<RepositoryJobToken> parent) {
            return new RepositoryDocumenterToken(parent);
        }

        public Option<RepositoryJobToken> copy$default$1() {
            return this.parent();
        }

        public String productPrefix() {
            return "RepositoryDocumenterToken";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.parent();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RepositoryDocumenterToken;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RepositoryDocumenterToken)) return false;
            boolean bl = true;
            if (!bl) return false;
            RepositoryDocumenterToken repositoryDocumenterToken = (RepositoryDocumenterToken)((Object)x$1);
            Option<RepositoryJobToken> option = this.parent();
            Option<RepositoryJobToken> option2 = repositoryDocumenterToken.parent();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!repositoryDocumenterToken.canEqual((Object)this)) return false;
            return true;
        }

        public RepositoryDocumenterToken(Option<RepositoryJobToken> parent) {
            this.parent = parent;
            Product.$init$((Product)this);
        }
    }

    public static class RepositoryJobToken
    extends JobToken
    implements Product,
    scala.Serializable {
        private final JobState run;
        private final GraphBuilder graph;

        public JobState run() {
            return this.run;
        }

        public GraphBuilder graph() {
            return this.graph;
        }

        public RepositoryJobToken copy(JobState run, GraphBuilder graph) {
            return new RepositoryJobToken(run, graph);
        }

        public JobState copy$default$1() {
            return this.run();
        }

        public GraphBuilder copy$default$2() {
            return this.graph();
        }

        public String productPrefix() {
            return "RepositoryJobToken";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.run();
                }
                case 1: {
                    return this.graph();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RepositoryJobToken;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RepositoryJobToken)) return false;
            boolean bl = true;
            if (!bl) return false;
            RepositoryJobToken repositoryJobToken = (RepositoryJobToken)((Object)x$1);
            JobState jobState = this.run();
            JobState jobState2 = repositoryJobToken.run();
            if (jobState == null) {
                if (jobState2 != null) {
                    return false;
                }
            } else if (!jobState.equals(jobState2)) return false;
            GraphBuilder graphBuilder = this.graph();
            GraphBuilder graphBuilder2 = repositoryJobToken.graph();
            if (graphBuilder == null) {
                if (graphBuilder2 != null) {
                    return false;
                }
            } else if (!graphBuilder.equals(graphBuilder2)) return false;
            if (!repositoryJobToken.canEqual((Object)this)) return false;
            return true;
        }

        public RepositoryJobToken(JobState run, GraphBuilder graph) {
            this.run = run;
            this.graph = graph;
            Product.$init$((Product)this);
        }
    }

    public static class RepositoryTargetToken
    extends TargetToken
    implements Product,
    scala.Serializable {
        private final TargetState run;
        private final Option<RepositoryJobToken> parent;

        public TargetState run() {
            return this.run;
        }

        public Option<RepositoryJobToken> parent() {
            return this.parent;
        }

        public RepositoryTargetToken copy(TargetState run, Option<RepositoryJobToken> parent) {
            return new RepositoryTargetToken(run, parent);
        }

        public TargetState copy$default$1() {
            return this.run();
        }

        public Option<RepositoryJobToken> copy$default$2() {
            return this.parent();
        }

        public String productPrefix() {
            return "RepositoryTargetToken";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.run();
                }
                case 1: {
                    return this.parent();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RepositoryTargetToken;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RepositoryTargetToken)) return false;
            boolean bl = true;
            if (!bl) return false;
            RepositoryTargetToken repositoryTargetToken = (RepositoryTargetToken)((Object)x$1);
            TargetState targetState = this.run();
            TargetState targetState2 = repositoryTargetToken.run();
            if (targetState == null) {
                if (targetState2 != null) {
                    return false;
                }
            } else if (!targetState.equals(targetState2)) return false;
            Option<RepositoryJobToken> option = this.parent();
            Option<RepositoryJobToken> option2 = repositoryTargetToken.parent();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!repositoryTargetToken.canEqual((Object)this)) return false;
            return true;
        }

        public RepositoryTargetToken(TargetState run, Option<RepositoryJobToken> parent) {
            this.run = run;
            this.parent = parent;
            Product.$init$((Product)this);
        }
    }
}

