/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;

public class Tag {
    private final int _tagType;
    @NotNull
    private final Directory _directory;

    public Tag(int tagType, @NotNull Directory directory) {
        this._tagType = tagType;
        this._directory = directory;
    }

    public int getTagType() {
        return this._tagType;
    }

    @NotNull
    public String getTagTypeHex() {
        String hex = Integer.toHexString(this._tagType);
        while (hex.length() < 4) {
            hex = "0" + hex;
        }
        return "0x" + hex;
    }

    @Nullable
    public String getDescription() {
        return this._directory.getDescription(this._tagType);
    }

    @NotNull
    public String hasTagName() {
        return this._directory.getTagName(this._tagType);
    }

    @NotNull
    public String getTagName() {
        return this._directory.getTagName(this._tagType);
    }

    @NotNull
    public String getDirectoryName() {
        return this._directory.getName();
    }

    @NotNull
    public String toString() {
        String description = this.getDescription();
        if (description == null) {
            description = this._directory.getString(this.getTagType()) + " (unable to formulate description)";
        }
        return "[" + this._directory.getName() + "] " + this.getTagName() + " - " + description;
    }
}

