/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jfif;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.jfif.JfifDirectory;
import java.io.IOException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JfifReader
implements JpegSegmentMetadataReader,
MetadataReader {
    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APP0);
    }

    @Override
    public boolean canProcess(@NotNull byte[] segmentBytes, @NotNull JpegSegmentType segmentType) {
        return segmentBytes.length > 3 && "JFIF".equals(new String(segmentBytes, 0, 4));
    }

    @Override
    public void extract(@NotNull byte[] segmentBytes, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        this.extract(new ByteArrayReader(segmentBytes), metadata);
    }

    @Override
    public void extract(@NotNull RandomAccessReader reader, @NotNull Metadata metadata) {
        JfifDirectory directory = metadata.getOrCreateDirectory(JfifDirectory.class);
        try {
            int ver = reader.getUInt16(5);
            directory.setInt(5, ver);
            short units = reader.getUInt8(7);
            directory.setInt(7, units);
            int height = reader.getUInt16(8);
            directory.setInt(8, height);
            int width = reader.getUInt16(10);
            directory.setInt(10, width);
        }
        catch (IOException me) {
            directory.addError(me.getMessage());
        }
    }
}

