/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.photoshop.PhotoshopDirectory;
import java.io.IOException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotoshopReader
implements JpegSegmentMetadataReader,
MetadataReader {
    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Arrays.asList(JpegSegmentType.APPD);
    }

    @Override
    public boolean canProcess(@NotNull byte[] segmentBytes, @NotNull JpegSegmentType segmentType) {
        return segmentBytes.length > 12 && "Photoshop 3.0".equals(new String(segmentBytes, 0, 13));
    }

    @Override
    public void extract(@NotNull byte[] segmentBytes, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        this.extract(new ByteArrayReader(segmentBytes), metadata);
    }

    @Override
    public void extract(@NotNull RandomAccessReader reader, @NotNull Metadata metadata) {
        long length;
        int pos;
        PhotoshopDirectory directory = metadata.getOrCreateDirectory(PhotoshopDirectory.class);
        try {
            pos = reader.getString(0, 13).equals("Photoshop 3.0") ? 14 : 0;
        }
        catch (IOException e) {
            directory.addError("Unable to read header");
            return;
        }
        try {
            length = reader.getLength();
        }
        catch (IOException e) {
            directory.addError("Unable to read Photoshop data: " + e.getMessage());
            return;
        }
        while ((long)pos < length) {
            try {
                int tagType = reader.getUInt16(pos += 4);
                int descriptionLength = reader.getUInt16(pos += 2);
                if (descriptionLength < 0 || (long)(descriptionLength + (pos += 2)) > length) {
                    return;
                }
                if ((pos += descriptionLength) % 2 != 0) {
                    ++pos;
                }
                int byteCount = reader.getInt32(pos);
                byte[] tagBytes = reader.getBytes(pos += 4, byteCount);
                if ((pos += byteCount) % 2 != 0) {
                    ++pos;
                }
                directory.setByteArray(tagType, tagBytes);
                if (tagType == 1028) {
                    new IptcReader().extract(new SequentialByteArrayReader(tagBytes), metadata, tagBytes.length);
                }
                if (tagType < 4000 || tagType > 4999) continue;
                PhotoshopDirectory._tagNameMap.put(tagType, String.format("Plug-in %d Data", tagType - 4000 + 1));
            }
            catch (IOException ex) {
                directory.addError(ex.getMessage());
                return;
            }
        }
    }
}

