/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.photoshop.PhotoshopDirectory;
import com.drew.metadata.xmp.XmpReader;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotoshopReader
implements JpegSegmentMetadataReader {
    @NotNull
    private static final String JPEG_SEGMENT_PREAMBLE = "Photoshop 3.0";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.APPD);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> segments, @NotNull Metadata metadata, @NotNull JpegSegmentType segmentType) {
        int preambleLength = JPEG_SEGMENT_PREAMBLE.length();
        for (byte[] segmentBytes : segments) {
            if (segmentBytes.length < preambleLength + 1 || !JPEG_SEGMENT_PREAMBLE.equals(new String(segmentBytes, 0, preambleLength))) continue;
            this.extract(new SequentialByteArrayReader(segmentBytes, preambleLength + 1), segmentBytes.length - preambleLength - 1, metadata);
        }
    }

    public void extract(@NotNull SequentialReader reader, int length, @NotNull Metadata metadata) {
        PhotoshopDirectory directory = new PhotoshopDirectory();
        metadata.addDirectory(directory);
        int pos = 0;
        while (pos < length) {
            try {
                String signature = reader.getString(4);
                pos += 4;
                int tagType = reader.getUInt16();
                pos += 2;
                short descriptionLength = reader.getUInt8();
                if (descriptionLength < 0 || descriptionLength + ++pos > length) {
                    throw new ImageProcessingException("Invalid string length");
                }
                reader.skip(descriptionLength);
                if ((pos += descriptionLength) % 2 != 0) {
                    reader.skip(1L);
                    ++pos;
                }
                int byteCount = reader.getInt32();
                pos += 4;
                byte[] tagBytes = reader.getBytes(byteCount);
                if ((pos += byteCount) % 2 != 0) {
                    reader.skip(1L);
                    ++pos;
                }
                if (!signature.equals("8BIM")) continue;
                if (tagType == 1028) {
                    new IptcReader().extract(new SequentialByteArrayReader(tagBytes), metadata, tagBytes.length);
                } else if (tagType == 1039) {
                    new IccReader().extract(new ByteArrayReader(tagBytes), metadata);
                } else if (tagType == 1058 || tagType == 1059) {
                    new ExifReader().extract(new ByteArrayReader(tagBytes), metadata);
                } else if (tagType == 1060) {
                    new XmpReader().extract(tagBytes, metadata);
                } else {
                    directory.setByteArray(tagType, tagBytes);
                }
                if (tagType < 4000 || tagType > 4999) continue;
                PhotoshopDirectory._tagNameMap.put(tagType, String.format("Plug-in %d Data", tagType - 4000 + 1));
            }
            catch (Exception ex) {
                directory.addError(ex.getMessage());
                return;
            }
        }
    }
}

