/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.ParsingException;
import java.io.IOException;
import java.math.BigInteger;

public abstract class BigIntegerConverter {
    public static final JsonReader.ReadObject<BigInteger> READER = new JsonReader.ReadObject<BigInteger>(){

        @Nullable
        public BigInteger read(JsonReader reader) throws IOException {
            return reader.wasNull() ? null : BigIntegerConverter.deserialize(reader);
        }
    };
    public static final JsonWriter.WriteObject<BigInteger> WRITER = new JsonWriter.WriteObject<BigInteger>(){

        public void write(JsonWriter writer, @Nullable BigInteger value) {
            BigIntegerConverter.serialize(value, writer);
        }
    };

    private static BigInteger parseNumberGeneric(char[] buf, int len, JsonReader reader) throws ParsingException {
        int end;
        for (end = len; end > 0 && Character.isWhitespace(buf[end - 1]); --end) {
        }
        if (end > reader.maxNumberDigits) {
            throw reader.newParseErrorWith("Too many digits detected in number", len, "", "Too many digits detected in number", (Object)end, "");
        }
        try {
            return new BigInteger(new String(buf, 0, end));
        }
        catch (NumberFormatException nfe) {
            throw reader.newParseErrorAt("Error parsing number", len, (Exception)nfe);
        }
    }

    public static void serialize(@Nullable BigInteger value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            sw.writeAscii(value.toString());
        }
    }

    public static BigInteger deserialize(JsonReader reader) throws IOException {
        if (reader.last() == 34) {
            int len = reader.parseString();
            return BigIntegerConverter.parseNumberGeneric(reader.chars, len, reader);
        }
        int start = reader.scanNumber();
        int end = reader.getCurrentIndex();
        int len = end - start;
        if (len > 18) {
            end = reader.findNonWhitespace(end);
            len = end - start;
            if (end == reader.length()) {
                NumberConverter.NumberInfo info = NumberConverter.readLongNumber((JsonReader)reader, (int)start);
                return BigIntegerConverter.parseNumberGeneric(info.buffer, info.length, reader);
            }
            if (len > 18) {
                return BigIntegerConverter.parseNumberGeneric(reader.prepareBuffer(start, len), len, reader);
            }
        }
        byte[] buf = reader.buffer;
        byte ch = buf[start];
        int i = start;
        long value = 0L;
        if (ch == 45) {
            i = start + 1;
            if (i == end) {
                NumberConverter.numberException((JsonReader)reader, (int)start, (int)end, (String)"Digit not found");
            }
            while (i < end) {
                int ind = buf[i] - 48;
                if (ind < 0 || ind > 9) {
                    if (i > start + 1 && reader.allWhitespace(i, end)) {
                        return BigInteger.valueOf(value);
                    }
                    NumberConverter.numberException((JsonReader)reader, (int)start, (int)end, (String)"Unknown digit", (Object)Character.valueOf((char)ch));
                }
                value = (value << 3) + (value << 1) - (long)ind;
                ++i;
            }
            return BigInteger.valueOf(value);
        }
        if (i == end) {
            NumberConverter.numberException((JsonReader)reader, (int)start, (int)end, (String)"Digit not found");
        }
        while (i < end) {
            int ind = buf[i] - 48;
            if (ind < 0 || ind > 9) {
                if (ch == 43 && i > start + 1 && reader.allWhitespace(i, end)) {
                    return BigInteger.valueOf(value);
                }
                if (ch != 43 && i > start && reader.allWhitespace(i, end)) {
                    return BigInteger.valueOf(value);
                }
                NumberConverter.numberException((JsonReader)reader, (int)start, (int)end, (String)"Unknown digit", (Object)Character.valueOf((char)ch));
            }
            value = (value << 3) + (value << 1) + (long)ind;
            ++i;
        }
        return BigInteger.valueOf(value);
    }
}

