/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.BoolConverter;
import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JavaTimeConverter;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.NumberConverter;
import com.dslplatform.json.SerializationException;
import com.dslplatform.json.StringConverter;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;

public class ResultSetConverter
implements JsonWriter.WriteObject<ResultSet> {
    private final DslJson dslJson;
    private final boolean writeNames;
    private final boolean writeTypes;
    private final ZoneId zone;
    private static byte[] NextRow = "],[".getBytes(StandardCharsets.UTF_8);
    private static byte[] DoubleEnd = "]]".getBytes(StandardCharsets.UTF_8);
    private JsonWriter.WriteObject<BigDecimal> DecimalConverter;

    public ResultSetConverter(DslJson dslJson) {
        this(dslJson, true, true, ZoneId.systemDefault());
    }

    public ResultSetConverter(DslJson dslJson, boolean writeNames, boolean writeTypes, ZoneId zone) {
        this.dslJson = dslJson;
        this.writeNames = writeNames;
        this.writeTypes = writeTypes;
        this.zone = zone;
    }

    public void write(JsonWriter writer, @Nullable ResultSet rs) {
        if (rs == null) {
            writer.writeNull();
        } else {
            try {
                ResultSetMetaData metadata = rs.getMetaData();
                int columns = metadata.getColumnCount();
                if (columns == 0) {
                    throw new ConfigurationException("No columns found in ResultSet");
                }
                Writer[] writers = new Writer[columns];
                for (int i = 0; i < writers.length; ++i) {
                    writers[i] = this.createWriter(metadata, i + 1);
                    Writer wrt = writers[i];
                    if (wrt != null) continue;
                    throw new ConfigurationException("Unable to find Writer for column " + (i + 1) + "(" + metadata.getColumnName(i + 1) + ") of type :" + ResultSetConverter.getColumnType(metadata.getColumnType(i + 1)));
                }
                this.serialize(rs, writer, writers);
            }
            catch (SQLException e) {
                throw new SerializationException((Throwable)e);
            }
        }
    }

    private void serialize(ResultSet rs, JsonWriter buffer, Writer[] writers) throws SQLException {
        int i;
        ResultSetMetaData metadata = rs.getMetaData();
        if (metadata.getColumnCount() != writers.length) {
            throw new ConfigurationException("Result set metadata column count mismatch. Expecting " + metadata.getColumnCount() + " writers");
        }
        buffer.writeByte((byte)91);
        if (this.writeNames) {
            buffer.writeByte((byte)91);
            if (writers.length > 0) {
                buffer.writeString(metadata.getColumnLabel(1));
                for (i = 1; i < writers.length; ++i) {
                    buffer.writeByte((byte)44);
                    buffer.writeString(metadata.getColumnLabel(i + 1));
                }
            }
            buffer.writeByte((byte)93);
        }
        if (this.writeTypes) {
            if (this.writeNames) {
                buffer.writeByte((byte)44);
            }
            buffer.writeByte((byte)91);
            if (writers.length > 0) {
                buffer.writeString(ResultSetConverter.getColumnType(metadata.getColumnType(1)));
                for (i = 1; i < writers.length; ++i) {
                    buffer.writeByte((byte)44);
                    buffer.writeString(ResultSetConverter.getColumnType(metadata.getColumnType(i + 1)));
                }
            }
            buffer.writeByte((byte)93);
        }
        if (rs.next()) {
            if (this.writeNames || this.writeTypes) {
                buffer.writeByte((byte)44);
            }
            buffer.writeByte((byte)91);
            writers[0].write(rs, buffer);
            for (i = 1; i < writers.length; ++i) {
                buffer.writeByte((byte)44);
                writers[i].write(rs, buffer);
            }
        } else {
            buffer.writeByte((byte)93);
            return;
        }
        while (rs.next()) {
            buffer.writeAscii(NextRow);
            writers[0].write(rs, buffer);
            for (i = 1; i < writers.length; ++i) {
                buffer.writeByte((byte)44);
                writers[i].write(rs, buffer);
            }
        }
        buffer.writeAscii(DoubleEnd);
    }

    @Nullable
    public Writer createWriter(ResultSetMetaData metaData, int index) throws SQLException {
        switch (metaData.getColumnType(index)) {
            case 2003: {
                return (rs, buffer) -> {
                    Array value = rs.getArray(index);
                    if (value == null) {
                        buffer.writeNull();
                    } else {
                        try {
                            Object instance = value.getArray();
                            if (instance == null) {
                                buffer.writeNull();
                            } else {
                                Class<?> manifest = instance.getClass();
                                if (!this.dslJson.serialize(buffer, manifest, instance)) {
                                    throw new SerializationException("Unable to serialize result set for column " + index);
                                }
                            }
                        }
                        finally {
                            value.free();
                        }
                    }
                };
            }
            case -5: {
                return (rs, buffer) -> {
                    long value = rs.getLong(index);
                    if (rs.wasNull()) {
                        buffer.writeNull();
                    } else {
                        NumberConverter.serialize((long)value, (JsonWriter)buffer);
                    }
                };
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return (rs, buffer) -> {
                    byte[] value = rs.getBytes(index);
                    if (value == null) {
                        buffer.writeNull();
                    } else {
                        buffer.writeBinary(value);
                    }
                };
            }
            case -7: 
            case 16: {
                return (rs, buffer) -> {
                    boolean value = rs.getBoolean(index);
                    if (rs.wasNull()) {
                        buffer.writeNull();
                    } else {
                        BoolConverter.serialize((boolean)value, (JsonWriter)buffer);
                    }
                };
            }
            case 70: {
                return (rs, buffer) -> {
                    URL url = rs.getURL(index);
                    if (url == null) {
                        buffer.writeNull();
                    } else {
                        buffer.writeString(url.toExternalForm());
                    }
                };
            }
            case 91: {
                return (rs, buffer) -> {
                    Date date = rs.getDate(index);
                    if (date == null) {
                        buffer.writeNull();
                    } else {
                        JavaTimeConverter.serialize(date.toLocalDate(), buffer);
                    }
                };
            }
            case 2: 
            case 3: {
                if (this.DecimalConverter == null) {
                    this.DecimalConverter = this.dslJson.tryFindWriter(BigDecimal.class);
                }
                return (rs, buffer) -> this.DecimalConverter.write(buffer, (Object)rs.getBigDecimal(index));
            }
            case 8: {
                return (rs, buffer) -> {
                    double value = rs.getDouble(index);
                    if (rs.wasNull()) {
                        buffer.writeNull();
                    } else {
                        NumberConverter.serialize((double)value, (JsonWriter)buffer);
                    }
                };
            }
            case 6: 
            case 7: {
                return (rs, buffer) -> {
                    float value = rs.getFloat(index);
                    if (rs.wasNull()) {
                        buffer.writeNull();
                    } else {
                        NumberConverter.serialize((float)value, (JsonWriter)buffer);
                    }
                };
            }
            case -6: 
            case 5: {
                return (rs, buffer) -> {
                    short value = rs.getShort(index);
                    if (rs.wasNull()) {
                        buffer.writeNull();
                    } else {
                        NumberConverter.serialize((int)value, (JsonWriter)buffer);
                    }
                };
            }
            case 4: {
                return (rs, buffer) -> {
                    int value = rs.getInt(index);
                    if (rs.wasNull()) {
                        buffer.writeNull();
                    } else {
                        NumberConverter.serialize((int)value, (JsonWriter)buffer);
                    }
                };
            }
            case 0: {
                return (rs, buffer) -> buffer.writeNull();
            }
            case -16: 
            case -15: 
            case -9: 
            case 2011: {
                return (rs, buffer) -> StringConverter.serializeNullable((String)rs.getNString(index), (JsonWriter)buffer);
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return (rs, buffer) -> StringConverter.serializeNullable((String)rs.getString(index), (JsonWriter)buffer);
            }
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: {
                return (rs, buffer) -> {
                    Object value = rs.getObject(index);
                    buffer.serializeObject(value);
                };
            }
            case 2006: {
                return (rs, buffer) -> {
                    Ref value = rs.getRef(index);
                    if (value == null) {
                        buffer.writeNull();
                    } else {
                        Object instance = value.getObject();
                        if (instance == null) {
                            buffer.writeNull();
                        } else {
                            buffer.serializeObject(instance);
                        }
                    }
                };
            }
            case 2012: {
                return null;
            }
            case -8: {
                return (rs, buffer) -> {
                    RowId value = rs.getRowId(index);
                    if (value == null) {
                        buffer.writeNull();
                    } else {
                        StringConverter.serialize((String)value.toString(), (JsonWriter)buffer);
                    }
                };
            }
            case 2009: {
                return (rs, buffer) -> {
                    SQLXML xml = rs.getSQLXML(index);
                    if (xml == null) {
                        buffer.writeNull();
                    } else {
                        try {
                            StringConverter.serialize((String)xml.getString(), (JsonWriter)buffer);
                        }
                        finally {
                            xml.free();
                        }
                    }
                };
            }
            case 92: {
                return (rs, buffer) -> {
                    Time time = rs.getTime(index);
                    if (time == null) {
                        buffer.writeNull();
                    } else {
                        JavaTimeConverter.serialize(time.toLocalTime(), buffer);
                    }
                };
            }
            case 2013: {
                return (rs, buffer) -> {
                    Time time = rs.getTime(index);
                    if (time == null) {
                        buffer.writeNull();
                    } else {
                        JavaTimeConverter.serialize(OffsetTime.ofInstant(time.toInstant(), this.zone), buffer);
                    }
                };
            }
            case 93: {
                return (rs, buffer) -> {
                    Timestamp timestamp = rs.getTimestamp(index);
                    if (timestamp == null) {
                        buffer.writeNull();
                    } else {
                        JavaTimeConverter.serialize(timestamp.toLocalDateTime(), buffer);
                    }
                };
            }
            case 2014: {
                return (rs, buffer) -> {
                    Timestamp timestamp = rs.getTimestamp(index);
                    if (timestamp == null) {
                        buffer.writeNull();
                    } else {
                        JavaTimeConverter.serialize(OffsetDateTime.ofInstant(timestamp.toInstant(), this.zone), buffer);
                    }
                };
            }
        }
        return (rs, buffer) -> {
            Object value = rs.getObject(index);
            buffer.serializeObject(value);
        };
    }

    public static String getColumnType(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return "Array";
            }
            case -5: {
                return "Long";
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return "Binary";
            }
            case -7: 
            case 16: {
                return "Boolean";
            }
            case 91: {
                return "Date";
            }
            case 2: 
            case 3: {
                return "Decimal";
            }
            case 8: {
                return "Double";
            }
            case 6: 
            case 7: {
                return "Float";
            }
            case -6: 
            case 5: {
                return "Short";
            }
            case 4: {
                return "Int";
            }
            case 0: {
                return "Null";
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return "String";
            }
            case 1111: 
            case 2000: 
            case 2002: {
                return "Unknown";
            }
            case -8: 
            case 2001: 
            case 2006: 
            case 2012: {
                return "Unknown";
            }
            case 70: {
                return "Url";
            }
            case 2009: {
                return "SQL";
            }
            case 92: 
            case 2013: {
                return "Time";
            }
            case 93: 
            case 2014: {
                return "Timestamp";
            }
        }
        return "Unknown";
    }

    public static interface Writer {
        public void write(ResultSet var1, JsonWriter var2) throws SQLException;
    }
}

