/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.processor;

import com.dslplatform.json.CompiledJson;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.processor.Analysis;
import com.dslplatform.json.processor.Context;
import com.dslplatform.json.processor.OptimizedConverter;
import com.dslplatform.json.processor.StructInfo;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;

class EnumTemplate {
    private final Writer code;
    private final Context context;

    EnumTemplate(Context context) {
        this.code = context.code;
        this.context = context;
    }

    private static boolean isAllSimple(StructInfo si) {
        for (String c : si.constants) {
            if (c.matches("\\w+")) continue;
            return false;
        }
        return true;
    }

    void writeName(Writer code, StructInfo target, String readValue, String writerName) throws IOException {
        this.writeName(code, target, readValue, writerName, true);
    }

    private void writeName(Writer code, StructInfo target, String readValue, String writerName, boolean external) throws IOException {
        if (target.enumConstantNameSource != null) {
            String constantNameType = EnumTemplate.extractReturnType(target.enumConstantNameSource);
            StructInfo info = this.context.structs.get(constantNameType);
            OptimizedConverter converter = this.context.inlinedConverters.get(constantNameType);
            String value = readValue + "." + target.enumConstantNameSource;
            if (info != null && info.converter != null) {
                info.converter.write(code);
                code.append(".write(writer, ").append(value).append(");\n");
            } else if (converter != null) {
                code.append(converter.nonNullableEncoder("writer", value)).append(";\n");
            } else {
                code.append(writerName).append(".write(writer, ").append(external ? readValue : value).append(");\n");
            }
        } else if (EnumTemplate.isAllSimple(target)) {
            code.append("{ writer.writeByte((byte)'\"'); writer.writeAscii(").append(readValue).append(".name()); writer.writeByte((byte)'\"'); }\n");
        } else {
            code.append("writer.writeString(value.name());\n");
        }
    }

    boolean isStatic(StructInfo si) {
        if (si.enumConstantNameSource == null) {
            return true;
        }
        String constantNameType = EnumTemplate.extractReturnType(si.enumConstantNameSource);
        if (constantNameType == null) {
            return true;
        }
        StructInfo info = this.context.structs.get(constantNameType);
        return info != null && info.converter != null || this.context.inlinedConverters.get(constantNameType) != null;
    }

    void create(StructInfo si, String className) throws IOException {
        OptimizedConverter optimizedConverter;
        this.code.append("\tpublic final static class EnumConverter implements com.dslplatform.json.JsonWriter.WriteObject<");
        this.code.append(className);
        this.code.append(">, com.dslplatform.json.JsonReader.ReadObject<").append(className).append("> {\n");
        String constantNameType = EnumTemplate.extractReturnType(si.enumConstantNameSource);
        StructInfo info = constantNameType != null ? this.context.structs.get(constantNameType) : null;
        OptimizedConverter optimizedConverter2 = optimizedConverter = constantNameType != null ? this.context.inlinedConverters.get(constantNameType) : null;
        if (constantNameType != null) {
            this.code.append("\t\tprivate static final java.util.Map<").append(constantNameType).append(", ").append(className).append("> values;\n");
            this.code.append("\t\tstatic {\n");
            this.code.append("\t\t\tvalues = new java.util.HashMap<").append(constantNameType).append(", ").append(className).append(">();\n");
            this.code.append("\t\t\tfor(").append(className).append(" value : ").append(className).append(".values()) {\n");
            this.code.append("\t\t\t\tvalues.put(value.").append(si.enumConstantNameSource.toString()).append(", value);\n");
            this.code.append("\t\t\t}\n");
            this.code.append("\t\t}\n");
            if (optimizedConverter == null && (info == null || info.converter == null)) {
                this.code.append("\t\tprivate final com.dslplatform.json.JsonWriter.WriteObject<").append(constantNameType).append("> valueWriter;\n");
                this.code.append("\t\tprivate final com.dslplatform.json.JsonReader.ReadObject<").append(constantNameType).append("> valueReader;\n");
                this.code.append("\t\tpublic EnumConverter(com.dslplatform.json.DslJson<Object> __dsljson) {\n");
                this.code.append("\t\t\tthis.valueWriter = __dsljson.tryFindWriter(").append(Context.typeOrClass(constantNameType, constantNameType)).append(");\n");
                this.code.append("\t\t\tif (this.valueWriter == null) throw new com.dslplatform.json.SerializationException(\"Unable to find writer for ").append(constantNameType).append("\");\n");
                this.code.append("\t\t\tthis.valueReader = __dsljson.tryFindReader(").append(Context.typeOrClass(constantNameType, constantNameType)).append(");\n");
                this.code.append("\t\t\tif (this.valueReader == null) throw new com.dslplatform.json.SerializationException(\"Unable to find reader for ").append(constantNameType).append("\");\n");
                this.code.append("\t\t}\n");
            }
        }
        this.code.append("\t\tpublic void write(final com.dslplatform.json.JsonWriter writer, final ");
        this.code.append(className).append(" value) {\n");
        this.code.append("\t\t\tif (value == null) writer.writeNull();\n");
        this.code.append("\t\t\telse {\n");
        this.code.append("\t\t\t\t");
        this.writeName(this.code, si, "value", "valueWriter", false);
        this.code.append("\t\t\t}\n");
        this.code.append("\t\t}\n");
        this.code.append("\t\tpublic ").append(className).append(" read(final com.dslplatform.json.JsonReader reader) throws java.io.IOException {\n");
        this.code.append("\t\t\tif (reader.wasNull()) return null;\n");
        if (this.isStatic(si)) {
            this.code.append("\t\t\treturn readStatic(reader);\n");
            this.code.append("\t\t}\n");
            this.code.append("\t\tpublic static ").append(className).append(" readStatic(final com.dslplatform.json.JsonReader reader) throws java.io.IOException {\n");
        }
        if (constantNameType != null) {
            if (info != null && info.converter != null) {
                this.code.append("\t\t\tfinal ").append(constantNameType).append(" input = ");
                info.converter.read(this.code);
                this.code.append(".read(reader);\n");
                this.code.append("\t\t\t").append(className).append(" value = ").append("values.get(input);\n");
            } else if (optimizedConverter != null) {
                this.code.append("\t\t\tfinal ").append(constantNameType).append(" input = ").append(optimizedConverter.nonNullableDecoder()).append("(reader);\n");
                this.code.append("\t\t\t").append(className).append(" value = ").append("values.get(input);\n");
            } else {
                this.code.append("\t\t\tfinal ").append(constantNameType).append(" input = valueReader.read(reader);\n");
                this.code.append("\t\t\t").append(className).append(" value = input == null ? null : ").append("values.get(input);\n");
            }
            this.code.append("\t\t\tif (value == null) {\n");
            if (si.onUnknown == CompiledJson.Behavior.IGNORE) {
                this.code.append("\t\t\t\tvalue = ").append(className).append(".").append((CharSequence)si.constants.get(0)).append(";\n");
            } else {
                this.code.append("\t\t\t\tthrow new java.lang.IllegalArgumentException(\"No enum constant ");
                this.code.append(className).append(" associated with value '\" + input + \"'");
                if (info != null && info.converter != null) {
                    this.code.append(". When using custom objects check that custom hashCode and equals are implemented");
                }
                this.code.append("\");\n");
            }
            this.code.append("\t\t\t}\n");
            this.code.append("\t\t\treturn value;\n");
        } else {
            HashSet<Integer> hashCodes = new HashSet<Integer>();
            for (String c : si.constants) {
                hashCodes.add(StructInfo.calcHash((String)c));
            }
            if (hashCodes.size() == si.constants.size()) {
                this.code.append("\t\t\tswitch (reader.calcHash()) {\n");
                for (String c : si.constants) {
                    int hash = StructInfo.calcHash((String)c);
                    this.code.append("\t\t\t\tcase ").append(Integer.toString(hash)).append(":\n");
                    this.code.append("\t\t\t\t\treturn ").append(className).append(".").append(c).append(";\n");
                }
                this.code.append("\t\t\t\tdefault:\n");
                if (si.onUnknown == CompiledJson.Behavior.IGNORE) {
                    this.code.append("\t\t\t\t\treturn ").append(className).append(".").append((CharSequence)si.constants.get(0)).append(";\n");
                } else {
                    this.code.append("\t\t\t\t\treturn ").append(className).append(".valueOf(reader.getLastName());\n");
                }
                this.code.append("\t\t\t}\n");
            } else {
                this.code.append("\t\t\treturn ").append(className).append(".valueOf(reader.getLastName());\n");
            }
        }
        this.code.append("\t\t}\n");
        this.code.append("\t}\n");
    }

    @Nullable
    private static String extractReturnType(@Nullable Element element) {
        if (element == null) {
            return null;
        }
        switch (element.getKind()) {
            case FIELD: {
                return Analysis.objectName((String)element.asType().toString());
            }
            case METHOD: {
                return Analysis.objectName((String)((ExecutableElement)element).getReturnType().toString());
            }
        }
        return null;
    }
}

