/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.ObjectConverter;
import com.dslplatform.json.runtime.ArrayDecoder;
import com.dslplatform.json.runtime.ArrayEncoder;
import com.dslplatform.json.runtime.ExplicitDescription;
import com.dslplatform.json.runtime.Settings;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class ArrayAnalyzer {
    public static final DslJson.ConverterFactory<ArrayDecoder> READER = new DslJson.ConverterFactory<ArrayDecoder>(){

        @Nullable
        public ArrayDecoder tryCreate(Type manifest, DslJson dslJson) {
            Class array;
            if (manifest instanceof Class && (array = (Class)manifest).isArray()) {
                return ArrayAnalyzer.analyzeDecoder(manifest, array.getComponentType(), dslJson);
            }
            if (manifest instanceof GenericArrayType) {
                GenericArrayType gat = (GenericArrayType)manifest;
                return ArrayAnalyzer.analyzeDecoder(manifest, gat.getGenericComponentType(), dslJson);
            }
            return null;
        }
    };
    public static final DslJson.ConverterFactory<ArrayEncoder> WRITER = new DslJson.ConverterFactory<ArrayEncoder>(){

        @Nullable
        public ArrayEncoder tryCreate(Type manifest, DslJson dslJson) {
            Class array;
            if (manifest instanceof Class && (array = (Class)manifest).isArray()) {
                return ArrayAnalyzer.analyzeEncoder(manifest, array.getComponentType(), dslJson);
            }
            if (manifest instanceof GenericArrayType) {
                GenericArrayType gat = (GenericArrayType)manifest;
                return ArrayAnalyzer.analyzeEncoder(manifest, gat.getGenericComponentType(), dslJson);
            }
            return null;
        }
    };

    @Nullable
    private static Class<?> checkSignature(Type element) {
        Class raw;
        if (element instanceof Class) {
            raw = (Class)element;
        } else if (element instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)element;
            raw = (Class)pt.getRawType();
        } else {
            return null;
        }
        if (raw.isPrimitive()) {
            return null;
        }
        return raw;
    }

    @Nullable
    private static <T> ArrayDecoder<T> analyzeDecoder(Type manifest, Type element, DslJson json) {
        Class<?> raw = ArrayAnalyzer.checkSignature(element);
        if (raw == null) {
            return null;
        }
        JsonReader.ReadObject reader = json.tryFindReader(element);
        if (reader == null) {
            return null;
        }
        ArrayDecoder<Object> decoder = new ArrayDecoder<Object>((Object[])Array.newInstance(raw, 0), reader);
        json.registerReader(manifest, decoder);
        return decoder;
    }

    @Nullable
    private static <T> ArrayEncoder<T> analyzeEncoder(Type manifest, Type element, DslJson json) {
        JsonWriter.WriteObject writer;
        Class<?> raw = ArrayAnalyzer.checkSignature(element);
        if (raw == null) {
            return null;
        }
        JsonWriter.WriteObject writeObject = writer = Object.class == element ? null : json.tryFindWriter(element);
        if (Object.class != element && writer == null) {
            return null;
        }
        JsonWriter.WriteObject elementWriter = Settings.isKnownType(element) || writer instanceof ExplicitDescription ? writer : null;
        ArrayEncoder encoder = new ArrayEncoder(json, elementWriter);
        json.registerWriter(manifest, encoder);
        return encoder;
    }

    public static class Runtime {
        public static final JsonReader.ReadObject<Object[]> JSON_READER = new JsonReader.ReadObject<Object[]>(){

            public Object[] read(JsonReader reader) throws IOException {
                if (reader.wasNull()) {
                    return null;
                }
                return ObjectConverter.deserializeList((JsonReader)reader).toArray();
            }
        };
        public static final JsonWriter.WriteObject<Object[]> JSON_WRITER = new JsonWriter.WriteObject<Object[]>(){

            public void write(JsonWriter writer, @Nullable Object[] value) {
                if (value == null) {
                    writer.writeNull();
                } else if (value.length == 0) {
                    writer.writeAscii("[]");
                } else {
                    writer.writeByte((byte)91);
                    writer.serializeObject(value[0]);
                    for (int i = 1; i < value.length; ++i) {
                        writer.writeByte((byte)44);
                        writer.serializeObject(value[i]);
                    }
                    writer.writeByte((byte)93);
                }
            }
        };
    }
}

