/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.DecodePropertyInfo;
import java.io.IOException;

public final class EnumDescription<T extends Enum<T>>
implements JsonWriter.WriteObject<T>,
JsonReader.ReadObject<T> {
    private final Class<T> manifest;
    private final DecodePropertyInfo<T>[] decoders;

    public EnumDescription(Class<T> manifest, T[] values) {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("values can't be null");
        }
        this.manifest = manifest;
        DecodePropertyInfo[] tmp = new DecodePropertyInfo[values.length];
        for (int i = 0; i < values.length; ++i) {
            T value = values[i];
            tmp[i] = new DecodePropertyInfo<T>(((Enum)value).name(), false, false, i, false, value);
        }
        this.decoders = DecodePropertyInfo.prepare(tmp, tmp.length);
    }

    public void write(JsonWriter writer, @Nullable T value) {
        if (value == null) {
            writer.writeNull();
        } else {
            writer.writeString(((Enum)value).name());
        }
    }

    @Nullable
    public T read(JsonReader reader) throws IOException {
        if (reader.wasNull()) {
            return null;
        }
        int hash = reader.calcHash();
        for (DecodePropertyInfo<T> ri : this.decoders) {
            if (hash != ri.hash || ri.exactName && !reader.wasLastName(ri.nameBytes)) continue;
            return (T)((Enum)ri.value);
        }
        return Enum.valueOf(this.manifest, reader.getLastName());
    }
}

