/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.OptionalDecoder;
import com.dslplatform.json.runtime.OptionalEncoder;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

public abstract class OptionalAnalyzer {
    public static final DslJson.ConverterFactory<OptionalDecoder> READER = new DslJson.ConverterFactory<OptionalDecoder>(){

        @Nullable
        public OptionalDecoder tryCreate(Type manifest, DslJson dslJson) {
            ParameterizedType pt;
            if (manifest instanceof ParameterizedType && (pt = (ParameterizedType)manifest).getActualTypeArguments().length == 1) {
                return OptionalAnalyzer.analyzeDecoding(manifest, pt.getActualTypeArguments()[0], (Class)pt.getRawType(), dslJson);
            }
            if (manifest == Optional.class) {
                return OptionalAnalyzer.analyzeDecoding(manifest, Object.class, Optional.class, dslJson);
            }
            return null;
        }
    };
    public static final DslJson.ConverterFactory<OptionalEncoder> WRITER = new DslJson.ConverterFactory<OptionalEncoder>(){

        @Nullable
        public OptionalEncoder tryCreate(Type manifest, DslJson dslJson) {
            ParameterizedType pt;
            if (manifest instanceof ParameterizedType && (pt = (ParameterizedType)manifest).getActualTypeArguments().length == 1) {
                return OptionalAnalyzer.analyzeEncoding(manifest, pt.getActualTypeArguments()[0], (Class)pt.getRawType(), dslJson);
            }
            if (manifest == Optional.class) {
                return OptionalAnalyzer.analyzeEncoding(manifest, Object.class, Optional.class, dslJson);
            }
            return null;
        }
    };

    @Nullable
    private static OptionalDecoder analyzeDecoding(Type manifest, Type content, Class<?> raw, DslJson json) {
        if (raw != Optional.class) {
            return null;
        }
        if (content == Optional.class) {
            OptionalDecoder nested = OptionalAnalyzer.analyzeDecoding(content, Object.class, Optional.class, json);
            OptionalDecoder outer = new OptionalDecoder(nested);
            json.registerReader(manifest, outer);
            return outer;
        }
        JsonReader.ReadObject reader = json.tryFindReader(content);
        if (reader == null) {
            return null;
        }
        OptionalDecoder decoder = new OptionalDecoder(reader);
        json.registerReader(manifest, decoder);
        return decoder;
    }

    @Nullable
    private static OptionalEncoder analyzeEncoding(Type manifest, Type content, Class<?> raw, DslJson json) {
        JsonWriter.WriteObject writer;
        if (raw != Optional.class) {
            return null;
        }
        if (content == Optional.class) {
            OptionalEncoder nested = OptionalAnalyzer.analyzeEncoding(content, Object.class, Optional.class, json);
            json.registerWriter(manifest, (JsonWriter.WriteObject)nested);
            return nested;
        }
        JsonWriter.WriteObject writeObject = writer = Object.class == content ? null : json.tryFindWriter(content);
        if (Object.class != content && writer == null) {
            return null;
        }
        OptionalEncoder encoder = new OptionalEncoder(json, Object.class == content ? null : writer);
        json.registerWriter(manifest, encoder);
        return encoder;
    }
}

