/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.Configuration;
import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.ConfigureJava8;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.ObjectConverter;
import com.dslplatform.json.runtime.ArrayAnalyzer;
import com.dslplatform.json.runtime.AttributeArrayEncoder;
import com.dslplatform.json.runtime.AttributeDecoder;
import com.dslplatform.json.runtime.AttributeObjectAlwaysEncoder;
import com.dslplatform.json.runtime.AttributeObjectNonDefaultEncoder;
import com.dslplatform.json.runtime.CollectionAnalyzer;
import com.dslplatform.json.runtime.DecodePropertyInfo;
import com.dslplatform.json.runtime.EnumAnalyzer;
import com.dslplatform.json.runtime.ImmutableAnalyzer;
import com.dslplatform.json.runtime.LazyAttributeArrayEncoder;
import com.dslplatform.json.runtime.LazyAttributeDecoder;
import com.dslplatform.json.runtime.LazyAttributeObjectEncoder;
import com.dslplatform.json.runtime.MapAnalyzer;
import com.dslplatform.json.runtime.MixinAnalyzer;
import com.dslplatform.json.runtime.ObjectAnalyzer;
import java.io.IOException;
import java.lang.reflect.Type;

public abstract class Settings {
    public static final DslJson.ConverterFactory<JsonReader.ReadObject> UNKNOWN_READER = new DslJson.ConverterFactory<JsonReader.ReadObject>(){
        private final JsonReader.ReadObject READER = new JsonReader.ReadObject(){

            public Object read(JsonReader reader) throws IOException {
                return ObjectConverter.deserializeObject((JsonReader)reader);
            }
        };

        @Nullable
        public JsonReader.ReadObject tryCreate(Type manifest, DslJson dslJson) {
            return Object.class == manifest ? this.READER : null;
        }
    };
    public static final DslJson.ConverterFactory<JsonWriter.WriteObject> UNKNOWN_WRITER = new DslJson.ConverterFactory<JsonWriter.WriteObject>(){

        @Nullable
        public JsonWriter.WriteObject tryCreate(Type manifest, DslJson dslJson) {
            return Object.class == manifest ? new ObjectWriter(dslJson) : null;
        }

        class ObjectWriter
        implements JsonWriter.WriteObject {
            private final DslJson dslJson;

            public ObjectWriter(DslJson dslJson) {
                this.dslJson = dslJson;
            }

            public void write(JsonWriter writer, Object value) {
                if (value == null) {
                    writer.writeNull();
                } else {
                    Class<?> signature = value.getClass();
                    JsonWriter.WriteObject instanceWriter = this.dslJson.tryFindWriter(signature);
                    if (instanceWriter instanceof ObjectWriter || instanceWriter == null) {
                        throw new ConfigurationException("Unable to serialize provided instance");
                    }
                    instanceWriter.write(writer, value);
                }
            }
        }
    };

    static boolean isKnownType(@Nullable Type type) {
        if (type == Object.class) {
            return false;
        }
        if (type instanceof Class) {
            Class manifest = (Class)type;
            if (manifest.isInterface()) {
                return false;
            }
            return (manifest.getModifiers() & 0x400) == 0;
        }
        return type != null;
    }

    public static <T, R> JsonWriter.WriteObject<T> createEncoder(Function<T, R> read, String name, DslJson json, @Nullable Type type) {
        return Settings.createEncoder(read, name, json, type, null);
    }

    public static <T, R> JsonWriter.WriteObject<T> createEncoder(Function<T, R> read, String name, DslJson json, @Nullable Type type, @Nullable JsonWriter.WriteObject<R> customEncoder) {
        JsonWriter.WriteObject encoder;
        if (read == null) {
            throw new IllegalArgumentException("read can't be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        if (json == null) {
            throw new IllegalArgumentException("json can't be null");
        }
        Object object = customEncoder != null ? customEncoder : (encoder = type != null ? json.tryFindWriter(type) : null);
        if (encoder == null || Object.class.equals((Object)type)) {
            return new LazyAttributeObjectEncoder<T, R>(read, name, json, type);
        }
        if (json.omitDefaults) {
            return new AttributeObjectNonDefaultEncoder<T, Object>(read, name, encoder, json.getDefault(type));
        }
        return new AttributeObjectAlwaysEncoder<T, R>(read, name, encoder);
    }

    public static <T, R> JsonWriter.WriteObject<T> createArrayEncoder(Function<T, R> read, DslJson json, @Nullable Type type) {
        JsonWriter.WriteObject encoder;
        if (read == null) {
            throw new IllegalArgumentException("read can't be null");
        }
        if (json == null) {
            throw new IllegalArgumentException("json can't be null");
        }
        JsonWriter.WriteObject writeObject = encoder = type != null ? json.tryFindWriter(type) : null;
        if (encoder == null || Object.class.equals((Object)type)) {
            return new LazyAttributeArrayEncoder<T, R>(read, json, type);
        }
        return new AttributeArrayEncoder<T, R>(read, encoder);
    }

    public static <T, R> JsonWriter.WriteObject<T> createArrayEncoder(Function<T, R> read, JsonWriter.WriteObject<R> encoder) {
        if (read == null) {
            throw new IllegalArgumentException("read can't be null");
        }
        if (encoder == null) {
            throw new IllegalArgumentException("encoder can't be null");
        }
        return new AttributeArrayEncoder<T, R>(read, encoder);
    }

    public static <T, R> DecodePropertyInfo<JsonReader.BindObject<T>> createDecoder(BiConsumer<T, R> write, String name, DslJson json, Class<R> manifest) {
        return Settings.createDecoder(write, name, json, false, false, -1, false, manifest);
    }

    public static <T, R> DecodePropertyInfo<JsonReader.BindObject<T>> createDecoder(BiConsumer<T, R> write, String name, DslJson json, boolean exactNameMatch, boolean isMandatory, int index, boolean nonNull, @Nullable Type type) {
        JsonReader.ReadObject decoder;
        if (write == null) {
            throw new IllegalArgumentException("write can't be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        if (json == null) {
            throw new IllegalArgumentException("json can't be null");
        }
        JsonReader.ReadObject readObject = decoder = type != null ? json.tryFindReader(type) : null;
        if (decoder == null || !Settings.isKnownType(type)) {
            return new DecodePropertyInfo<JsonReader.BindObject<T>>(name, exactNameMatch, isMandatory, index, nonNull, new LazyAttributeDecoder<T, R>(write, json, type));
        }
        return new DecodePropertyInfo<JsonReader.BindObject<T>>(name, exactNameMatch, isMandatory, index, nonNull, new AttributeDecoder<T, R>(write, decoder));
    }

    public static <T, R> DecodePropertyInfo<JsonReader.BindObject<T>> createDecoder(BiConsumer<T, R> write, String name, DslJson json, boolean exactNameMatch, boolean isMandatory, int index, boolean nonNull, JsonReader.ReadObject<R> decoder) {
        if (write == null) {
            throw new IllegalArgumentException("write can't be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        if (json == null) {
            throw new IllegalArgumentException("json can't be null");
        }
        if (decoder == null) {
            throw new IllegalArgumentException("decoder can't be null");
        }
        return new DecodePropertyInfo<JsonReader.BindObject<T>>(name, exactNameMatch, isMandatory, index, nonNull, new AttributeDecoder<T, R>(write, decoder));
    }

    public static <T, R> JsonReader.BindObject<T> createArrayDecoder(BiConsumer<T, R> write, DslJson json, @Nullable Type type) {
        JsonReader.ReadObject decoder;
        if (write == null) {
            throw new IllegalArgumentException("write can't be null");
        }
        if (json == null) {
            throw new IllegalArgumentException("json can't be null");
        }
        JsonReader.ReadObject readObject = decoder = type != null ? json.tryFindReader(type) : null;
        if (decoder == null || !Settings.isKnownType(type)) {
            return new LazyAttributeDecoder<T, R>(write, json, type);
        }
        return new AttributeDecoder<T, R>(write, decoder);
    }

    public static <T, R> JsonReader.BindObject<T> createArrayDecoder(BiConsumer<T, R> write, JsonReader.ReadObject<R> decoder) {
        if (write == null) {
            throw new IllegalArgumentException("write can't be null");
        }
        if (decoder == null) {
            throw new IllegalArgumentException("decoder can't be null");
        }
        return new AttributeDecoder<T, R>(write, decoder);
    }

    public static <T> DslJson.Settings<T> withRuntime() {
        DslJson.Settings<T> settings = Settings.withAnalyzers();
        return settings.with((Configuration)new ConfigureJava8());
    }

    public static <T> DslJson.Settings<T> basicSetup() {
        DslJson.Settings<T> settings = Settings.withAnalyzers();
        return settings.includeServiceLoader();
    }

    public static <T> DslJson.Settings<T> withAnalyzers() {
        return Settings.withAnalyzers(true, true);
    }

    public static <T> DslJson.Settings<T> withAnalyzers(boolean unknownReader, boolean unknownWriter) {
        DslJson.Settings settings = new DslJson.Settings();
        if (unknownReader) {
            settings.resolveReader(UNKNOWN_READER);
        }
        settings.resolveReader(CollectionAnalyzer.READER).resolveWriter(CollectionAnalyzer.WRITER).resolveReader(ArrayAnalyzer.READER).resolveWriter(ArrayAnalyzer.WRITER).resolveReader(MapAnalyzer.READER).resolveWriter(MapAnalyzer.WRITER).resolveWriter(EnumAnalyzer.CONVERTER).resolveReader(EnumAnalyzer.CONVERTER).resolveWriter(ImmutableAnalyzer.CONVERTER).resolveReader(ImmutableAnalyzer.CONVERTER).resolveWriter(ObjectAnalyzer.CONVERTER).resolveBinder(ObjectAnalyzer.CONVERTER).resolveReader(ObjectAnalyzer.CONVERTER).resolveWriter(MixinAnalyzer.WRITER);
        if (unknownWriter) {
            settings.resolveWriter(UNKNOWN_WRITER);
        }
        return settings;
    }

    public static interface BiConsumer<T, U> {
        public void accept(T var1, @Nullable U var2);
    }

    public static interface Function<TIn, TOut> {
        @Nullable
        public TOut apply(@Nullable TIn var1);
    }
}

