/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.impl;

import com.easy.query.core.expression.builder.AsSelector;
import com.easy.query.core.expression.builder.GroupSelector;
import com.easy.query.core.expression.builder.OnlySelector;
import com.easy.query.core.expression.builder.Selector;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.proxy.SQLSelectAsExpression;
import com.easy.query.core.proxy.TablePropColumn;
import com.easy.query.core.proxy.core.EntitySQLContext;

public class SQLSelectAsEntryImpl
implements SQLSelectAsExpression {
    private final EntitySQLContext entitySQLContext;
    private final TableAvailable table;
    private final String property;
    private final String alias;

    public SQLSelectAsEntryImpl(EntitySQLContext entitySQLContext, TableAvailable table, String property) {
        this(entitySQLContext, table, property, null);
    }

    public SQLSelectAsEntryImpl(EntitySQLContext entitySQLContext, TableAvailable table, String property, String alias) {
        this.entitySQLContext = entitySQLContext;
        this.table = table;
        this.property = property;
        this.alias = alias;
    }

    @Override
    public void accept(GroupSelector s) {
        s.column(this.table, this.property);
    }

    @Override
    public void accept(AsSelector s) {
        if (this.alias == null) {
            s.column(this.table, this.property);
        } else {
            s.columnAs(this.table, this.property, this.alias);
        }
    }

    @Override
    public void accept(Selector s) {
        s.column(this.table, this.property);
    }

    @Override
    public void accept(OnlySelector s) {
        s.column(this.table, this.property);
    }

    @Override
    public String getValue() {
        return this.property;
    }

    @Override
    public SQLSelectAsExpression as(TablePropColumn propColumn) {
        return this.as(propColumn.getValue());
    }

    @Override
    public SQLSelectAsExpression as(String propertyAlias) {
        return new SQLSelectAsEntryImpl(this.entitySQLContext, this.table, this.property, propertyAlias);
    }

    public TableAvailable getTable() {
        return this.table;
    }

    @Override
    public EntitySQLContext getEntitySQLContext() {
        return this.entitySQLContext;
    }
}

