/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.sql;

import com.easy.query.api.proxy.base.MapTypeProxy;
import com.easy.query.api.proxy.entity.select.EntityQueryable;
import com.easy.query.api.proxy.entity.select.impl.EasyEntityQueryable;
import com.easy.query.core.basic.api.select.ClientQueryable;
import com.easy.query.core.basic.jdbc.executor.ResultColumnMetadata;
import com.easy.query.core.basic.jdbc.executor.impl.def.EntityResultColumnMetadata;
import com.easy.query.core.basic.jdbc.executor.impl.def.TypeResultColumnMetadata;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.proxy.SQLColumn;
import com.easy.query.core.proxy.SQLSelectAsExpression;
import com.easy.query.core.proxy.SQLSelectExpression;
import com.easy.query.core.proxy.core.FlatEntitySQLContext;
import com.easy.query.core.proxy.core.draft.proxy.DraftProxy;
import com.easy.query.core.proxy.partition.proxy.PartitionProxy;
import com.easy.query.core.proxy.sql.Draft;
import com.easy.query.core.proxy.sql.SQLPartition;
import com.easy.query.core.util.EasyArrayUtil;
import java.util.Objects;

public class Select {
    public static Draft DRAFT = new Draft();
    public static SQLPartition PARTITION = new SQLPartition();

    public static SQLSelectExpression of(boolean condition, SQLSelectExpression ... selects) {
        if (condition) {
            return Select.of(selects);
        }
        return SQLSelectExpression.empty;
    }

    public static SQLSelectExpression of(SQLSelectExpression ... selects) {
        if (EasyArrayUtil.isNotEmpty((Object[])selects)) {
            SQLSelectExpression firstSQLSelectAs = selects[0];
            for (int i = 1; i < selects.length; ++i) {
                firstSQLSelectAs = firstSQLSelectAs._concat(selects[i]);
            }
            return firstSQLSelectAs;
        }
        return SQLSelectExpression.empty;
    }

    public static SQLSelectAsExpression of(SQLSelectAsExpression ... selectAss) {
        if (EasyArrayUtil.isNotEmpty((Object[])selectAss)) {
            SQLSelectAsExpression firstSQLSelectAs = selectAss[0];
            for (int i = 1; i < selectAss.length; ++i) {
                firstSQLSelectAs = firstSQLSelectAs._concat(selectAss[i]);
            }
            return firstSQLSelectAs;
        }
        return SQLSelectAsExpression.empty;
    }

    public static <TR, TRProxy> void setDraftPropTypes(ClientQueryable<TR> select, TRProxy trProxy) {
        ExpressionContext expressionContext = select.getSQLEntityExpressionBuilder().getExpressionContext();
        if (trProxy instanceof DraftProxy) {
            DraftProxy draftProxy = (DraftProxy)trProxy;
            expressionContext.setResultPropTypes(draftProxy.getDraftPropTypes());
        } else if (trProxy instanceof MapTypeProxy) {
            MapTypeProxy mapTypeProxy = (MapTypeProxy)trProxy;
            expressionContext.setResultPropTypes((ResultColumnMetadata[])mapTypeProxy._getResultPropTypes().stream().map(x -> new TypeResultColumnMetadata(x)).toArray(ResultColumnMetadata[]::new));
        } else if (trProxy instanceof SQLColumn) {
            EntityMetadata entityMetadata;
            ColumnMetadata columnMetadata;
            SQLColumn sqlColumn = (SQLColumn)trProxy;
            if (sqlColumn.getTable() != null && Objects.equals(sqlColumn.getPropertyType(), Object.class) && (columnMetadata = (entityMetadata = sqlColumn.getTable().getEntityMetadata()).getColumnOrNull(sqlColumn.getValue())) != null) {
                expressionContext.setResultPropTypes((ResultColumnMetadata[])new EntityResultColumnMetadata[]{new EntityResultColumnMetadata(0, entityMetadata, columnMetadata)});
            }
        } else if (expressionContext.getResultPropTypes() != null) {
            expressionContext.setResultPropTypes(null);
        }
    }

    public static <TRProxy extends ProxyEntity<TRProxy, TR>, TR> EntityQueryable<TRProxy, TR> selectProxy(TRProxy resultProxy, ClientQueryable<?> queryable) {
        Objects.requireNonNull(resultProxy, "select null result class");
        if (resultProxy.getEntitySQLContext() instanceof FlatEntitySQLContext) {
            throw new EasyQueryInvalidOperationException("The [flatElement] method is not allowed to be used inside the select function. If you wish to retrieve from the [flatElement] function, please use it within the [toList] function. eg. toList(o->o.users().flatElement()) ");
        }
        QueryRuntimeContext runtimeContext = queryable.getSQLEntityExpressionBuilder().getRuntimeContext();
        SQLSelectAsExpression selectAsExpression = resultProxy.getEntitySQLContext().getSelectAsExpression();
        if (selectAsExpression == null) {
            TableAvailable tableOrNull = resultProxy.getTableOrNull();
            if (tableOrNull == null) {
                ClientQueryable select = queryable.select(resultProxy.getEntityClass());
                Select.setDraftPropTypes(select, resultProxy);
                return new EasyEntityQueryable(resultProxy, select);
            }
            EntityMetadata resultEntityMetadata = Select.getResultProxyEntityMetadata(resultProxy, runtimeContext);
            if (resultProxy instanceof SQLSelectExpression) {
                SQLSelectExpression resultProxySelectExpression = (SQLSelectExpression)((Object)resultProxy);
                ClientQueryable select = queryable.select(resultProxy.getEntityClass(), resultEntityMetadata, columnAsSelector -> resultProxySelectExpression.accept(columnAsSelector.getAsSelector()));
                Select.setDraftPropTypes(select, resultProxy);
                return new EasyEntityQueryable(resultProxy, select);
            }
            ClientQueryable select = queryable.select(resultProxy.getEntityClass(), resultEntityMetadata, columnAsSelector -> columnAsSelector.getAsSelector().columnAll(tableOrNull));
            Select.setDraftPropTypes(select, resultProxy);
            return new EasyEntityQueryable(resultProxy, select);
        }
        EntityMetadata resultEntityMetadata = Select.getResultProxyEntityMetadata(resultProxy, runtimeContext);
        ClientQueryable select = queryable.select(resultProxy.getEntityClass(), resultEntityMetadata, columnAsSelector -> {
            if (resultProxy instanceof PartitionProxy) {
                PartitionProxy resultProxy1 = (PartitionProxy)((Object)resultProxy);
                resultProxy1.accept(columnAsSelector.getAsSelector());
            }
            selectAsExpression.accept(columnAsSelector.getAsSelector());
        });
        Select.setDraftPropTypes(select, resultProxy);
        return new EasyEntityQueryable(resultProxy, select);
    }

    private static <TRProxy extends ProxyEntity<TRProxy, TR>, TR> EntityMetadata getResultProxyEntityMetadata(TRProxy resultProxy, QueryRuntimeContext runtimeContext) {
        EntityMetadata entityMetadata = resultProxy.getEntityMetadata();
        if (entityMetadata != null && entityMetadata.getEntityClass().equals(resultProxy.getEntityClass())) {
            return entityMetadata;
        }
        return runtimeContext.getEntityMetadataManager().getEntityMetadata(resultProxy.getEntityClass());
    }
}

