/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.mailchimp;

import com.ecwid.mailchimp.MailChimpException;
import com.ecwid.mailchimp.MailChimpGsonFactory;
import com.ecwid.mailchimp.MailChimpMethod;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;

public class MailChimpClient {
    private static final Logger log = Logger.getLogger(MailChimpClient.class.getName());
    private final HttpClient http = new DefaultHttpClient();

    private String execute(String url, String request) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Post to " + url + " : " + request);
        }
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new StringEntity(URLEncoder.encode(request, "UTF-8")));
        String response = (String)this.http.execute((HttpUriRequest)post, (ResponseHandler)new BasicResponseHandler());
        if (log.isLoggable(Level.FINE)) {
            log.fine("Response: " + response);
        }
        return response;
    }

    private JsonElement execute(String url, JsonElement request) throws IOException {
        return new JsonParser().parse(this.execute(url, request.toString()));
    }

    public <R> R execute(MailChimpMethod<R> method) throws IOException, MailChimpException {
        JsonElement error;
        Gson gson = MailChimpGsonFactory.createGson();
        JsonElement result = this.execute(this.buildUrl(method), gson.toJsonTree(method));
        if (result.isJsonObject() && (error = result.getAsJsonObject().get("error")) != null) {
            JsonElement code = result.getAsJsonObject().get("code");
            throw new MailChimpException(code.getAsInt(), error.getAsString());
        }
        return (R)gson.fromJson(result, method.getResultType());
    }

    private String buildUrl(MailChimpMethod<?> method) throws UnsupportedEncodingException {
        String apikey = method.apikey;
        if (apikey == null) {
            throw new IllegalArgumentException("apikey is not set");
        }
        int dash = apikey.lastIndexOf(45);
        if (dash <= 0) {
            throw new IllegalArgumentException("Wrong apikey: " + apikey);
        }
        String prefix = apikey.substring(dash + 1);
        StringBuilder sb = new StringBuilder();
        sb.append("https://");
        sb.append(prefix);
        sb.append(".api.mailchimp.com/1.3/?method=");
        sb.append(URLEncoder.encode(method.getMethodName(), "UTF-8"));
        return sb.toString();
    }

    public void close() {
        this.http.getConnectionManager().shutdown();
    }
}

