/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.mailchimp;

import com.ecwid.mailchimp.MailChimpMap;
import com.ecwid.mailchimp.MailChimpObject;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

class MailChimpGsonFactory {
    private static final ExclusionStrategy exclusionStrategy = new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes fa) {
            return !MailChimpObject.class.isAssignableFrom(fa.getDeclaringClass()) || fa.getAnnotation(MailChimpObject.Field.class) == null;
        }

        public boolean shouldSkipClass(Class<?> type) {
            return false;
        }
    };
    private static FieldNamingStrategy fieldNamingStrategy = new FieldNamingStrategy(){

        public String translateName(Field field) {
            String name = field.getAnnotation(MailChimpObject.Field.class).name();
            return name.isEmpty() ? field.getName() : name;
        }
    };
    private static final TypeAdapterFactory mailChimpObjectAdapterFactory = new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (type.getRawType() == MailChimpObject.class) {
                return new TypeAdapter<MailChimpObject>(){

                    public void write(JsonWriter out, MailChimpObject value) throws IOException {
                        if (value == null) {
                            out.nullValue();
                            return;
                        }
                        TypeAdapter typeAdapter = gson.getAdapter(value.getClass());
                        if (typeAdapter.getClass() != ((Object)((Object)this)).getClass()) {
                            assert (value.getClass() != MailChimpObject.class);
                            typeAdapter.write(out, (Object)value);
                        } else {
                            assert (value.getClass() == MailChimpObject.class);
                            out.beginObject();
                            out.endObject();
                        }
                    }

                    public MailChimpObject read(JsonReader in) throws IOException {
                        return (MailChimpObject)gson.getAdapter(MailChimpMap.class).read(in);
                    }
                };
            }
            return null;
        }
    };

    private MailChimpGsonFactory() {
    }

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setExclusionStrategies(new ExclusionStrategy[]{exclusionStrategy});
        builder.setFieldNamingStrategy(fieldNamingStrategy);
        builder.registerTypeAdapterFactory(mailChimpObjectAdapterFactory);
        builder.registerTypeAdapter(Date.class, (Object)new DateTypeAdapter());
        return builder.create();
    }

    private static class DateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private final DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        DateTypeAdapter() {
            this.format.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JsonElement serialize(Date t, Type type, JsonSerializationContext jsc) {
            DateFormat dateFormat = this.format;
            synchronized (dateFormat) {
                return new JsonPrimitive(this.format.format(t));
            }
        }

        public Date deserialize(JsonElement je, Type type, JsonDeserializationContext jdc) throws JsonParseException {
            DateFormat dateFormat = this.format;
            synchronized (dateFormat) {
                try {
                    return this.format.parse(je.getAsString());
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Cannot deserialize date: " + je);
                }
            }
        }
    }
}

