/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.testng.util;

import com.epam.reportportal.service.tree.TestItemTree;
import java.util.Arrays;
import java.util.Optional;
import org.testng.IClass;
import org.testng.ISuite;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.xml.XmlClass;

public class ItemTreeUtils {
    private ItemTreeUtils() {
    }

    public static TestItemTree.ItemTreeKey createKey(ISuite suite) {
        return TestItemTree.ItemTreeKey.of((String)suite.getName());
    }

    public static TestItemTree.ItemTreeKey createKey(ITestContext testContext) {
        return TestItemTree.ItemTreeKey.of((String)testContext.getName());
    }

    public static TestItemTree.ItemTreeKey createKey(XmlClass testClass) {
        return TestItemTree.ItemTreeKey.of((String)testClass.getName());
    }

    public static TestItemTree.ItemTreeKey createKey(IClass testClass) {
        return TestItemTree.ItemTreeKey.of((String)testClass.getName());
    }

    public static TestItemTree.ItemTreeKey createKey(ITestResult testResult) {
        return TestItemTree.ItemTreeKey.of((String)testResult.getName(), (int)Arrays.hashCode(testResult.getParameters()));
    }

    public static Optional<TestItemTree.TestItemLeaf> retrieveLeaf(ISuite suite, TestItemTree testItemTree) {
        return Optional.ofNullable(testItemTree.getTestItems().get(ItemTreeUtils.createKey(suite)));
    }

    public static Optional<TestItemTree.TestItemLeaf> retrieveLeaf(ITestContext testContext, TestItemTree testItemTree) {
        Optional<TestItemTree.TestItemLeaf> suiteLeaf = ItemTreeUtils.retrieveLeaf(testContext.getSuite(), testItemTree);
        return suiteLeaf.map(leaf -> (TestItemTree.TestItemLeaf)leaf.getChildItems().get(ItemTreeUtils.createKey(testContext)));
    }

    public static Optional<TestItemTree.TestItemLeaf> retrieveLeaf(ITestResult testResult, TestItemTree testItemTree) {
        Optional<TestItemTree.TestItemLeaf> testClassLeaf = ItemTreeUtils.retrieveLeaf(testResult.getTestContext(), testResult.getTestClass(), testItemTree);
        return testClassLeaf.map(leaf -> (TestItemTree.TestItemLeaf)leaf.getChildItems().get(ItemTreeUtils.createKey(testResult)));
    }

    private static Optional<TestItemTree.TestItemLeaf> retrieveLeaf(ITestContext testContext, IClass testClass, TestItemTree testItemTree) {
        Optional<TestItemTree.TestItemLeaf> testLeaf = ItemTreeUtils.retrieveLeaf(testContext, testItemTree);
        return testLeaf.map(leaf -> (TestItemTree.TestItemLeaf)leaf.getChildItems().get(ItemTreeUtils.createKey(testClass)));
    }
}

