/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.testng.util.internal;

import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;

public class LimitedSizeConcurrentHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    private final int maxSize;
    private final Queue<K> inputOrder = new ConcurrentLinkedQueue<K>();

    public LimitedSizeConcurrentHashMap(int maximumMapSize) {
        this.maxSize = maximumMapSize;
    }

    @Override
    public V put(@Nonnull K key, @Nonnull V value) {
        K keyToRemove;
        if (this.size() >= this.maxSize && (keyToRemove = this.inputOrder.poll()) != null) {
            this.remove(keyToRemove);
        }
        this.inputOrder.add(key);
        return super.put(key, value);
    }
}

