/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.properties;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.utils.properties.ListenerProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import rp.com.google.common.annotations.VisibleForTesting;
import rp.com.google.common.base.Charsets;
import rp.com.google.common.base.MoreObjects;
import rp.com.google.common.base.Optional;
import rp.com.google.common.base.Supplier;
import rp.com.google.common.base.Suppliers;
import rp.com.google.common.io.Closer;
import rp.com.google.common.io.Resources;

public class PropertiesLoader {
    public static final String INNER_PATH = "reportportal.properties";
    public static final String PATH = "./reportportal.properties";
    private Supplier<Properties> propertiesSupplier;

    public static PropertiesLoader load() {
        return new PropertiesLoader(new Supplier<Properties>(){

            @Override
            public Properties get() {
                try {
                    return PropertiesLoader.loadProperties(PropertiesLoader.INNER_PATH);
                }
                catch (IOException e) {
                    throw new InternalReportPortalClientException("Unable to load properties", e);
                }
            }
        });
    }

    public static PropertiesLoader load(final String resource) {
        return new PropertiesLoader(new Supplier<Properties>(){

            @Override
            public Properties get() {
                try {
                    return PropertiesLoader.loadProperties(resource);
                }
                catch (IOException e) {
                    throw new InternalReportPortalClientException("Unable to load properties", e);
                }
            }
        });
    }

    private PropertiesLoader(Supplier<Properties> propertiesSupplier) {
        this.propertiesSupplier = Suppliers.memoize(propertiesSupplier);
    }

    public String getProperty(String propertyName) {
        return this.propertiesSupplier.get().getProperty(propertyName);
    }

    public String getProperty(ListenerProperty propertyName, String defaultValue) {
        String value = this.propertiesSupplier.get().getProperty(propertyName.getPropertyName());
        return value != null ? value : defaultValue;
    }

    public boolean getPropertyAsBoolean(ListenerProperty propertyName, boolean defaultValue) {
        String value = this.propertiesSupplier.get().getProperty(propertyName.getPropertyName());
        return null != value ? Boolean.valueOf(value) : defaultValue;
    }

    public int getPropertyAsInt(ListenerProperty propertyName, int defaultValue) {
        String value = this.propertiesSupplier.get().getProperty(propertyName.getPropertyName());
        return null != value ? Integer.parseInt(value) : defaultValue;
    }

    public String getProperty(ListenerProperty propertyName) {
        return this.propertiesSupplier.get().getProperty(propertyName.getPropertyName());
    }

    public Properties getProperties() {
        return this.propertiesSupplier.get();
    }

    public void overrideWith(Properties overrides) {
        PropertiesLoader.overrideWith(this.propertiesSupplier.get(), overrides);
    }

    private static Properties loadProperties(String resource) throws IOException {
        Properties props = new Properties();
        Optional<URL> propertyFile = PropertiesLoader.getResource(resource);
        if (propertyFile.isPresent()) {
            props.load(Resources.asCharSource(propertyFile.get(), Charsets.UTF_8).openBufferedStream());
        }
        PropertiesLoader.overrideWith(props, System.getProperties());
        PropertiesLoader.overrideWith(props, System.getenv());
        return props;
    }

    @Deprecated
    private static Properties loadFromFile() throws IOException {
        Properties props = new Properties();
        File propertiesFile = new File(PATH);
        Closer closer = Closer.create();
        try {
            InputStream is = propertiesFile.exists() ? new FileInputStream(propertiesFile) : PropertiesLoader.class.getResourceAsStream(INNER_PATH);
            closer.register(is);
            InputStreamReader isr = new InputStreamReader(is, Charsets.UTF_8);
            closer.register(isr);
            props.load(isr);
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
        return props;
    }

    public void validate() {
        PropertiesLoader.validateProperties(this.getProperties());
    }

    private static void validateProperties(Properties properties) {
        for (ListenerProperty listenerProperty : ListenerProperty.values()) {
            if (!listenerProperty.isRequired() || properties.getProperty(listenerProperty.getPropertyName()) != null) continue;
            throw new IllegalArgumentException("Property '" + listenerProperty.getPropertyName() + "' should not be null.");
        }
    }

    @VisibleForTesting
    static void overrideWith(Properties source, Map<String, String> overrides) {
        for (ListenerProperty listenerProperty : ListenerProperty.values()) {
            if (overrides.get(listenerProperty.getPropertyName()) == null) continue;
            source.setProperty(listenerProperty.getPropertyName(), overrides.get(listenerProperty.getPropertyName()));
        }
    }

    @VisibleForTesting
    static void overrideWith(Properties source, Properties overrides) {
        PropertiesLoader.overrideWith(source, (Map<String, String>)overrides);
    }

    private static Optional<URL> getResource(String resourceName) {
        ClassLoader loader = MoreObjects.firstNonNull(Thread.currentThread().getContextClassLoader(), PropertiesLoader.class.getClassLoader());
        return Optional.fromNullable(loader.getResource(resourceName));
    }
}

