/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.listeners.ListenerParameters;
import io.reactivex.CompletableObserver;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionUtils.class);

    public static <T> MaybeObserver<T> logMaybeResults(final String type) {
        return new MaybeObserver<T>(){

            public void onSubscribe(@Nonnull Disposable d) {
            }

            public void onSuccess(@Nonnull T result) {
                LOGGER.debug("{} successfully completed", (Object)type);
            }

            public void onError(@Nonnull Throwable e) {
                LOGGER.error("{} completed with error ", (Object)type, (Object)e);
            }

            public void onComplete() {
                LOGGER.debug("{} completed", (Object)type);
            }
        };
    }

    public static CompletableObserver logCompletableResults(final String type) {
        return new CompletableObserver(){

            public void onSubscribe(@Nonnull Disposable d) {
            }

            public void onError(@Nonnull Throwable e) {
                LOGGER.error("[{}] ReportPortal {} execution error", new Object[]{Thread.currentThread().getId(), type, e});
            }

            public void onComplete() {
                LOGGER.debug("{} completed", (Object)type);
            }
        };
    }

    public static MaybeObserver<String> printLaunch(final @Nonnull ListenerParameters parameters) {
        return new MaybeObserver<String>(){

            public void onSubscribe(@Nonnull Disposable d) {
            }

            public void onSuccess(@Nonnull String result) {
                parameters.getPrintLaunchUuidOutput().println("Report Portal Launch UUID: " + result);
            }

            public void onError(@Nonnull Throwable e) {
            }

            public void onComplete() {
            }
        };
    }
}

