/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para;

import com.erudika.para.cache.Cache;
import com.erudika.para.persistence.DAO;
import com.erudika.para.rest.CustomResourceHandler;
import com.erudika.para.search.Search;
import com.erudika.para.utils.Config;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.util.Modules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Para {
    public static final String LOGO;
    private static final Logger logger;
    private static final List<DestroyListener> destroyListeners;
    private static final List<InitializeListener> initListeners;
    private static final ExecutorService exec;
    private static Injector injector;

    public static void initialize(Module ... modules) {
        if (injector == null) {
            Para.printLogo();
            try {
                logger.info("--- Para.initialize() [{}] ---", (Object)Config.ENVIRONMENT);
                Stage stage = Config.IN_PRODUCTION ? Stage.PRODUCTION : Stage.DEVELOPMENT;
                List<Module> coreModules = Arrays.asList(modules);
                List<Module> externalModules = Para.getExternalModules();
                if (coreModules.isEmpty() && externalModules.isEmpty()) {
                    logger.warn("No implementing modules found. Aborting...");
                    Para.destroy();
                    return;
                }
                injector = !externalModules.isEmpty() ? Guice.createInjector((Stage)stage, (Module[])new Module[]{Modules.override(coreModules).with(externalModules)}) : Guice.createInjector((Stage)stage, coreModules);
                for (InitializeListener initListener : initListeners) {
                    initListener.onInitialize();
                }
            }
            catch (Exception e) {
                logger.error(null, (Throwable)e);
            }
        }
    }

    public static void destroy() {
        try {
            if (injector != null) {
                logger.info("--- Para.destroy() ---");
                injector = null;
                for (DestroyListener destroyListener : destroyListeners) {
                    destroyListener.onDestroy();
                }
            }
            if (!exec.isShutdown()) {
                exec.shutdown();
                exec.awaitTermination(60L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
        }
    }

    public static void injectInto(Object obj) {
        if (obj == null) {
            return;
        }
        if (injector == null) {
            Para.handleNotInitializedError();
        }
        injector.injectMembers(obj);
    }

    public static DAO getDAO() {
        if (injector == null) {
            Para.handleNotInitializedError();
        }
        return (DAO)injector.getInstance(DAO.class);
    }

    public static Search getSearch() {
        if (injector == null) {
            Para.handleNotInitializedError();
        }
        return (Search)injector.getInstance(Search.class);
    }

    public static Cache getCache() {
        if (injector == null) {
            Para.handleNotInitializedError();
        }
        return (Cache)injector.getInstance(Cache.class);
    }

    public static Map<String, String> getConfig() {
        return Config.getConfigMap();
    }

    public static void addInitListener(InitializeListener il) {
        initListeners.add(il);
    }

    public static void addDestroyListener(DestroyListener dl) {
        destroyListeners.add(dl);
    }

    public static ExecutorService getExecutorService() {
        return exec;
    }

    public static void asyncExecute(Runnable runnable) {
        if (runnable != null) {
            try {
                Para.getExecutorService().execute(runnable);
            }
            catch (RejectedExecutionException ex) {
                logger.warn(ex.getMessage());
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    logger.error(null, (Throwable)e);
                }
            }
        }
    }

    public static List<CustomResourceHandler> getCustomResourceHandlers() {
        ServiceLoader<CustomResourceHandler> loader = ServiceLoader.load(CustomResourceHandler.class);
        ArrayList<CustomResourceHandler> externalResources = new ArrayList<CustomResourceHandler>();
        for (CustomResourceHandler handler : loader) {
            if (handler == null) continue;
            Para.injectInto(handler);
            externalResources.add(handler);
        }
        return externalResources;
    }

    private static List<Module> getExternalModules() {
        ServiceLoader<Module> moduleLoader = ServiceLoader.load(Module.class);
        ArrayList<Module> externalModules = new ArrayList<Module>();
        for (Module module : moduleLoader) {
            externalModules.add(module);
        }
        return externalModules;
    }

    private static void handleNotInitializedError() {
        throw new IllegalStateException("Call Para.initialize() first!");
    }

    public static void printLogo() {
        if (Boolean.parseBoolean(Config.getConfigParam("print_logo", "true"))) {
            System.out.print(LOGO);
        }
    }

    static {
        String[] logo = new String[]{"", "      ____  ___ _ ____ ___ _ ", "     / __ \\/ __` / ___/ __` /", "    / /_/ / /_/ / /  / /_/ / ", "   / .___/\\__,_/_/   \\__,_/  ", "  /_/                        ", ""};
        StringBuilder sb = new StringBuilder();
        for (String line : logo) {
            sb.append(line).append("\n");
        }
        LOGO = sb.toString();
        logger = LoggerFactory.getLogger(Para.class);
        destroyListeners = new ArrayList<DestroyListener>();
        initListeners = new ArrayList<InitializeListener>();
        exec = Executors.newFixedThreadPool(Config.EXECUTOR_THREADS);
    }

    public static interface DestroyListener
    extends EventListener {
        public void onDestroy();
    }

    public static interface InitializeListener
    extends EventListener {
        public void onInitialize();
    }
}

