/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core;

import com.erudika.para.Para;
import com.erudika.para.annotations.Locked;
import com.erudika.para.annotations.Stored;
import com.erudika.para.core.CoreUtils;
import com.erudika.para.core.Linker;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.ParaObjectUtils;
import com.erudika.para.core.Votable;
import com.erudika.para.persistence.DAO;
import com.erudika.para.search.Search;
import com.erudika.para.utils.Config;
import com.erudika.para.utils.Pager;
import com.erudika.para.utils.Utils;
import com.erudika.para.validation.Constraint;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.NotBlank;
import org.slf4j.LoggerFactory;

public class App
implements ParaObject {
    public static final String APP_ROLE = "ROLE_APP";
    private static final long serialVersionUID = 1L;
    private static final String prefix = Utils.type(App.class).concat(Config.SEPARATOR);
    @Stored
    @Locked
    @NotBlank
    private String id;
    @Stored
    @Locked
    private Long timestamp;
    @Stored
    @Locked
    private String type;
    @Stored
    @Locked
    private String appid;
    @Stored
    @Locked
    private String parentid;
    @Stored
    @Locked
    private String creatorid;
    @Stored
    private Long updated;
    @Stored
    private String name;
    @Stored
    private List<String> tags;
    @Stored
    private Integer votes;
    @Stored
    @Locked
    private boolean shared = true;
    @Stored
    @Locked
    @NotBlank
    private String secret;
    @Stored
    @Locked
    private Boolean readOnly = false;
    @Stored
    private Map<String, String> datatypes;
    @Stored
    private Map<String, Map<String, Map<String, Map<String, Object>>>> validationConstraints;
    @Stored
    private Boolean active = true;
    @Stored
    private Long deleteOn;
    private transient DAO dao;
    private transient Search search;

    public App() {
        this(null);
    }

    public App(String id) {
        this.setId(id);
        this.setName(this.getName());
    }

    public static final String id(String id) {
        if (StringUtils.startsWith((CharSequence)id, (CharSequence)prefix)) {
            return prefix.concat(Utils.noSpaces(Utils.stripAndTrim(id.replaceAll(prefix, ""), " "), "-"));
        }
        if (id != null) {
            return prefix.concat(Utils.noSpaces(Utils.stripAndTrim(id, " "), "-"));
        }
        return null;
    }

    @Override
    public final void setId(String id) {
        this.id = App.id(id);
    }

    public Map<String, Map<String, Map<String, Map<String, Object>>>> getValidationConstraints() {
        if (this.validationConstraints == null) {
            this.validationConstraints = new HashMap<String, Map<String, Map<String, Map<String, Object>>>>();
        }
        return this.validationConstraints;
    }

    public void setValidationConstraints(Map<String, Map<String, Map<String, Map<String, Object>>>> validationConstraints) {
        this.validationConstraints = validationConstraints;
    }

    public String getAppIdentifier() {
        return this.getId() != null ? this.getId().replaceFirst(prefix, "") : "";
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Long getDeleteOn() {
        return this.deleteOn;
    }

    public void setDeleteOn(Long deleteOn) {
        this.deleteOn = deleteOn;
    }

    @JsonIgnore
    public String getSecret() {
        if (this.secret == null) {
            this.resetSecret();
        }
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Map<String, String> getDatatypes() {
        if (this.datatypes == null) {
            this.datatypes = new DualHashBidiMap();
        }
        return this.datatypes;
    }

    public void setDatatypes(Map<String, String> datatypes) {
        this.datatypes = datatypes;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public boolean addValidationConstraint(String type, String field, Constraint c) {
        if (!StringUtils.isBlank((CharSequence)type) && !StringUtils.isBlank((CharSequence)field) && c != null && !c.getPayload().isEmpty() && Constraint.isValidConstraintName(c.getName())) {
            Map<String, Map<String, Object>> consMap;
            Map<String, Map<String, Map<String, Object>>> fieldMap = this.getValidationConstraints().get(type);
            if (fieldMap != null) {
                consMap = fieldMap.get(field);
                if (consMap == null) {
                    consMap = new HashMap<String, Map<String, Object>>();
                }
            } else {
                fieldMap = new HashMap<String, Map<String, Map<String, Object>>>();
                consMap = new HashMap<String, Map<String, Object>>();
            }
            consMap.put(c.getName(), c.getPayload());
            fieldMap.put(field, consMap);
            this.getValidationConstraints().put(type, fieldMap);
            return true;
        }
        return false;
    }

    public boolean removeValidationConstraint(String type, String field, String constraintName) {
        Map<String, Map<String, Map<String, Object>>> fieldsMap;
        if (!StringUtils.isBlank((CharSequence)type) && !StringUtils.isBlank((CharSequence)field) && constraintName != null && (fieldsMap = this.getValidationConstraints().get(type)) != null && fieldsMap.containsKey(field) && fieldsMap.get(field).containsKey(constraintName)) {
            fieldsMap.get(field).remove(constraintName);
            return true;
        }
        return false;
    }

    public void addDatatype(String pluralDatatype, String datatype) {
        if (this.getDatatypes().size() < Config.MAX_DATATYPES_PER_APP) {
            if (!(StringUtils.isBlank((CharSequence)pluralDatatype) || StringUtils.isBlank((CharSequence)datatype) || this.getDatatypes().containsValue(datatype))) {
                this.getDatatypes().putIfAbsent(pluralDatatype, datatype);
            }
        } else {
            LoggerFactory.getLogger(App.class).warn("Maximum number of types per app reached - {}.", (Object)Config.MAX_DATATYPES_PER_APP);
        }
    }

    public void removeDatatype(String pluralDatatype) {
        if (!StringUtils.isBlank((CharSequence)pluralDatatype)) {
            this.getDatatypes().remove(pluralDatatype);
        }
    }

    public void resetSecret() {
        this.secret = Utils.generateSecurityToken(40);
    }

    @JsonIgnore
    public Map<String, String> getCredentials() {
        if (this.getId() == null) {
            return Collections.emptyMap();
        }
        return new HashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("accessKey", App.this.getId());
                this.put("secretKey", App.this.getSecret());
            }
        };
    }

    @Override
    public String create() {
        if (this.getId() != null && this.exists()) {
            return null;
        }
        this.resetSecret();
        return this.getDao().create(this);
    }

    @Override
    public void delete() {
        if (!StringUtils.equals((CharSequence)this.getId(), (CharSequence)prefix.concat(Config.APP_NAME_NS))) {
            this.getDao().delete(this);
        }
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getType() {
        this.type = this.type == null ? Utils.type(this.getClass()) : this.type;
        return this.type;
    }

    @Override
    public final void setType(String type) {
        this.type = type;
    }

    @Override
    public String getAppid() {
        this.appid = this.appid == null ? Config.APP_NAME_NS : this.appid;
        return this.appid;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }

    @Override
    public String getObjectURI() {
        return CoreUtils.getObjectURI(this);
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp != null && this.timestamp != 0L ? this.timestamp : null;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getCreatorid() {
        return this.creatorid;
    }

    @Override
    public void setCreatorid(String creatorid) {
        this.creatorid = creatorid;
    }

    @Override
    public final String getName() {
        return CoreUtils.getName(this.name, this.id);
    }

    @Override
    public final void setName(String name) {
        this.name = name == null || !name.isEmpty() ? name : this.name;
    }

    @Override
    public String getPlural() {
        return Utils.singularToPlural(this.getType());
    }

    @Override
    public ParaObject getParent() {
        return this.getDao().read(this.getAppid(), this.parentid);
    }

    @Override
    public ParaObject getCreator() {
        return this.getDao().read(this.getAppid(), this.creatorid);
    }

    @Override
    public String getParentid() {
        return this.parentid;
    }

    @Override
    public void setParentid(String parentid) {
        this.parentid = parentid;
    }

    @Override
    public Long getUpdated() {
        return this.updated != null && this.updated != 0L ? this.updated : null;
    }

    @Override
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Override
    public void update() {
        this.getDao().update(this.getAppid(), this);
    }

    @Override
    public boolean exists() {
        return this.getDao().read(this.id) != null;
    }

    @Override
    public DAO getDao() {
        if (this.dao == null) {
            this.dao = Para.getDAO();
        }
        return this.dao;
    }

    @Override
    public void setDao(DAO dao) {
        this.dao = dao;
    }

    @Override
    public Search getSearch() {
        if (this.search == null) {
            this.search = Para.getSearch();
        }
        return this.search;
    }

    @Override
    public void setSearch(Search search) {
        this.search = search;
    }

    @Override
    public boolean voteUp(String userid) {
        return CoreUtils.vote(this, userid, Votable.VoteValue.UP);
    }

    @Override
    public boolean voteDown(String userid) {
        return CoreUtils.vote(this, userid, Votable.VoteValue.DOWN);
    }

    @Override
    public Integer getVotes() {
        return this.votes == null ? 0 : this.votes;
    }

    @Override
    public void setVotes(Integer votes) {
        this.votes = votes;
    }

    @Override
    public Long countLinks(String type2) {
        return CoreUtils.countLinks(this, type2);
    }

    @Override
    public List<Linker> getLinks(String type2, Pager ... pager) {
        return CoreUtils.getLinks(this, type2, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getLinkedObjects(String type, Pager ... pager) {
        return CoreUtils.getLinkedObjects(this, type, pager);
    }

    @Override
    public boolean isLinked(String type2, String id2) {
        return CoreUtils.isLinked(this, type2, id2);
    }

    @Override
    public boolean isLinked(ParaObject toObj) {
        return CoreUtils.isLinked(this, toObj);
    }

    @Override
    public String link(String id2) {
        return CoreUtils.link(this, id2);
    }

    @Override
    public void unlink(String type, String id2) {
        CoreUtils.unlink(this, type, id2);
    }

    @Override
    public void unlinkAll() {
        CoreUtils.unlinkAll(this);
    }

    @Override
    public Long countChildren(String type) {
        return CoreUtils.countChildren(this, type);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, Pager ... pager) {
        return CoreUtils.getChildren((ParaObject)this, type, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, String field, String term, Pager ... pager) {
        return CoreUtils.getChildren((ParaObject)this, type, field, term, pager);
    }

    @Override
    public void deleteChildren(String type) {
        CoreUtils.deleteChildren(this, type);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.id) + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParaObject other = (ParaObject)obj;
        return Objects.equals(this.id, other.getId());
    }

    public String toString() {
        return ParaObjectUtils.toJSON(this);
    }
}

