/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core;

import com.erudika.para.core.Linker;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Votable;
import com.erudika.para.core.Vote;
import com.erudika.para.utils.Config;
import com.erudika.para.utils.Pager;
import com.erudika.para.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public final class CoreUtils {
    private CoreUtils() {
    }

    public static String getObjectURI(ParaObject obj) {
        String defurl = "/".concat(obj.getPlural());
        return obj.getId() != null ? defurl.concat("/").concat(obj.getId()) : defurl;
    }

    public static String getName(String name, String id) {
        return name == null ? "ParaObject ".concat(id == null ? System.currentTimeMillis() + "" : id) : name;
    }

    public static String overwrite(ParaObject obj) {
        return CoreUtils.overwrite(Config.APP_NAME_NS, obj);
    }

    public static String overwrite(String appid, ParaObject obj) {
        if (obj != null && obj.getId() != null) {
            if (obj.getUpdated() == null) {
                obj.setUpdated(System.currentTimeMillis());
            }
            return obj.getDao().create(appid, obj);
        }
        return null;
    }

    public static List<String> addTags(List<String> objectTags, String ... tag) {
        if (tag != null && tag.length > 0) {
            HashSet<Object> tagz = objectTags == null || objectTags.isEmpty() ? new HashSet() : new HashSet<String>(objectTags);
            for (String t : tag) {
                if (StringUtils.isBlank((CharSequence)t)) continue;
                tagz.add(Utils.noSpaces(Utils.stripAndTrim(t), "-"));
            }
            tagz.remove(null);
            tagz.remove("");
            return new ArrayList<Object>(tagz);
        }
        return objectTags;
    }

    public static List<String> removeTags(List<String> objectTags, String ... tag) {
        if (objectTags != null && tag != null && tag.length > 0) {
            HashSet<String> tagz = new HashSet<String>(objectTags);
            tagz.removeAll(Arrays.asList(tag));
            return new ArrayList<String>(tagz);
        }
        return objectTags;
    }

    public static String link(ParaObject obj, String id2) {
        Object second = obj.getDao().read(obj.getAppid(), id2);
        if (second == null || obj.getId() == null) {
            return null;
        }
        return obj.getDao().create(obj.getAppid(), new Linker(obj.getType(), second.getType(), obj.getId(), id2));
    }

    public static void unlink(ParaObject obj, String type2, String id2) {
        obj.getDao().delete(obj.getAppid(), new Linker(obj.getType(), type2, obj.getId(), id2));
    }

    public static void unlinkAll(ParaObject obj) {
        HashMap<String, String> terms = new HashMap<String, String>();
        terms.put("id1", obj.getId());
        terms.put("id2", obj.getId());
        obj.getDao().deleteAll(obj.getAppid(), obj.getSearch().findTerms(obj.getAppid(), Utils.type(Linker.class), terms, false, new Pager[0]));
    }

    public static List<Linker> getLinks(ParaObject obj, String type2, Pager ... pager) {
        if (type2 == null) {
            return Collections.emptyList();
        }
        Linker link = new Linker(obj.getType(), type2, null, null);
        String idField = link.getIdFieldNameFor(obj.getType());
        HashMap<String, String> terms = new HashMap<String, String>();
        terms.put("name", link.getName());
        terms.put(idField, obj.getId());
        return obj.getSearch().findTerms(obj.getAppid(), link.getType(), terms, true, pager);
    }

    public static boolean isLinked(ParaObject obj, String type2, String id2) {
        if (type2 == null) {
            return false;
        }
        return obj.getDao().read(obj.getAppid(), new Linker(obj.getType(), type2, obj.getId(), id2).getId()) != null;
    }

    public static boolean isLinked(ParaObject obj, ParaObject toObj) {
        if (toObj == null) {
            return false;
        }
        return CoreUtils.isLinked(obj, toObj.getType(), toObj.getId());
    }

    public static Long countLinks(ParaObject obj, String type2) {
        if (obj.getId() == null) {
            return 0L;
        }
        Linker link = new Linker(obj.getType(), type2, null, null);
        String idField = link.getIdFieldNameFor(obj.getType());
        HashMap<String, String> terms = new HashMap<String, String>();
        terms.put("name", link.getName());
        terms.put(idField, obj.getId());
        return obj.getSearch().getCount(obj.getAppid(), link.getType(), terms);
    }

    public static Long countChildren(ParaObject obj, String type2) {
        return obj.getSearch().getCount(obj.getAppid(), type2);
    }

    public static <P extends ParaObject> List<P> getChildren(ParaObject obj, String type2, Pager ... pager) {
        return CoreUtils.getChildren(obj, type2, null, null, pager);
    }

    public static <P extends ParaObject> List<P> getChildren(ParaObject obj, String type2, String field, String term, Pager ... pager) {
        HashMap<String, String> terms = new HashMap<String, String>();
        if (!StringUtils.isBlank((CharSequence)field) && !StringUtils.isBlank((CharSequence)term)) {
            terms.put(field, term);
        }
        terms.put("parentid", obj.getId());
        return obj.getSearch().findTerms(obj.getAppid(), type2, terms, true, pager);
    }

    public static void deleteChildren(ParaObject obj, String type2) {
        if (!StringUtils.isBlank((CharSequence)obj.getId())) {
            obj.getDao().deleteAll(obj.getAppid(), obj.getSearch().findTerms(obj.getAppid(), type2, Collections.singletonMap("parentid", obj.getId()), true, new Pager[0]));
        }
    }

    public static <P extends ParaObject> List<P> getLinkedObjects(ParaObject obj, String type2, Pager ... pager) {
        List<Linker> links = CoreUtils.getLinks(obj, type2, pager);
        LinkedList<String> keys = new LinkedList<String>();
        for (Linker link : links) {
            if (link.isFirst(type2)) {
                keys.add(link.getId1());
                continue;
            }
            keys.add(link.getId2());
        }
        return new ArrayList(obj.getDao().readAll(obj.getAppid(), keys, true).values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean vote(ParaObject votable, String userid, Votable.VoteValue upDown) {
        int vote;
        if (StringUtils.isBlank((CharSequence)userid) || votable == null || votable.getId() == null || upDown == null) {
            return false;
        }
        if (userid.equals(votable.getCreatorid()) || userid.equals(votable.getId())) {
            return false;
        }
        Vote v = new Vote(userid, votable.getId(), upDown.toString());
        Vote saved = (Vote)votable.getDao().read(votable.getAppid(), v.getId());
        boolean done = false;
        int n = vote = upDown == Votable.VoteValue.UP ? 1 : -1;
        if (saved != null) {
            boolean isUpvote = upDown.equals((Object)Votable.VoteValue.UP);
            boolean wasUpvote = Votable.VoteValue.UP.toString().equals(saved.getValue());
            boolean voteHasChanged = BooleanUtils.xor((boolean[])new boolean[]{isUpvote, wasUpvote});
            if (saved.isExpired()) {
                done = votable.getDao().create(votable.getAppid(), v) != null;
            } else if (saved.isAmendable() && voteHasChanged) {
                votable.getDao().delete(votable.getAppid(), saved);
                done = true;
            }
        } else {
            boolean bl = done = votable.getDao().create(votable.getAppid(), v) != null;
        }
        if (done) {
            ParaObject paraObject = votable;
            synchronized (paraObject) {
                votable.setVotes(votable.getVotes() + vote);
            }
        }
        return done;
    }
}

