/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core;

import com.erudika.para.annotations.Locked;
import com.erudika.para.annotations.Stored;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.Sysprop;
import com.erudika.para.utils.Config;
import com.erudika.para.utils.Utils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public final class ParaObjectUtils {
    private static final Logger logger = LoggerFactory.getLogger(ParaObjectUtils.class);
    private static final Map<String, Class<? extends ParaObject>> coreClasses = new DualHashBidiMap();
    private static final CoreClassScanner scanner = new CoreClassScanner();
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private static final ObjectReader jsonReader;
    private static final ObjectWriter jsonWriter;

    private ParaObjectUtils() {
    }

    public static ObjectMapper getJsonMapper() {
        return jsonMapper;
    }

    public static ObjectReader getJsonReader(Class<?> type) {
        return jsonReader.forType(type);
    }

    public static ObjectWriter getJsonWriter() {
        return jsonWriter;
    }

    public static ObjectWriter getJsonWriterNoIdent() {
        return jsonWriter.without(SerializationFeature.INDENT_OUTPUT);
    }

    public static <P extends ParaObject> void populate(P transObject, Map<String, String[]> paramMap) {
        if (transObject == null || paramMap == null || paramMap.isEmpty()) {
            return;
        }
        Class locked = paramMap.containsKey("id") ? Locked.class : null;
        Map<String, Object> fields = ParaObjectUtils.getAnnotatedFields(transObject, locked);
        HashMap<String, Object> data = new HashMap<String, Object>();
        try {
            for (Map.Entry<String, String[]> ks : paramMap.entrySet()) {
                String value;
                String param = ks.getKey();
                String[] values = ks.getValue();
                String string = value = values.length > 1 ? ParaObjectUtils.getJsonWriter().writeValueAsString((Object)values) : values[0];
                if (!fields.containsKey(param)) continue;
                data.put(param, value);
            }
            ParaObjectUtils.setAnnotatedFields(transObject, data, locked);
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
        }
    }

    public static boolean typesMatch(ParaObject so) {
        return so == null ? false : so.getClass().equals(ParaObjectUtils.toClass(so.getType()));
    }

    public static <P extends ParaObject> Map<String, Object> getAnnotatedFields(P pojo) {
        return ParaObjectUtils.getAnnotatedFields(pojo, null);
    }

    public static <P extends ParaObject> Map<String, Object> getAnnotatedFields(P pojo, Class<? extends Annotation> filter) {
        return ParaObjectUtils.getAnnotatedFields(pojo, filter, true);
    }

    public static <P extends ParaObject> Map<String, Object> getAnnotatedFields(P pojo, Class<? extends Annotation> filter, boolean convertNestedToJsonString) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (pojo == null) {
            return map;
        }
        try {
            List<Field> fields = Utils.getAllDeclaredFields(pojo.getClass());
            for (Field field : fields) {
                boolean dontSkip;
                boolean bl = filter == null ? true : (dontSkip = !field.isAnnotationPresent(filter));
                if (!field.isAnnotationPresent(Stored.class) || !dontSkip) continue;
                String name = field.getName();
                Object value = PropertyUtils.getProperty(pojo, (String)name);
                if (!Utils.isBasicType(field.getType()) && convertNestedToJsonString) {
                    value = ParaObjectUtils.getJsonWriterNoIdent().writeValueAsString(value);
                }
                map.put(name, value);
            }
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
        }
        return map;
    }

    public static <P extends ParaObject> P setAnnotatedFields(Map<String, Object> data) {
        return ParaObjectUtils.setAnnotatedFields(null, data, null);
    }

    public static <P extends ParaObject> P setAnnotatedFields(P pojo, Map<String, Object> data, Class<? extends Annotation> filter) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        try {
            if (pojo == null) {
                pojo = ParaObjectUtils.toClass((String)data.get("type")).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            List<Field> fields = Utils.getAllDeclaredFields(pojo.getClass());
            HashMap<String, Object> props = new HashMap<String, Object>(data);
            for (Field field : fields) {
                boolean dontSkip = filter == null ? true : !field.isAnnotationPresent(filter);
                String name = field.getName();
                Object value = data.get(name);
                if (field.isAnnotationPresent(Stored.class) && dontSkip) {
                    if (value == null && PropertyUtils.isReadable((Object)pojo, (String)name)) {
                        value = PropertyUtils.getProperty((Object)pojo, (String)name);
                    }
                    if (!Utils.isBasicType(field.getType()) && value instanceof String) {
                        value = ParaObjectUtils.getJsonReader(field.getType()).readValue(value.toString());
                    }
                    field.setAccessible(true);
                    BeanUtils.setProperty((Object)pojo, (String)name, (Object)value);
                }
                props.remove(name);
            }
            if (!props.isEmpty() && pojo instanceof Sysprop) {
                for (Map.Entry entry : props.entrySet()) {
                    String name = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (PropertyUtils.isReadable((Object)pojo, (String)name)) continue;
                    if (value == null) {
                        ((Sysprop)pojo).removeProperty(name);
                        continue;
                    }
                    ((Sysprop)pojo).addProperty(name, value);
                }
            }
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
            pojo = null;
        }
        return (P)pojo;
    }

    public static <P extends ParaObject> P toObject(String type) {
        try {
            return (P)ParaObjectUtils.toClass(type).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
            return null;
        }
    }

    public static Class<? extends ParaObject> toClass(String type) {
        return ParaObjectUtils.toClass(type, Sysprop.class);
    }

    public static Class<? extends ParaObject> toClass(String type, Class<? extends ParaObject> defaultClass) {
        Class<? extends ParaObject> returnClass = defaultClass;
        if (StringUtils.isBlank((CharSequence)type) || !ParaObjectUtils.getCoreClassesMap().containsKey(type)) {
            return returnClass;
        }
        return ParaObjectUtils.getCoreClassesMap().get(type);
    }

    public static Map<String, Class<? extends ParaObject>> getCoreClassesMap() {
        if (coreClasses.isEmpty()) {
            try {
                Set<Class<? extends ParaObject>> s = scanner.getComponentClasses(ParaObject.class.getPackage().getName());
                if (!Config.CORE_PACKAGE_NAME.isEmpty()) {
                    Set<Class<? extends ParaObject>> s2 = scanner.getComponentClasses(Config.CORE_PACKAGE_NAME);
                    s.addAll(s2);
                }
                for (Class<? extends ParaObject> coreClass : s) {
                    boolean isAbstract = Modifier.isAbstract(coreClass.getModifiers());
                    boolean isInterface = Modifier.isInterface(coreClass.getModifiers());
                    boolean isCoreObject = ParaObject.class.isAssignableFrom(coreClass);
                    if (!isCoreObject || isAbstract || isInterface) continue;
                    coreClasses.put(coreClass.getSimpleName().toLowerCase(), coreClass);
                }
                logger.debug("Found {} ParaObject classes: {}", (Object)coreClasses.size(), coreClasses);
            }
            catch (Exception ex) {
                logger.error(null, (Throwable)ex);
            }
        }
        return Collections.unmodifiableMap(coreClasses);
    }

    public static <P extends ParaObject> P fromJSON(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        try {
            Map map = (Map)ParaObjectUtils.getJsonReader(Map.class).readValue(json);
            return ParaObjectUtils.setAnnotatedFields(map);
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return null;
        }
    }

    public static <P extends ParaObject> String toJSON(P obj) {
        if (obj == null) {
            return "{}";
        }
        try {
            return ParaObjectUtils.getJsonWriter().writeValueAsString(obj);
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
            return "{}";
        }
    }

    static {
        jsonMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        jsonMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        jsonMapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        jsonMapper.enable(SerializationFeature.INDENT_OUTPUT);
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jsonMapper.disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
        jsonReader = jsonMapper.reader();
        jsonWriter = jsonMapper.writer();
    }

    private static class CoreClassScanner
    extends ClassPathScanningCandidateComponentProvider {
        public CoreClassScanner() {
            super(false);
            this.addIncludeFilter((TypeFilter)new AssignableTypeFilter(ParaObject.class));
        }

        public final Set<Class<? extends ParaObject>> getComponentClasses(String basePackage) {
            basePackage = basePackage == null ? "" : basePackage;
            HashSet<Class<? extends ParaObject>> classes = new HashSet<Class<? extends ParaObject>>();
            for (BeanDefinition candidate : this.findCandidateComponents(basePackage)) {
                try {
                    Class cls = ClassUtils.resolveClassName((String)candidate.getBeanClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                    classes.add(cls);
                }
                catch (Exception ex) {
                    this.logger.error(null, (Throwable)ex);
                }
            }
            return classes;
        }
    }
}

