/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core;

import com.erudika.para.Para;
import com.erudika.para.annotations.Locked;
import com.erudika.para.annotations.Stored;
import com.erudika.para.core.CoreUtils;
import com.erudika.para.core.Linker;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.ParaObjectUtils;
import com.erudika.para.core.Votable;
import com.erudika.para.persistence.DAO;
import com.erudika.para.search.Search;
import com.erudika.para.utils.Config;
import com.erudika.para.utils.Pager;
import com.erudika.para.utils.Utils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.NotBlank;

public class Tag
implements ParaObject {
    private static final long serialVersionUID = 1L;
    private static final String prefix = Utils.type(Tag.class).concat(Config.SEPARATOR);
    @Stored
    @Locked
    private String id;
    @Stored
    @Locked
    private Long timestamp;
    @Stored
    @Locked
    private String type;
    @Stored
    @Locked
    private String appid;
    @Stored
    @Locked
    private String parentid;
    @Stored
    @Locked
    private String creatorid;
    @Stored
    private Long updated;
    @Stored
    private String name;
    @Stored
    private List<String> tags;
    @Stored
    private Integer votes;
    @Stored
    @NotBlank
    @Locked
    private String tag;
    @Stored
    private Integer count = 0;
    private transient DAO dao;
    private transient Search search;

    public Tag() {
        this(null);
    }

    public Tag(String id) {
        this.setId(id);
        this.setName(this.getName());
    }

    @Override
    public final void setId(String id) {
        if (StringUtils.startsWith((CharSequence)id, (CharSequence)prefix)) {
            this.setTag(id.replaceAll(prefix, ""));
            this.id = prefix.concat(this.getTag());
        } else if (id != null) {
            this.setTag(id);
            this.id = prefix.concat(this.getTag());
        }
    }

    @Override
    public String getObjectURI() {
        String defurl = "/".concat(this.getPlural());
        return this.getTag() != null ? defurl.concat("/").concat(this.getTag()) : defurl;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = Utils.noSpaces(Utils.stripAndTrim(tag, " "), "-");
    }

    public void incrementCount() {
        Tag tag = this;
        Integer n = tag.count;
        Integer n2 = tag.count = Integer.valueOf(tag.count + 1);
    }

    public void decrementCount() {
        Tag tag = this;
        Integer n = tag.count;
        Integer n2 = tag.count = Integer.valueOf(tag.count - 1);
        if (this.count < 1 && this.exists()) {
            this.delete();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tag other = (Tag)obj;
        return StringUtils.equalsIgnoreCase((CharSequence)this.tag, (CharSequence)other.tag);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + (this.tag != null ? this.tag.hashCode() : 0);
        return hash;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getType() {
        this.type = this.type == null ? Utils.type(this.getClass()) : this.type;
        return this.type;
    }

    @Override
    public final void setType(String type) {
        this.type = type;
    }

    @Override
    public String getAppid() {
        this.appid = this.appid == null ? Config.APP_NAME_NS : this.appid;
        return this.appid;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp != null && this.timestamp != 0L ? this.timestamp : null;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getCreatorid() {
        return this.creatorid;
    }

    @Override
    public void setCreatorid(String creatorid) {
        this.creatorid = creatorid;
    }

    @Override
    public final String getName() {
        return CoreUtils.getName(this.name, this.id);
    }

    @Override
    public final void setName(String name) {
        this.name = name == null || !name.isEmpty() ? name : this.name;
    }

    @Override
    public String getPlural() {
        return Utils.singularToPlural(this.getType());
    }

    @Override
    public ParaObject getParent() {
        return this.getDao().read(this.getAppid(), this.parentid);
    }

    @Override
    public ParaObject getCreator() {
        return this.getDao().read(this.getAppid(), this.creatorid);
    }

    @Override
    public String getParentid() {
        return this.parentid;
    }

    @Override
    public void setParentid(String parentid) {
        this.parentid = parentid;
    }

    @Override
    public Long getUpdated() {
        return this.updated != null && this.updated != 0L ? this.updated : null;
    }

    @Override
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Override
    public String create() {
        return this.getDao().create(this.getAppid(), this);
    }

    @Override
    public void update() {
        this.getDao().update(this.getAppid(), this);
    }

    @Override
    public void delete() {
        this.getDao().delete(this.getAppid(), this);
    }

    @Override
    public boolean exists() {
        return this.getDao().read(this.id) != null;
    }

    @Override
    public DAO getDao() {
        if (this.dao == null) {
            this.dao = Para.getDAO();
        }
        return this.dao;
    }

    @Override
    public void setDao(DAO dao) {
        this.dao = dao;
    }

    @Override
    public Search getSearch() {
        if (this.search == null) {
            this.search = Para.getSearch();
        }
        return this.search;
    }

    @Override
    public void setSearch(Search search) {
        this.search = search;
    }

    @Override
    public boolean voteUp(String userid) {
        return CoreUtils.vote(this, userid, Votable.VoteValue.UP);
    }

    @Override
    public boolean voteDown(String userid) {
        return CoreUtils.vote(this, userid, Votable.VoteValue.DOWN);
    }

    @Override
    public Integer getVotes() {
        return this.votes == null ? 0 : this.votes;
    }

    @Override
    public void setVotes(Integer votes) {
        this.votes = votes;
    }

    @Override
    public Long countLinks(String type2) {
        return CoreUtils.countLinks(this, type2);
    }

    @Override
    public List<Linker> getLinks(String type2, Pager ... pager) {
        return CoreUtils.getLinks(this, type2, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getLinkedObjects(String type, Pager ... pager) {
        return CoreUtils.getLinkedObjects(this, type, pager);
    }

    @Override
    public boolean isLinked(String type2, String id2) {
        return CoreUtils.isLinked(this, type2, id2);
    }

    @Override
    public boolean isLinked(ParaObject toObj) {
        return CoreUtils.isLinked(this, toObj);
    }

    @Override
    public String link(String id2) {
        return CoreUtils.link(this, id2);
    }

    @Override
    public void unlink(String type, String id2) {
        CoreUtils.unlink(this, type, id2);
    }

    @Override
    public void unlinkAll() {
        CoreUtils.unlinkAll(this);
    }

    @Override
    public Long countChildren(String type) {
        return CoreUtils.countChildren(this, type);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, Pager ... pager) {
        return CoreUtils.getChildren((ParaObject)this, type, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, String field, String term, Pager ... pager) {
        return CoreUtils.getChildren((ParaObject)this, type, field, term, pager);
    }

    @Override
    public void deleteChildren(String type) {
        CoreUtils.deleteChildren(this, type);
    }

    public String toString() {
        return ParaObjectUtils.toJSON(this);
    }
}

