/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.core;

import com.erudika.para.Para;
import com.erudika.para.annotations.Locked;
import com.erudika.para.annotations.Stored;
import com.erudika.para.core.CoreUtils;
import com.erudika.para.core.Linker;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.ParaObjectUtils;
import com.erudika.para.core.Votable;
import com.erudika.para.persistence.DAO;
import com.erudika.para.search.Search;
import com.erudika.para.utils.Config;
import com.erudika.para.utils.Pager;
import com.erudika.para.utils.Utils;
import java.util.List;
import java.util.Objects;
import org.hibernate.validator.constraints.NotBlank;

public class Translation
implements ParaObject {
    private static final long serialVersionUID = 1L;
    @Stored
    @Locked
    private String id;
    @Stored
    @Locked
    private Long timestamp;
    @Stored
    @Locked
    private String type;
    @Stored
    @Locked
    private String appid;
    @Stored
    @Locked
    private String parentid;
    @Stored
    @Locked
    private String creatorid;
    @Stored
    private Long updated;
    @Stored
    private String name;
    @Stored
    private List<String> tags;
    @Stored
    private Integer votes;
    @Stored
    @Locked
    @NotBlank
    private String locale;
    @Stored
    @Locked
    @NotBlank
    private String thekey;
    @Stored
    @NotBlank
    private String value;
    @Stored
    private Boolean approved;
    private transient DAO dao;
    private transient Search search;

    public Translation() {
        this(null, null, null);
    }

    public Translation(String id) {
        this();
    }

    public Translation(String locale, String thekey, String value) {
        this.locale = locale;
        this.thekey = thekey;
        this.value = value;
        this.approved = false;
        this.setName(this.getType());
    }

    public Boolean getApproved() {
        return this.approved;
    }

    public void setApproved(Boolean approved) {
        this.approved = approved;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getThekey() {
        return this.thekey;
    }

    public void setThekey(String thekey) {
        this.thekey = thekey;
    }

    @Deprecated
    public void approve() {
        this.approved = true;
        this.update();
    }

    @Deprecated
    public void disapprove() {
        this.approved = false;
        this.update();
    }

    public boolean isApproved() {
        return this.approved != null ? this.approved : false;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final void setId(String id) {
        this.id = id;
    }

    @Override
    public final String getType() {
        this.type = this.type == null ? Utils.type(this.getClass()) : this.type;
        return this.type;
    }

    @Override
    public final void setType(String type) {
        this.type = type;
    }

    @Override
    public String getAppid() {
        this.appid = this.appid == null ? Config.APP_NAME_NS : this.appid;
        return this.appid;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }

    @Override
    public String getObjectURI() {
        return CoreUtils.getObjectURI(this);
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp != null && this.timestamp != 0L ? this.timestamp : null;
    }

    @Override
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getCreatorid() {
        return this.creatorid;
    }

    @Override
    public void setCreatorid(String creatorid) {
        this.creatorid = creatorid;
    }

    @Override
    public final String getName() {
        return CoreUtils.getName(this.name, this.id);
    }

    @Override
    public final void setName(String name) {
        this.name = name == null || !name.isEmpty() ? name : this.name;
    }

    @Override
    public String getPlural() {
        return Utils.singularToPlural(this.getType());
    }

    @Override
    public ParaObject getParent() {
        return this.getDao().read(this.getAppid(), this.parentid);
    }

    @Override
    public ParaObject getCreator() {
        return this.getDao().read(this.getAppid(), this.creatorid);
    }

    @Override
    public String getParentid() {
        return this.parentid;
    }

    @Override
    public void setParentid(String parentid) {
        this.parentid = parentid;
    }

    @Override
    public Long getUpdated() {
        return this.updated != null && this.updated != 0L ? this.updated : null;
    }

    @Override
    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Override
    public String create() {
        return this.getDao().create(this.getAppid(), this);
    }

    @Override
    public void update() {
        this.getDao().update(this.getAppid(), this);
    }

    @Override
    public void delete() {
        this.getDao().delete(this.getAppid(), this);
    }

    @Override
    public boolean exists() {
        return this.getDao().read(this.id) != null;
    }

    @Override
    public DAO getDao() {
        if (this.dao == null) {
            this.dao = Para.getDAO();
        }
        return this.dao;
    }

    @Override
    public void setDao(DAO dao) {
        this.dao = dao;
    }

    @Override
    public Search getSearch() {
        if (this.search == null) {
            this.search = Para.getSearch();
        }
        return this.search;
    }

    @Override
    public void setSearch(Search search) {
        this.search = search;
    }

    @Override
    public boolean voteUp(String userid) {
        return CoreUtils.vote(this, userid, Votable.VoteValue.UP);
    }

    @Override
    public boolean voteDown(String userid) {
        return CoreUtils.vote(this, userid, Votable.VoteValue.DOWN);
    }

    @Override
    public Integer getVotes() {
        return this.votes == null ? 0 : this.votes;
    }

    @Override
    public void setVotes(Integer votes) {
        this.votes = votes;
    }

    @Override
    public Long countLinks(String type2) {
        return CoreUtils.countLinks(this, type2);
    }

    @Override
    public List<Linker> getLinks(String type2, Pager ... pager) {
        return CoreUtils.getLinks(this, type2, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getLinkedObjects(String type, Pager ... pager) {
        return CoreUtils.getLinkedObjects(this, type, pager);
    }

    @Override
    public boolean isLinked(String type2, String id2) {
        return CoreUtils.isLinked(this, type2, id2);
    }

    @Override
    public boolean isLinked(ParaObject toObj) {
        return CoreUtils.isLinked(this, toObj);
    }

    @Override
    public String link(String id2) {
        return CoreUtils.link(this, id2);
    }

    @Override
    public void unlink(String type, String id2) {
        CoreUtils.unlink(this, type, id2);
    }

    @Override
    public void unlinkAll() {
        CoreUtils.unlinkAll(this);
    }

    @Override
    public Long countChildren(String type) {
        return CoreUtils.countChildren(this, type);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, Pager ... pager) {
        return CoreUtils.getChildren((ParaObject)this, type, pager);
    }

    @Override
    public <P extends ParaObject> List<P> getChildren(String type, String field, String term, Pager ... pager) {
        return CoreUtils.getChildren((ParaObject)this, type, field, term, pager);
    }

    @Override
    public void deleteChildren(String type) {
        CoreUtils.deleteChildren(this, type);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.id) + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParaObject other = (ParaObject)obj;
        return Objects.equals(this.id, other.getId());
    }

    public String toString() {
        return ParaObjectUtils.toJSON(this);
    }
}

