/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.rest;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.http.HttpMethodName;
import com.erudika.para.core.ParaObjectUtils;
import com.erudika.para.utils.Config;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Signer
extends AWS4Signer {
    private static final Logger logger = LoggerFactory.getLogger(Signer.class);
    private static final DateTimeFormatter timeFormatter = DateTimeFormat.forPattern((String)"yyyyMMdd'T'HHmmss'Z'").withZoneUTC();

    public Signer() {
        super(false);
        super.setServiceName("para");
    }

    public Map<String, String> sign(String httpeMethod, String endpoint, String resourcePath, Map<String, String> headers, Map<String, String> params, InputStream entity, String accessKey, String secretKey) {
        Request<?> req = this.buildAWSRequest(httpeMethod, endpoint, resourcePath, headers, params, entity);
        this.sign(req, accessKey, secretKey);
        return req.getHeaders();
    }

    public void sign(Request<?> request, String accessKey, String secretKey) {
        super.sign(request, (AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
        this.resetDate();
    }

    public boolean isValidSignature(HttpServletRequest incoming, String secretKey) {
        if (incoming == null || StringUtils.isBlank((CharSequence)secretKey)) {
            return false;
        }
        String auth = incoming.getHeader("Authorization");
        String givenSig = StringUtils.substringAfter((String)auth, (String)"Signature=");
        String sigHeaders = StringUtils.substringBetween((String)auth, (String)"SignedHeaders=", (String)",");
        String credential = StringUtils.substringBetween((String)auth, (String)"Credential=", (String)",");
        String accessKey = StringUtils.substringBefore((String)credential, (String)"/");
        if (StringUtils.isBlank((CharSequence)auth)) {
            givenSig = incoming.getParameter("X-Amz-Signature");
            sigHeaders = incoming.getParameter("X-Amz-SignedHeaders");
            credential = incoming.getParameter("X-Amz-Credential");
            accessKey = StringUtils.substringBefore((String)credential, (String)"/");
        }
        Request<?> awsReq = this.buildAWSRequest(incoming, new HashSet<String>(Arrays.asList(sigHeaders.split(";"))));
        this.sign(awsReq, accessKey, secretKey);
        String auth2 = (String)awsReq.getHeaders().get("Authorization");
        String recreatedSig = StringUtils.substringAfter((String)auth2, (String)"Signature=");
        return StringUtils.equals((CharSequence)givenSig, (CharSequence)recreatedSig);
    }

    public void setRegionName(String regionName) {
    }

    public String getRegionName() {
        return Config.AWS_REGION;
    }

    private void resetDate() {
        this.overriddenDate = null;
    }

    private Request<?> buildAWSRequest(String httpMethod, String endpoint, String resourcePath, Map<String, String> headers, Map<String, String> params, InputStream entity) {
        DefaultRequest r = new DefaultRequest("para");
        if (!StringUtils.isBlank((CharSequence)httpMethod)) {
            r.setHttpMethod(HttpMethodName.valueOf((String)httpMethod));
        }
        if (!StringUtils.isBlank((CharSequence)endpoint)) {
            if (!endpoint.startsWith("http")) {
                endpoint = "https://" + endpoint;
            }
            r.setEndpoint(URI.create(endpoint));
        }
        if (!StringUtils.isBlank((CharSequence)resourcePath)) {
            r.setResourcePath(resourcePath);
        }
        if (headers != null) {
            if (headers.containsKey("x-amz-date")) {
                this.overriddenDate = Signer.parseAWSDate(headers.get("x-amz-date"));
            }
            headers.remove("host");
            headers.remove("x-amz-date");
            r.setHeaders(headers);
        }
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                r.addParameter(param.getKey(), param.getValue());
            }
        }
        if (entity != null) {
            r.setContent(entity);
        }
        return r;
    }

    private Request<?> buildAWSRequest(HttpServletRequest req, Set<String> headersUsed) {
        BufferedInputStream entity;
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String head = ((String)e.nextElement()).toLowerCase();
            if (!headersUsed.contains(head)) continue;
            headers.put(head, req.getHeader(head));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry entry : req.getParameterMap().entrySet()) {
            params.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        String path = req.getRequestURI();
        String string = StringUtils.removeEndIgnoreCase((String)req.getRequestURL().toString(), (String)path);
        String httpMethod = req.getMethod();
        try {
            entity = new BufferedInputStream((InputStream)req.getInputStream());
            if (((InputStream)entity).available() <= 0) {
                entity = null;
            }
        }
        catch (IOException ex) {
            logger.error(null, (Throwable)ex);
            entity = null;
        }
        return this.buildAWSRequest(httpMethod, string, path, headers, params, entity);
    }

    public static Date parseAWSDate(String date) {
        if (date == null) {
            return null;
        }
        return timeFormatter.parseDateTime(date).toDate();
    }

    public Response invokeSignedRequest(Client apiClient, String accessKey, String secretKey, String httpMethod, String endpointURL, String reqPath, Map<String, String> headers, MultivaluedMap<String, String> params, Entity<?> entity) {
        byte[] jsonEntity = null;
        if (entity != null) {
            try {
                jsonEntity = ParaObjectUtils.getJsonWriter().writeValueAsBytes(entity.getEntity());
            }
            catch (JsonProcessingException ex) {
                jsonEntity = null;
                logger.error(null, (Throwable)ex);
            }
        }
        return this.invokeSignedRequest(apiClient, accessKey, secretKey, httpMethod, endpointURL, reqPath, headers, params, jsonEntity);
    }

    public Response invokeSignedRequest(Client apiClient, String accessKey, String secretKey, String httpMethod, String endpointURL, String reqPath, Map<String, String> headers, MultivaluedMap<String, String> params, byte[] jsonEntity) {
        WebTarget target = apiClient.target(endpointURL).path(reqPath);
        Map<String, String> signedHeaders = this.signRequest(accessKey, secretKey, httpMethod, endpointURL, reqPath, headers, params, jsonEntity);
        if (params != null) {
            for (Object param : params.entrySet()) {
                String string = (String)param.getKey();
                List value = (List)param.getValue();
                if (value == null || value.isEmpty() || value.get(0) == null) continue;
                target = target.queryParam(string, value.toArray());
            }
        }
        Invocation.Builder builder = target.request(new String[]{"application/json"});
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                builder.header((String)entry.getKey(), entry.getValue());
            }
        }
        Entity jsonPayload = null;
        if (jsonEntity != null && jsonEntity.length > 0) {
            try {
                jsonPayload = Entity.json((Object)new String(jsonEntity, Config.DEFAULT_ENCODING));
            }
            catch (IOException iOException) {
                logger.error(null, (Throwable)iOException);
            }
        }
        builder.header("Authorization", (Object)signedHeaders.get("Authorization")).header("X-Amz-Date", (Object)signedHeaders.get("X-Amz-Date"));
        if (jsonPayload != null) {
            return builder.method(httpMethod, jsonPayload);
        }
        return builder.method(httpMethod);
    }

    public Map<String, String> signRequest(String accessKey, String secretKey, String httpMethod, String endpointURL, String reqPath, Map<String, String> headers, MultivaluedMap<String, String> params, byte[] jsonEntity) {
        if (StringUtils.isBlank((CharSequence)accessKey) || StringUtils.isBlank((CharSequence)secretKey)) {
            logger.warn("Blank access key or secret key!");
            accessKey = "";
            secretKey = "";
        }
        if (httpMethod == null) {
            httpMethod = "GET";
        }
        BufferedInputStream in = null;
        HashMap<String, String> sigParams = new HashMap<String, String>();
        if (params != null) {
            for (Map.Entry param : params.entrySet()) {
                String key = (String)param.getKey();
                List value = (List)param.getValue();
                if (value == null || value.isEmpty() || value.get(0) == null) continue;
                sigParams.put(key, (String)value.get(0));
            }
        }
        if (jsonEntity != null && jsonEntity.length > 0) {
            in = new BufferedInputStream(new ByteArrayInputStream(jsonEntity));
        }
        return this.sign(httpMethod, endpointURL, reqPath, headers, sigParams, in, accessKey, secretKey);
    }
}

