/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.validation;

import com.erudika.para.annotations.Email;
import com.erudika.para.utils.Utils;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.URL;

public abstract class Constraint {
    private String name;
    private Map<String, Object> payload;
    static Map<Class<? extends Annotation>, String> validators = new HashMap<Class<? extends Annotation>, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(Min.class, "min");
            this.put(Max.class, "max");
            this.put(Size.class, "size");
            this.put(Email.class, "email");
            this.put(Digits.class, "digits");
            this.put(Pattern.class, "pattern");
            this.put(NotNull.class, "required");
            this.put(NotEmpty.class, "required");
            this.put(NotBlank.class, "required");
            this.put(AssertFalse.class, "false");
            this.put(AssertTrue.class, "true");
            this.put(Future.class, "future");
            this.put(Past.class, "past");
            this.put(URL.class, "url");
        }
    };

    public abstract boolean isValid(Object var1);

    private Constraint(String name, Map<String, Object> payload) {
        this.name = name;
        this.payload = payload;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getPayload() {
        if (this.payload == null) {
            this.payload = new LinkedHashMap<String, Object>();
        }
        return this.payload;
    }

    public void setPayload(Map<String, Object> payload) {
        this.payload = payload;
    }

    public static boolean matches(Class<? extends Annotation> anno, String consName) {
        return validators.get(anno).equals(consName);
    }

    public static Constraint fromAnnotation(Annotation anno) {
        if (anno instanceof Min) {
            return Constraint.min(((Min)anno).value());
        }
        if (anno instanceof Max) {
            return Constraint.max(((Max)anno).value());
        }
        if (anno instanceof Size) {
            return Constraint.size(((Size)anno).min(), ((Size)anno).max());
        }
        if (anno instanceof Digits) {
            return Constraint.digits(((Digits)anno).integer(), ((Digits)anno).fraction());
        }
        if (anno instanceof Pattern) {
            return Constraint.pattern(((Pattern)anno).regexp());
        }
        return new Constraint(validators.get(anno.annotationType()), (Map)Constraint.simplePayload(validators.get(anno.annotationType()))){

            @Override
            public boolean isValid(Object actualValue) {
                return true;
            }
        };
    }

    static Map<String, Object> simplePayload(final String name) {
        if (name == null) {
            return null;
        }
        return new LinkedHashMap<String, Object>(){
            {
                this.put("message", "messages." + name);
            }
        };
    }

    static Map<String, Object> minPayload(final Object min) {
        if (min == null) {
            return null;
        }
        return new LinkedHashMap<String, Object>(){
            {
                this.put("value", min);
                this.put("message", "messages." + validators.get(Min.class));
            }
        };
    }

    static Map<String, Object> maxPayload(final Object max) {
        if (max == null) {
            return null;
        }
        return new LinkedHashMap<String, Object>(){
            {
                this.put("value", max);
                this.put("message", "messages." + validators.get(Max.class));
            }
        };
    }

    static Map<String, Object> sizePayload(final Object min, final Object max) {
        if (min == null || max == null) {
            return null;
        }
        return new LinkedHashMap<String, Object>(){
            {
                this.put("min", min);
                this.put("max", max);
                this.put("message", "messages." + validators.get(Size.class));
            }
        };
    }

    static Map<String, Object> digitsPayload(final Object i, final Object f) {
        if (i == null || f == null) {
            return null;
        }
        return new LinkedHashMap<String, Object>(){
            {
                this.put("integer", i);
                this.put("fraction", f);
                this.put("message", "messages." + validators.get(Digits.class));
            }
        };
    }

    static Map<String, Object> patternPayload(final Object regex) {
        if (regex == null) {
            return null;
        }
        return new LinkedHashMap<String, Object>(){
            {
                this.put("value", regex);
                this.put("message", "messages." + validators.get(Pattern.class));
            }
        };
    }

    public static boolean isValidConstraintName(String name) {
        return name != null && validators.containsValue(name.toLowerCase());
    }

    public static boolean isValidConstraintType(Class<? extends Annotation> type) {
        return type != null && validators.containsKey(type);
    }

    public static Constraint required() {
        return new Constraint("required", (Map)Constraint.simplePayload("required")){

            @Override
            public boolean isValid(Object actualValue) {
                return actualValue != null && !StringUtils.isBlank((CharSequence)actualValue.toString());
            }
        };
    }

    public static Constraint min(final Object min) {
        return new Constraint("min", Constraint.minPayload(min)){

            @Override
            public boolean isValid(Object actualValue) {
                if (actualValue != null) {
                    if (!(actualValue instanceof Number)) {
                        return false;
                    }
                    if (min != null && min instanceof Number && ((Number)min).longValue() > ((Number)actualValue).longValue()) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static Constraint max(final Object max) {
        return new Constraint("max", Constraint.maxPayload(max)){

            @Override
            public boolean isValid(Object actualValue) {
                if (actualValue != null) {
                    if (!(actualValue instanceof Number)) {
                        return false;
                    }
                    if (max != null && max instanceof Number && ((Number)max).longValue() < ((Number)actualValue).longValue()) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static Constraint size(final Object min, final Object max) {
        return new Constraint("size", Constraint.sizePayload(min, max)){

            @Override
            public boolean isValid(Object actualValue) {
                if (actualValue != null && min != null && max != null && min instanceof Number && max instanceof Number) {
                    if (actualValue instanceof String) {
                        if ((long)((String)actualValue).length() < ((Number)min).longValue() || (long)((String)actualValue).length() > ((Number)max).longValue()) {
                            return false;
                        }
                    } else if (actualValue instanceof Collection) {
                        if ((long)((Collection)actualValue).size() < ((Number)min).longValue() || (long)((Collection)actualValue).size() > ((Number)max).longValue()) {
                            return false;
                        }
                    } else if (actualValue instanceof Map) {
                        if ((long)((Map)actualValue).size() < ((Number)min).longValue() || (long)((Map)actualValue).size() > ((Number)max).longValue()) {
                            return false;
                        }
                    } else if (actualValue.getClass().isArray()) {
                        int len = ArrayUtils.getLength((Object)actualValue);
                        if ((long)len < ((Number)min).longValue() || (long)len > ((Number)max).longValue()) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static Constraint digits(final Object integer, final Object fraction) {
        return new Constraint("digits", Constraint.digitsPayload(integer, fraction)){

            @Override
            public boolean isValid(Object actualValue) {
                if (actualValue != null) {
                    if (!(actualValue instanceof Number) && !(actualValue instanceof String)) {
                        return false;
                    }
                    if (integer != null && fraction != null && integer instanceof Number && fraction instanceof Number) {
                        String val = actualValue.toString();
                        String[] split = val.split("[,.]");
                        if (!NumberUtils.isDigits((String)split[0])) {
                            return false;
                        }
                        if (((Number)integer).intValue() < split[0].length()) {
                            return false;
                        }
                        if (split.length > 1 && ((Number)fraction).intValue() < split[1].length()) {
                            return false;
                        }
                    }
                }
                return true;
            }
        };
    }

    public static Constraint pattern(final Object regex) {
        return new Constraint("pattern", Constraint.patternPayload(regex)){

            @Override
            public boolean isValid(Object actualValue) {
                return actualValue == null || regex == null || !(regex instanceof String) || actualValue instanceof String && ((String)actualValue).matches((String)regex);
            }
        };
    }

    public static Constraint email() {
        return new Constraint("email", (Map)Constraint.simplePayload("email")){

            @Override
            public boolean isValid(Object actualValue) {
                return actualValue == null || actualValue instanceof String && Utils.isValidEmail((String)actualValue);
            }
        };
    }

    public static Constraint falsy() {
        return new Constraint("false", (Map)Constraint.simplePayload("false")){

            @Override
            public boolean isValid(Object actualValue) {
                return actualValue == null || (!(actualValue instanceof Boolean) || (Boolean)actualValue == false) && (!(actualValue instanceof String) || !Boolean.parseBoolean((String)actualValue));
            }
        };
    }

    public static Constraint truthy() {
        return new Constraint("true", (Map)Constraint.simplePayload("true")){

            @Override
            public boolean isValid(Object actualValue) {
                return actualValue == null || (!(actualValue instanceof Boolean) || (Boolean)actualValue != false) && (!(actualValue instanceof String) || Boolean.parseBoolean((String)actualValue));
            }
        };
    }

    public static Constraint future() {
        return new Constraint("future", (Map)Constraint.simplePayload("future")){

            @Override
            public boolean isValid(Object actualValue) {
                if (actualValue != null) {
                    long now = System.currentTimeMillis();
                    if (actualValue instanceof Date && ((Date)actualValue).getTime() <= now || actualValue instanceof Number && ((Number)actualValue).longValue() <= now) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static Constraint past() {
        return new Constraint("past", (Map)Constraint.simplePayload("past")){

            @Override
            public boolean isValid(Object actualValue) {
                if (actualValue != null) {
                    long now = System.currentTimeMillis();
                    if (actualValue instanceof Date && ((Date)actualValue).getTime() >= now || actualValue instanceof Number && ((Number)actualValue).longValue() >= now) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static Constraint url() {
        return new Constraint("url", (Map)Constraint.simplePayload("url")){

            @Override
            public boolean isValid(Object actualValue) {
                return actualValue == null || Utils.isValidURL(actualValue.toString());
            }
        };
    }

    public static Constraint build(String cname, Map<String, Object> payload) {
        if (cname != null && payload != null && !payload.isEmpty()) {
            if ("required".equals(cname)) {
                return Constraint.required();
            }
            if ("email".equals(cname)) {
                return Constraint.email();
            }
            if ("false".equals(cname)) {
                return Constraint.falsy();
            }
            if ("true".equals(cname)) {
                return Constraint.truthy();
            }
            if ("future".equals(cname)) {
                return Constraint.future();
            }
            if ("past".equals(cname)) {
                return Constraint.past();
            }
            if ("url".equals(cname)) {
                return Constraint.url();
            }
            if ("min".equals(cname) && payload.containsKey("value")) {
                return Constraint.min(payload.get("value"));
            }
            if ("max".equals(cname) && payload.containsKey("value")) {
                return Constraint.max(payload.get("value"));
            }
            if ("size".equals(cname) && payload.containsKey("min") && payload.containsKey("max")) {
                return Constraint.size(payload.get("min"), payload.get("max"));
            }
            if ("digits".equals(cname) && payload.containsKey("integer") && payload.containsKey("fraction")) {
                return Constraint.digits(payload.get("integer"), payload.get("fraction"));
            }
            if ("pattern".equals(cname) && payload.containsKey("value")) {
                return Constraint.pattern(payload.get("value"));
            }
        }
        return null;
    }
}

