/*
 * Decompiled with CFR 0.152.
 */
package com.erudika.para.validation;

import com.erudika.para.annotations.Email;
import com.erudika.para.core.App;
import com.erudika.para.core.ParaObject;
import com.erudika.para.core.ParaObjectUtils;
import com.erudika.para.core.Sysprop;
import com.erudika.para.utils.Utils;
import com.erudika.para.validation.Constraint;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ValidationUtils.class);
    private static Validator validator;

    private ValidationUtils() {
    }

    public static Validator getValidator() {
        if (validator == null) {
            validator = Validation.buildDefaultValidatorFactory().getValidator();
        }
        return validator;
    }

    public static boolean isValidObject(ParaObject obj) {
        return ValidationUtils.validateObject(obj).length == 0;
    }

    public static boolean isValidObject(App app, ParaObject obj) {
        return ValidationUtils.validateObject(app, obj).length == 0;
    }

    public static String[] validateObject(ParaObject content) {
        if (content == null) {
            return new String[]{"Object cannot be null."};
        }
        LinkedList<String> list = new LinkedList<String>();
        try {
            for (ConstraintViolation constraintViolation : ValidationUtils.getValidator().validate((Object)content, new Class[0])) {
                String prop = "'".concat(constraintViolation.getPropertyPath().toString()).concat("'");
                list.add(prop.concat(" ").concat(constraintViolation.getMessage()));
            }
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
        }
        return list.toArray(new String[0]);
    }

    public static String[] validateObject(App app, ParaObject content) {
        if (content == null || app == null) {
            return new String[]{"Object cannot be null."};
        }
        try {
            Map<String, Map<String, Map<String, Object>>> fieldsMap;
            boolean isCustomType;
            String type = content.getType();
            boolean bl = isCustomType = content instanceof Sysprop && !type.equals(Utils.type(Sysprop.class));
            if (!app.getValidationConstraints().isEmpty() && isCustomType && (fieldsMap = app.getValidationConstraints().get(type)) != null && !fieldsMap.isEmpty()) {
                LinkedList<String> errors = new LinkedList<String>();
                for (Map.Entry<String, Map<String, Map<String, Object>>> e : fieldsMap.entrySet()) {
                    String field = e.getKey();
                    Object actualValue = ((Sysprop)content).getProperty(field);
                    if (actualValue == null && PropertyUtils.isReadable((Object)content, (String)field)) {
                        actualValue = PropertyUtils.getProperty((Object)content, (String)field);
                    }
                    Map<String, Map<String, Object>> consMap = e.getValue();
                    for (Map.Entry<String, Map<String, Object>> constraint : consMap.entrySet()) {
                        String consName = constraint.getKey();
                        Map<String, Object> vals = constraint.getValue();
                        if (vals == null) {
                            vals = Collections.emptyMap();
                        }
                        Object val = vals.get("value");
                        Object min = vals.get("min");
                        Object max = vals.get("max");
                        Object in = vals.get("integer");
                        Object fr = vals.get("fraction");
                        if ("required".equals(consName) && !Constraint.required().isValid(actualValue)) {
                            errors.add(Utils.formatMessage("{0} is required.", field));
                            continue;
                        }
                        if (Constraint.matches(Min.class, consName) && !Constraint.min(val).isValid(actualValue)) {
                            errors.add(Utils.formatMessage("{0} must be a number larger than {1}.", field, val));
                            continue;
                        }
                        if (Constraint.matches(Max.class, consName) && !Constraint.max(val).isValid(actualValue)) {
                            errors.add(Utils.formatMessage("{0} must be a number smaller than {1}.", field, val));
                            continue;
                        }
                        if (Constraint.matches(Size.class, consName) && !Constraint.size(min, max).isValid(actualValue)) {
                            errors.add(Utils.formatMessage("{0} must be between {1} and {2}.", field, min, max));
                            continue;
                        }
                        if (Constraint.matches(Email.class, consName) && !Constraint.email().isValid(actualValue)) {
                            errors.add(Utils.formatMessage("{0} is not a valid email.", field));
                            continue;
                        }
                        if (Constraint.matches(Digits.class, consName) && !Constraint.digits(in, fr).isValid(actualValue)) {
                            errors.add(Utils.formatMessage("{0} is not a valid number or within range.", field));
                            continue;
                        }
                        if (Constraint.matches(Pattern.class, consName) && !Constraint.pattern(val).isValid(actualValue)) {
                            errors.add(Utils.formatMessage("{0} doesn't match the pattern {1}.", field, val));
                            continue;
                        }
                        if (Constraint.matches(AssertFalse.class, consName) && !Constraint.falsy().isValid(actualValue)) {
                            errors.add(Utils.formatMessage("{0} must be false.", field));
                            continue;
                        }
                        if (Constraint.matches(AssertTrue.class, consName) && !Constraint.truthy().isValid(actualValue)) {
                            errors.add(Utils.formatMessage("{0} must be true.", field));
                            continue;
                        }
                        if (Constraint.matches(Future.class, consName) && !Constraint.future().isValid(actualValue)) {
                            errors.add(Utils.formatMessage("{0} must be in the future.", field));
                            continue;
                        }
                        if (Constraint.matches(Past.class, consName) && !Constraint.past().isValid(actualValue)) {
                            errors.add(Utils.formatMessage("{0} must be in the past.", field));
                            continue;
                        }
                        if (!Constraint.matches(URL.class, consName) || Constraint.url().isValid(actualValue)) continue;
                        errors.add(Utils.formatMessage("{0} is not a valid URL.", field));
                    }
                }
                if (!errors.isEmpty()) {
                    return errors.toArray(new String[0]);
                }
            }
        }
        catch (Exception ex) {
            logger.error(null, (Throwable)ex);
        }
        return ValidationUtils.validateObject(content);
    }

    public static Map<String, Map<String, Map<String, Object>>> getValidationConstraints(App app, String type) {
        HashMap<String, Map<String, Map<String, Object>>> fieldsMap = new HashMap<String, Map<String, Map<String, Object>>>();
        if (app != null && !StringUtils.isBlank((CharSequence)type)) {
            try {
                List<Field> fieldlist = Utils.getAllDeclaredFields(ParaObjectUtils.toClass(type));
                for (Field field : fieldlist) {
                    Annotation[] annos = field.getAnnotations();
                    if (annos.length <= 1) continue;
                    HashMap<String, Map<String, Object>> consMap = new HashMap<String, Map<String, Object>>();
                    for (Annotation anno : annos) {
                        Constraint c;
                        if (!Constraint.isValidConstraintType(anno.annotationType()) || (c = Constraint.fromAnnotation(anno)) == null) continue;
                        consMap.put(c.getName(), c.getPayload());
                    }
                    if (consMap.size() <= 0) continue;
                    fieldsMap.put(field.getName(), consMap);
                }
                Map<String, Map<String, Map<String, Object>>> appConstraints = app.getValidationConstraints().get(type);
                if (appConstraints != null && !appConstraints.isEmpty()) {
                    fieldsMap.putAll(appConstraints);
                }
            }
            catch (Exception ex) {
                logger.error(null, (Throwable)ex);
            }
        }
        return fieldsMap;
    }

    public static String getAllValidationConstraints(App app, Collection<String> allTypes) {
        String json = "{}";
        if (allTypes != null && !allTypes.isEmpty()) {
            try {
                ObjectNode parentNode = ParaObjectUtils.getJsonMapper().createObjectNode();
                for (String type : allTypes) {
                    Map<String, Map<String, Map<String, Object>>> constraintsNode = ValidationUtils.getValidationConstraints(app, type);
                    if (constraintsNode.size() <= 0) continue;
                    parentNode.putPOJO(type, constraintsNode);
                }
                json = ParaObjectUtils.getJsonWriter().writeValueAsString((Object)parentNode);
            }
            catch (IOException ex) {
                logger.error(null, (Throwable)ex);
            }
        }
        return json;
    }
}

